/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.utils.oauth10;

import com.infor.erpln.utils.oauth10.OAuthUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

class Rfc5849Parameters {
    private final SortedMap<String, String> m_parameters = new TreeMap<String, String>();

    Rfc5849Parameters() {
    }

    public void addFromQueryString(String queryString) throws UnsupportedEncodingException {
        if (StringUtils.isNotBlank((String)queryString)) {
            String[] elements;
            for (String element : elements = StringUtils.split((String)queryString, (char)'&')) {
                String[] pair = element.split("=");
                String name = pair[0];
                String value = pair.length > 1 ? pair[1] : "";
                this.m_parameters.put(URLDecoder.decode(name, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
        }
    }

    public void addFromOAuthHeader(Map<String, String> fields) {
        this.m_parameters.putAll(fields);
    }

    public void addFromRequestBody(String body) {
        throw new UnsupportedOperationException();
    }

    public String getNormalized() {
        StringBuilder normalized = new StringBuilder();
        for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
            if (normalized.length() > 0) {
                normalized.append('&');
            }
            normalized.append(OAuthUtil.percentEncode(entry.getKey())).append('=');
            if (!StringUtils.isNotBlank((String)entry.getValue())) continue;
            normalized.append(OAuthUtil.percentEncode(entry.getValue()));
        }
        return normalized.toString();
    }
}

