/*
 * Decompiled with CFR 0.152.
 */
package com.infor.erpln.utils.oauth10;

import java.io.PrintWriter;

public class AuthorizationStatus {
    private Code m_errorCode = Code.OK;
    private String m_errorMessage = "";

    public boolean isOk() {
        return this.m_errorCode == Code.OK;
    }

    public AuthorizationStatus error(String message) {
        this.m_errorCode = Code.ERROR;
        this.m_errorMessage = message;
        return this;
    }

    public AuthorizationStatus unauthorized(String message) {
        this.m_errorCode = Code.UNAUTHORIZED;
        this.m_errorMessage = message;
        return this;
    }

    public AuthorizationStatus badRequest(String message) {
        this.m_errorCode = Code.BAD_REQUEST;
        this.m_errorMessage = message;
        return this;
    }

    public AuthorizationStatus ok() {
        this.m_errorCode = Code.OK;
        this.m_errorMessage = "";
        return this;
    }

    public int getErrorCode() {
        return this.m_errorCode.m_value;
    }

    public String toString() {
        return (Object)((Object)this.m_errorCode) + "[" + this.m_errorMessage + "]";
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    public void printJson(PrintWriter writer) {
        if (!this.isOk()) {
            writer.append("{ \"code\": ").append(Integer.toString(this.m_errorCode.m_value));
            writer.append(", \"message\": \"").append(this.m_errorMessage).append("\" }");
        }
    }

    private static enum Code {
        OK(200),
        ERROR(500),
        BAD_REQUEST(400),
        UNAUTHORIZED(401);

        private int m_value;

        private Code(int value) {
            this.m_value = value;
        }
    }
}

