/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.layout.font.Range;
import com.itextpdf.layout.font.RangeBuilder;
import com.itextpdf.layout.properties.BlendMode;
import com.itextpdf.styledxmlparser.css.parse.CssDeclarationValueTokenizer;
import com.itextpdf.styledxmlparser.css.util.CssPropertyNormalizer;
import com.itextpdf.styledxmlparser.css.util.EscapeGroup;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssUtils {
    private static final float EPSILON = 1.0E-6f;
    private static final Logger logger = LoggerFactory.getLogger(CssUtils.class);
    private static final int QUANTITY_OF_PARAMS_WITH_FALLBACK_OR_TYPE = 2;

    private CssUtils() {
    }

    public static List<String> splitStringWithComma(String value) {
        return CssUtils.splitString(value, ',', new EscapeGroup('(', ')'));
    }

    public static List<String> splitString(String value, char splitChar, EscapeGroup ... escapeCharacters) {
        if (value == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> resultList = new ArrayList<String>();
        int lastSplitChar = 0;
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            boolean isEscaped = false;
            for (EscapeGroup character : escapeCharacters) {
                if (currentChar == splitChar) {
                    isEscaped = isEscaped || character.isEscaped();
                    continue;
                }
                character.processCharacter(currentChar);
            }
            if (currentChar != splitChar || isEscaped) continue;
            resultList.add(value.substring(lastSplitChar, i));
            lastSplitChar = i + 1;
        }
        String lastToken = value.substring(lastSplitChar);
        if (!lastToken.isEmpty()) {
            resultList.add(lastToken);
        }
        return resultList;
    }

    public static BlendMode parseBlendMode(String cssValue) {
        if (cssValue == null) {
            return BlendMode.NORMAL;
        }
        switch (cssValue) {
            case "multiply": {
                return BlendMode.MULTIPLY;
            }
            case "screen": {
                return BlendMode.SCREEN;
            }
            case "overlay": {
                return BlendMode.OVERLAY;
            }
            case "darken": {
                return BlendMode.DARKEN;
            }
            case "lighten": {
                return BlendMode.LIGHTEN;
            }
            case "color-dodge": {
                return BlendMode.COLOR_DODGE;
            }
            case "color-burn": {
                return BlendMode.COLOR_BURN;
            }
            case "hard-light": {
                return BlendMode.HARD_LIGHT;
            }
            case "soft-light": {
                return BlendMode.SOFT_LIGHT;
            }
            case "difference": {
                return BlendMode.DIFFERENCE;
            }
            case "exclusion": {
                return BlendMode.EXCLUSION;
            }
            case "hue": {
                return BlendMode.HUE;
            }
            case "saturation": {
                return BlendMode.SATURATION;
            }
            case "color": {
                return BlendMode.COLOR;
            }
            case "luminosity": {
                return BlendMode.LUMINOSITY;
            }
        }
        return BlendMode.NORMAL;
    }

    public static List<List<String>> extractShorthandProperties(String str) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> currentLayer = new ArrayList<String>();
        CssDeclarationValueTokenizer tokenizer = new CssDeclarationValueTokenizer(str);
        CssDeclarationValueTokenizer.Token currentToken = tokenizer.getNextValidToken();
        while (currentToken != null) {
            if (currentToken.getType() == CssDeclarationValueTokenizer.TokenType.COMMA) {
                result.add(currentLayer);
                currentLayer = new ArrayList();
            } else {
                currentLayer.add(currentToken.getValue());
            }
            currentToken = tokenizer.getNextValidToken();
        }
        result.add(currentLayer);
        return result;
    }

    public static String normalizeCssProperty(String str) {
        return str == null ? null : CssPropertyNormalizer.normalize(str);
    }

    public static String removeDoubleSpacesAndTrim(String str) {
        String[] parts = str.split("\\s");
        StringBuilder sb = new StringBuilder();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(part);
        }
        return sb.toString();
    }

    public static String extractUrl(String url) {
        String urlString;
        String str = null;
        str = url.startsWith("url") ? ((urlString = url.substring(3).trim().replace("(", "").replace(")", "").trim()).startsWith("'") && urlString.endsWith("'") ? urlString.substring(urlString.indexOf("'") + 1, urlString.lastIndexOf("'")) : (urlString.startsWith("\"") && urlString.endsWith("\"") ? urlString.substring(urlString.indexOf(34) + 1, urlString.lastIndexOf(34)) : urlString)) : url;
        return str;
    }

    public static String extractAttributeValue(String attrStr, IElementNode element) {
        String attrValue = null;
        if (attrStr.startsWith("attr(") && attrStr.length() > "attr".length() + 2 && attrStr.endsWith(")")) {
            List<String> params;
            String fallback = null;
            String typeOfAttribute = null;
            String stringToSplit = attrStr.substring(5, attrStr.length() - 1);
            List<String> paramsWithFallback = CssUtils.splitString(stringToSplit, ',', new EscapeGroup('\"'), new EscapeGroup('\''));
            if (paramsWithFallback.size() > 2) {
                return null;
            }
            if (paramsWithFallback.size() == 2) {
                fallback = CssUtils.extractFallback(paramsWithFallback.get(1));
            }
            if ((params = CssUtils.splitString(paramsWithFallback.get(0), ' ', new EscapeGroup[0])).size() > 2) {
                return null;
            }
            if (params.size() == 2 && (typeOfAttribute = CssUtils.extractTypeOfAttribute(params.get(1))) == null) {
                return null;
            }
            String attributeName = params.get(0);
            if (CssUtils.isAttributeNameValid(attributeName)) {
                attrValue = CssUtils.getAttributeValue(attributeName, typeOfAttribute, fallback, element);
            }
        }
        return attrValue;
    }

    public static int findNextUnescapedChar(String source, char ch, int startIndex) {
        int afterNoneEscapePos;
        int symbolPos = source.indexOf(ch, startIndex);
        if (symbolPos == -1) {
            return -1;
        }
        for (afterNoneEscapePos = symbolPos; afterNoneEscapePos > 0 && source.charAt(afterNoneEscapePos - 1) == '\\'; --afterNoneEscapePos) {
        }
        return (symbolPos - afterNoneEscapePos) % 2 == 0 ? symbolPos : CssUtils.findNextUnescapedChar(source, ch, symbolPos + 1);
    }

    public static boolean compareFloats(double d1, double d2) {
        return Math.abs(d1 - d2) < (double)1.0E-6f;
    }

    public static boolean compareFloats(float f1, float f2) {
        return Math.abs(f1 - f2) < 1.0E-6f;
    }

    public static Range parseUnicodeRange(String unicodeRange) {
        String[] ranges = unicodeRange.split(",");
        RangeBuilder builder = new RangeBuilder();
        for (String range : ranges) {
            if (CssUtils.addRange(builder, range)) continue;
            return null;
        }
        return builder.create();
    }

    public static float convertPtsToPx(float pts) {
        return pts / 0.75f;
    }

    public static double convertPtsToPx(double pts) {
        return pts / 0.75;
    }

    public static float convertPxToPts(float px) {
        return px * 0.75f;
    }

    public static double convertPxToPts(double px) {
        return px * 0.75;
    }

    public static boolean isStyleSheetLink(IElementNode headChildElement) {
        return "link".equals(headChildElement.name()) && "stylesheet".equals(headChildElement.getAttribute("rel"));
    }

    private static boolean addRange(RangeBuilder builder, String range) {
        if ((range = range.trim()).matches("[uU]\\+[0-9a-fA-F?]{1,6}(-[0-9a-fA-F]{1,6})?")) {
            String[] parts = range.substring(2, range.length()).split("-");
            if (1 == parts.length) {
                if (parts[0].contains("?")) {
                    return CssUtils.addRange(builder, parts[0].replace('?', '0'), parts[0].replace('?', 'F'));
                }
                return CssUtils.addRange(builder, parts[0], parts[0]);
            }
            return CssUtils.addRange(builder, parts[0], parts[1]);
        }
        return false;
    }

    private static boolean addRange(RangeBuilder builder, String left, String right) {
        int r;
        int l = Integer.parseInt(left, 16);
        if (l > (r = Integer.parseInt(right, 16)) || r > 0x10FFFF) {
            return false;
        }
        builder.addRange(l, r);
        return true;
    }

    private static boolean isAttributeNameValid(String attributeName) {
        return !attributeName.contains("'") && !attributeName.contains("\"") && !attributeName.contains("(") && !attributeName.contains(")");
    }

    private static String extractFallback(String fallbackString) {
        String tmpString = fallbackString.startsWith("'") && fallbackString.endsWith("'") || fallbackString.startsWith("\"") && fallbackString.endsWith("\"") ? fallbackString.substring(1, fallbackString.length() - 1) : fallbackString;
        return CssUtils.extractUrl(tmpString);
    }

    private static String extractTypeOfAttribute(String typeString) {
        if (typeString.equals("url") || typeString.equals("string")) {
            return typeString;
        }
        return null;
    }

    private static String getAttributeValue(String attributeName, String typeOfAttribute, String fallback, IElementNode elementNode) {
        String returnString = elementNode.getAttribute(attributeName);
        if ("url".equals(typeOfAttribute)) {
            returnString = returnString == null ? null : CssUtils.extractUrl(returnString);
        } else {
            String string = returnString = returnString == null ? "" : returnString;
        }
        if (fallback != null && (returnString == null || returnString.isEmpty())) {
            returnString = fallback;
        }
        return returnString;
    }
}

