/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.shaping;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.FeatureRecord;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.GlyphPositioningTableReader;
import com.itextpdf.io.font.otf.GlyphSubstitutionTableReader;
import com.itextpdf.io.font.otf.LanguageRecord;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OpenTypeGdefTableReader;
import com.itextpdf.io.util.EnumUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.typography.actions.events.PdfCalligraphProductEvent;
import com.itextpdf.typography.clustering.ClusterCreatorUtil;
import com.itextpdf.typography.clustering.indic.IndicClusterCreationHelper;
import com.itextpdf.typography.clustering.myanmar.MyanmarClusterCreationHelper;
import com.itextpdf.typography.config.IFeaturesConfig;
import com.itextpdf.typography.config.TypographyConfigurator;
import com.itextpdf.typography.ordering.TypographyCluster;
import com.itextpdf.typography.ordering.indic.IndicCluster;
import com.itextpdf.typography.ordering.indic.IndicConfig;
import com.itextpdf.typography.ordering.indic.IndicFeatures;
import com.itextpdf.typography.ordering.indic.IndicShaper;
import com.itextpdf.typography.ordering.myanmar.MyanmarCluster;
import com.itextpdf.typography.ordering.myanmar.MyanmarShaper;
import com.itextpdf.typography.ordering.thai.ThaiCluster;
import com.itextpdf.typography.ordering.thai.ThaiShaper;
import com.itextpdf.typography.shaping.ComplexShaper;
import java.text.Normalizer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Shaper {
    private static final Logger logger = LoggerFactory.getLogger(Shaper.class);
    private static final Set<Character.UnicodeScript> supportedScripts = Collections.unmodifiableSet(new HashSet<Character.UnicodeScript>(Arrays.asList(Character.UnicodeScript.ARMENIAN, Character.UnicodeScript.CYRILLIC, Character.UnicodeScript.GEORGIAN, Character.UnicodeScript.GREEK, Character.UnicodeScript.LATIN, Character.UnicodeScript.RUNIC, Character.UnicodeScript.OGHAM, Character.UnicodeScript.ARABIC, Character.UnicodeScript.BENGALI, Character.UnicodeScript.DEVANAGARI, Character.UnicodeScript.GUJARATI, Character.UnicodeScript.GURMUKHI, Character.UnicodeScript.HEBREW, Character.UnicodeScript.KANNADA, Character.UnicodeScript.KHMER, Character.UnicodeScript.MALAYALAM, Character.UnicodeScript.MYANMAR, Character.UnicodeScript.ORIYA, Character.UnicodeScript.TAMIL, Character.UnicodeScript.TELUGU, Character.UnicodeScript.THAI)));
    private static final int[] ARABIC_LETTERS_WHICH_HAVE_ONLY_ISOLATED_AND_FINAL_FORMS = new int[]{1575, 1577, 1583, 1584, 1585, 1586, 1608, 1746};
    private static final Map<Character.UnicodeScript, String[]> otfScriptTags = new HashMap<Character.UnicodeScript, String[]>();

    private Shaper() {
    }

    static boolean applyOtfScript(TrueTypeFont font, GlyphLine glyphLine, Character.UnicodeScript script, SequenceId id, IMetaInfo metaInfo) {
        return Shaper.applyOtfScript(font, glyphLine, script, new TypographyConfigurator(), id, metaInfo);
    }

    static boolean applyOtfScript(TrueTypeFont font, GlyphLine glyphLine, Character.UnicodeScript script, TypographyConfigurator configurator, SequenceId id, IMetaInfo metaInfo) {
        EventManager.getInstance().onEvent((IEvent)PdfCalligraphProductEvent.createShapeScriptsEvent(id, metaInfo));
        LinkedHashMap<String, List<OpenTableLookup>> extractedScriptFeatures = new LinkedHashMap<String, List<OpenTableLookup>>();
        String usedScriptTag = Shaper.extractFeatures(font, script, extractedScriptFeatures);
        IFeaturesConfig featuresConfig = configurator.getFeatureConfig(script);
        if (featuresConfig != null) {
            return Shaper.applyFeaturesInOrder(glyphLine, extractedScriptFeatures, featuresConfig.listFeatures());
        }
        boolean transformed = false;
        switch (script) {
            case ARABIC: {
                transformed = Shaper.applyArabicScript(font, glyphLine, extractedScriptFeatures);
                break;
            }
            case ARMENIAN: 
            case CYRILLIC: 
            case GEORGIAN: 
            case GREEK: 
            case LATIN: 
            case RUNIC: 
            case OGHAM: {
                ArrayList<String> stdRequiredFeatures = new ArrayList<String>(Arrays.asList("mark", "mkmk"));
                transformed = Shaper.applyFeaturesInOrder(glyphLine, extractedScriptFeatures, stdRequiredFeatures);
                break;
            }
            case DEVANAGARI: 
            case TAMIL: 
            case GURMUKHI: 
            case ORIYA: 
            case BENGALI: 
            case MALAYALAM: 
            case TELUGU: 
            case GUJARATI: 
            case KANNADA: 
            case KHMER: {
                transformed = Shaper.applyIndicScript(font, glyphLine, script, usedScriptTag, extractedScriptFeatures);
                break;
            }
            case HEBREW: {
                transformed = Shaper.applyFeaturesInOrder(glyphLine, extractedScriptFeatures, Collections.singletonList("mark"));
                break;
            }
            case MYANMAR: {
                boolean isMymr = false;
                if (extractedScriptFeatures.isEmpty()) {
                    Shaper.extractFeatures(font, new String[]{"mymr"}, extractedScriptFeatures);
                    isMymr = true;
                }
                transformed = Shaper.applyMyanmarScript(glyphLine, extractedScriptFeatures, isMymr, font);
                break;
            }
            case THAI: {
                transformed = Shaper.applyThaiScript(font, glyphLine, extractedScriptFeatures);
            }
        }
        return transformed;
    }

    static Set<Character.UnicodeScript> getSupportedScripts() {
        return supportedScripts;
    }

    static Set<Character.UnicodeScript> getSupportedScripts(TypographyConfigurator configurator) {
        HashSet<Character.UnicodeScript> scripts = new HashSet<Character.UnicodeScript>(Shaper.getSupportedScripts());
        scripts.addAll(configurator.getConfiguredScripts());
        return Collections.unmodifiableSet(scripts);
    }

    static boolean applyKerning(FontProgram fontProgram, GlyphLine text, SequenceId id, IMetaInfo metaInfo) {
        EventManager.getInstance().onEvent((IEvent)PdfCalligraphProductEvent.createShapeScriptsEvent(id, metaInfo));
        boolean transformed = false;
        if (text.size() > 0 && fontProgram != null) {
            for (int iter = 1; iter < text.size(); ++iter) {
                int kern = fontProgram.getKerning(text.get(iter - 1), text.get(iter));
                if (kern == 0) continue;
                text.set(iter - 1, new Glyph(text.get(iter - 1), 0, 0, kern, 0, 0));
                transformed = true;
            }
        }
        return transformed;
    }

    static boolean applyLigaFeature(TrueTypeFont font, GlyphLine glyphLine, Character.UnicodeScript script) {
        String[] otfScriptTags = Shaper.getOtfScriptTags(script);
        GlyphSubstitutionTableReader gsubTable = font.getGsubTable();
        if (gsubTable != null) {
            ArrayList<FeatureRecord> ligaFeatures = new ArrayList<FeatureRecord>();
            if (otfScriptTags != null) {
                String otfScriptTag;
                LanguageRecord languageRecord = null;
                String[] objectArray = otfScriptTags;
                int n = objectArray.length;
                for (int i = 0; i < n && (languageRecord = gsubTable.getLanguageRecord(otfScriptTag = objectArray[i])) == null; ++i) {
                }
                if (languageRecord == null) {
                    return false;
                }
                for (int featureIndex : languageRecord.features) {
                    FeatureRecord feature = (FeatureRecord)gsubTable.getFeatureRecords().get(featureIndex);
                    if (!feature.tag.equals("liga")) continue;
                    ligaFeatures.add(feature);
                }
            } else {
                for (FeatureRecord featureRecord : gsubTable.getFeatureRecords()) {
                    if (!featureRecord.tag.equals("liga")) continue;
                    ligaFeatures.add(featureRecord);
                }
            }
            if (ligaFeatures.size() > 0) {
                boolean transformed = false;
                if (glyphLine != null) {
                    List list = gsubTable.getLookups(ligaFeatures.toArray(new FeatureRecord[ligaFeatures.size()]));
                    for (OpenTableLookup lookup : list) {
                        if (lookup != null && lookup.transformLine(glyphLine)) {
                            transformed = true;
                        }
                        glyphLine.idx = 0;
                    }
                }
                return transformed;
            }
        }
        return false;
    }

    private static boolean applyFeaturesInOrder(GlyphLine glyphLine, Map<String, List<OpenTableLookup>> scriptFeatures, List<String> featuresToApply) {
        boolean transformed = false;
        for (String feature : featuresToApply) {
            if (!Shaper.transformLine(scriptFeatures.get(feature), glyphLine)) continue;
            transformed = true;
        }
        return transformed;
    }

    private static boolean applyArabicScript(TrueTypeFont font, GlyphLine glyphLine, Map<String, List<OpenTableLookup>> scriptFeatures) {
        List<OpenTableLookup> init = scriptFeatures.get("init");
        List<OpenTableLookup> medi = scriptFeatures.get("medi");
        List<OpenTableLookup> fina = scriptFeatures.get("fina");
        List<OpenTableLookup> rlig = scriptFeatures.get("rlig");
        boolean transformed = false;
        List<Integer> words = Shaper.splitArabicGlyphLineIntoWords(glyphLine, init, medi, fina, font.getGdefTable());
        if (Shaper.applyInitMediFinaShaping(glyphLine, init, medi, fina, font.getGdefTable(), words)) {
            transformed = true;
        }
        int glStart = glyphLine.start;
        int glEnd = glyphLine.end;
        int delta = 0;
        for (int i = 0; i < words.size(); i += 2) {
            int initialGlStart = words.get(i) + delta;
            int initialGlEnd = words.get(i + 1) + delta;
            glyphLine.start = initialGlStart;
            glyphLine.end = initialGlEnd;
            if (Shaper.applyRligFeature(glyphLine, rlig)) {
                transformed = true;
            }
            delta += glyphLine.end - initialGlEnd;
            words.set(i, glyphLine.start);
            words.set(i + 1, glyphLine.end);
        }
        glEnd += delta;
        String[] positioning = new String[]{"curs", "mark", "mkmk"};
        for (int i = 0; i < words.size(); i += 2) {
            glyphLine.start = words.get(i);
            glyphLine.end = words.get(i + 1);
            for (String feature : positioning) {
                if (!Shaper.transformLine(scriptFeatures.get(feature), glyphLine)) continue;
                transformed = true;
            }
        }
        glyphLine.start = glStart;
        glyphLine.end = glEnd;
        return transformed;
    }

    private static boolean applyThaiScript(TrueTypeFont font, GlyphLine glyphLine, Map<String, List<OpenTableLookup>> features) {
        boolean transformed = false;
        List<ThaiCluster> clusters = ThaiShaper.splitThaiGlyphLineIntoClusters(glyphLine);
        for (ThaiCluster cluster : clusters) {
            if (ThaiShaper.preprocessThaiText(font, cluster, features.size() != 0)) {
                transformed = true;
            }
            if (Shaper.transformLine(features.get("ccmp"), cluster)) {
                transformed = true;
            }
            transformed = Shaper.positionComplex(ComplexShaper.getThaiInstance(), features, cluster, font, (posFeatures, curCluster) -> Shaper.applyThaiPositioning(posFeatures, curCluster)) || transformed;
        }
        GlyphLine newGlyphLine = glyphLine.copy(0, glyphLine.start);
        int newStart = newGlyphLine.size();
        for (ThaiCluster cluster : clusters) {
            newGlyphLine.add((GlyphLine)cluster);
        }
        int newEnd = newGlyphLine.size();
        for (int i = glyphLine.end; i < glyphLine.size(); ++i) {
            newGlyphLine.add(glyphLine.get(i));
        }
        newGlyphLine.start = newStart;
        newGlyphLine.end = newEnd;
        glyphLine.replaceContent(newGlyphLine);
        return transformed;
    }

    private static boolean applyThaiPositioning(Map<String, List<OpenTableLookup>> features, GlyphLine cluster) {
        String[] positioning = new String[]{"mark", "mkmk", "liga"};
        boolean transformed = false;
        for (String feature : positioning) {
            if (!Shaper.transformLine(features.get(feature), cluster)) continue;
            transformed = true;
        }
        return transformed;
    }

    private static boolean applyIndicScript(TrueTypeFont font, GlyphLine glyphLine, Character.UnicodeScript script, String otfScriptTag, Map<String, List<OpenTableLookup>> features) {
        boolean transformed = false;
        if (otfScriptTag == null) {
            return transformed;
        }
        Shaper.unicodeDecompose(font, glyphLine);
        IndicShaper.indicDecompose((FontProgram)font, glyphLine);
        List<TypographyCluster> clusters = ClusterCreatorUtil.splitTypographyGlyphLineIntoClusters(glyphLine, new IndicClusterCreationHelper());
        if (clusters.size() > 0) {
            for (int clusterId = 0; clusterId < clusters.size(); ++clusterId) {
                Feature[] positioning;
                String[] discretionary;
                Feature[] basicShapingForms;
                TypographyCluster cluster = clusters.get(clusterId);
                IndicConfig indicConfig = IndicConfig.getConfig(script);
                boolean isOldSpec = indicConfig.hasOldSpec() && !otfScriptTag.endsWith("2");
                Shaper.transformLine(features.get("locl"), cluster);
                Shaper.transformLine(features.get("ccmp"), cluster);
                IndicShaper.updateConsonantPositions(font, (IndicCluster)cluster, indicConfig, features.get("blwf"), features.get("pstf"), features.get("pref"));
                IndicShaper.initialReordering((IndicCluster)cluster, indicConfig, features.get("rphf"), features.get("pref"), isOldSpec, script);
                for (Feature feature : basicShapingForms = new Feature[]{new Feature("nukt", true, IndicFeatures.getMask(0)), new Feature("akhn", true, IndicFeatures.getMask(1)), new Feature("rphf", false, IndicFeatures.getMask(2)), new Feature("rkrf", true, IndicFeatures.getMask(3)), new Feature("pref", false, IndicFeatures.getMask(4)), new Feature("blwf", false, IndicFeatures.getMask(5)), new Feature("abvf", false, IndicFeatures.getMask(6)), new Feature("half", false, IndicFeatures.getMask(7)), new Feature("pstf", false, IndicFeatures.getMask(8)), new Feature("vatu", true, IndicFeatures.getMask(9)), new Feature("cjct", true, IndicFeatures.getMask(10)), new Feature("cfar", false, IndicFeatures.getMask(11))}) {
                    Shaper.transformLine(features.get(feature.name), feature, cluster);
                }
                IndicShaper.finalReordering((IndicCluster)cluster, indicConfig, script);
                Feature[] presentationForms = new Feature[]{new Feature("init", false, IndicFeatures.getMask(12)), new Feature("pres", true, IndicFeatures.getMask(13)), new Feature("abvs", true, IndicFeatures.getMask(14)), new Feature("blws", true, IndicFeatures.getMask(15)), new Feature("psts", true, IndicFeatures.getMask(16)), new Feature("haln", true, IndicFeatures.getMask(17))};
                cluster = Shaper.applyAllFeaturesAtOnceOptimally((IndicCluster)cluster, presentationForms, features);
                clusters.set(clusterId, cluster);
                for (String feature : discretionary = new String[]{"calt", "clig"}) {
                    Shaper.transformLine(features.get(feature), cluster);
                }
                for (Feature feature : positioning = new Feature[]{new Feature("dist", true, IndicFeatures.getMask(18)), new Feature("abvm", true, IndicFeatures.getMask(19)), new Feature("blwm", true, IndicFeatures.getMask(20))}) {
                    Shaper.transformLine(features.get(feature.name), feature, cluster);
                }
            }
            GlyphLine newGlyphLine = Shaper.constructUpdatedGlyphLine(glyphLine, clusters, true);
            glyphLine.replaceContent(newGlyphLine);
            transformed = true;
        }
        return transformed;
    }

    private static boolean applyMyanmarScript(GlyphLine glyphLine, Map<String, List<OpenTableLookup>> features, boolean isMymr, TrueTypeFont font) {
        List<TypographyCluster> clusters;
        boolean transformed = false;
        List<TypographyCluster> list = clusters = isMymr ? Collections.singletonList(ClusterCreatorUtil.wrapTypographyGlyphLineIntoSingleCluster(glyphLine, new MyanmarClusterCreationHelper())) : ClusterCreatorUtil.splitTypographyGlyphLineIntoClusters(glyphLine, new MyanmarClusterCreationHelper());
        if (clusters.size() > 0) {
            Feature[] otherGsubFeatures;
            for (int clusterId = 0; clusterId < clusters.size(); ++clusterId) {
                Feature[] basicFeatures;
                TypographyCluster cluster = clusters.get(clusterId);
                Shaper.transformLine(features.get("locl"), cluster);
                Shaper.transformLine(features.get("ccmp"), cluster);
                if (isMymr) continue;
                MyanmarShaper.initialReorderingConsonantSyllable((MyanmarCluster)cluster);
                Feature[] featureArray = basicFeatures = new Feature[]{new Feature("rphf", true, IndicFeatures.getMask(2)), new Feature("pref", true, IndicFeatures.getMask(4)), new Feature("blwf", true, IndicFeatures.getMask(5)), new Feature("pstf", true, IndicFeatures.getMask(8))};
                int n = featureArray.length;
                for (int i = 0; i < n; ++i) {
                    Feature feature = featureArray[i];
                    Shaper.transformLine(features.get(feature.name), feature, cluster);
                }
            }
            clusters = Shaper.collectClustersIntoOne(glyphLine, clusters);
            TypographyCluster singleCluster = clusters.get(0);
            for (Feature feature : otherGsubFeatures = new Feature[]{new Feature("pres", true, IndicFeatures.getMask(13)), new Feature("abvs", true, IndicFeatures.getMask(14)), new Feature("blws", true, IndicFeatures.getMask(15)), new Feature("psts", true, IndicFeatures.getMask(16))}) {
                Shaper.transformLine(features.get(feature.name), feature, singleCluster);
            }
            Shaper.transformLine(features.get("rlig"), singleCluster);
            Shaper.transformLine(features.get("clig"), singleCluster);
            ComplexShaper shaper = ComplexShaper.getMyanmarInstance(!isMymr);
            transformed = Shaper.positionComplex(shaper, features, singleCluster, font, (posFeatures, curCluster) -> Shaper.applyMyanmarPositioning(posFeatures, isMymr, curCluster)) || transformed;
            GlyphLine newGlyphLine = Shaper.constructUpdatedGlyphLine(glyphLine, clusters, false);
            glyphLine.replaceContent(newGlyphLine);
            transformed = true;
        }
        return transformed;
    }

    private static boolean positionComplex(ComplexShaper shaper, Map<String, List<OpenTableLookup>> features, GlyphLine singleCluster, TrueTypeFont font, PositioningFunction positioningFunction) {
        boolean hasPositioning = font.getGposTable() != null;
        boolean adjustOffsetsWhenZeroing = !hasPositioning && !shaper.isFallbackPosition();
        switch (shaper.getZeroWidthMarks()) {
            case 2: {
                Shaper.zeroMarkWidthsByGdef(singleCluster, font, adjustOffsetsWhenZeroing);
                break;
            }
        }
        boolean transformed = positioningFunction.apply(features, singleCluster);
        switch (shaper.getZeroWidthMarks()) {
            case 1: {
                Shaper.zeroMarkWidthsByUnicode(singleCluster, adjustOffsetsWhenZeroing);
                break;
            }
            case 3: {
                Shaper.zeroMarkWidthsByGdef(singleCluster, font, adjustOffsetsWhenZeroing);
                break;
            }
        }
        return transformed;
    }

    private static void zeroMarkWidthsByUnicode(GlyphLine singleCluster, boolean adjustOffsets) {
        for (int i = singleCluster.start; i < singleCluster.end; ++i) {
            if (Character.getType((char)singleCluster.get(i).getUnicode()) != 6) continue;
            if (adjustOffsets) {
                Shaper.adjustMarkOffsets(singleCluster, i);
            }
            Shaper.zeroMarkWidth(singleCluster, i);
        }
    }

    private static void zeroMarkWidthsByGdef(GlyphLine singleCluster, TrueTypeFont font, boolean adjustOffsets) {
        for (int i = singleCluster.start; i < singleCluster.end; ++i) {
            if (!font.getGdefTable().getGlyphClassTable().isMarkOtfClass(singleCluster.get(i).getCode())) continue;
            if (adjustOffsets) {
                Shaper.adjustMarkOffsets(singleCluster, i);
            }
            Shaper.zeroMarkWidth(singleCluster, i);
        }
    }

    private static void adjustMarkOffsets(GlyphLine cluster, int pos) {
        int harfBuzzXAdvance = cluster.get(pos).getWidth() + cluster.get(pos).getXAdvance();
        Glyph replacementGlyph = new Glyph(cluster.get(pos));
        replacementGlyph.setXPlacement((short)(replacementGlyph.getXPlacement() - harfBuzzXAdvance));
        replacementGlyph.setYPlacement((short)(replacementGlyph.getYPlacement() - replacementGlyph.getYAdvance()));
        cluster.set(pos, replacementGlyph);
    }

    private static void zeroMarkWidth(GlyphLine cluster, int pos) {
        Glyph replacementGlyph = new Glyph(cluster.get(pos));
        replacementGlyph.setXAdvance((short)(-replacementGlyph.getWidth()));
        replacementGlyph.setYAdvance((short)0);
        cluster.set(pos, replacementGlyph);
    }

    private static boolean applyMyanmarPositioning(Map<String, List<OpenTableLookup>> features, boolean isMymr, GlyphLine singleCluster) {
        boolean transformed = Shaper.transformLine(features.get("mark"), singleCluster);
        transformed = Shaper.transformLine(features.get("mkmk"), singleCluster) || transformed;
        boolean bl = transformed = Shaper.transformLine(features.get("kern"), singleCluster) || transformed;
        if (!isMymr) {
            Feature[] otherGposFeatures;
            for (Feature feature : otherGposFeatures = new Feature[]{new Feature("dist", true, IndicFeatures.getMask(18)), new Feature("abvm", true, IndicFeatures.getMask(19)), new Feature("blwm", true, IndicFeatures.getMask(20))}) {
                transformed = Shaper.transformLine(features.get(feature.name), feature, singleCluster) || transformed;
            }
        }
        return transformed;
    }

    private static List<TypographyCluster> collectClustersIntoOne(GlyphLine glyphLine, List<TypographyCluster> clusters) {
        GlyphLine newGlyphLine = Shaper.constructUpdatedGlyphLine(glyphLine, clusters, true);
        TypographyCluster singleCluster = ClusterCreatorUtil.wrapTypographyGlyphLineIntoSingleCluster(newGlyphLine, new MyanmarClusterCreationHelper());
        singleCluster.originalGlyphLineEnd = glyphLine.end;
        return Collections.singletonList(singleCluster);
    }

    private static GlyphLine constructUpdatedGlyphLine(GlyphLine glyphLine, List<TypographyCluster> clusters, boolean useClustersActualText) {
        GlyphLine newGlyphLine = glyphLine.copy(0, glyphLine.start);
        int newStart = newGlyphLine.size();
        int lastFinish = glyphLine.start;
        for (TypographyCluster cluster : clusters) {
            if (cluster.originalGlyphLineStart > lastFinish) {
                for (int j = lastFinish; j < cluster.originalGlyphLineStart; ++j) {
                    newGlyphLine.add(glyphLine.get(j));
                }
            }
            int startActualTextPos = newGlyphLine.size();
            for (int j = 0; j < cluster.size(); ++j) {
                newGlyphLine.add(cluster.get(j));
            }
            if (useClustersActualText) {
                newGlyphLine.setActualText(startActualTextPos, newGlyphLine.size(), cluster.getClusterActualText());
            } else {
                ActualTextIterator iterator = new ActualTextIterator((GlyphLine)cluster);
                GlyphLine.GlyphLinePart part = null;
                while (iterator.hasNext()) {
                    part = iterator.next();
                    if (part.actualText == null) continue;
                    newGlyphLine.setActualText(startActualTextPos + part.start, startActualTextPos + part.end, part.actualText);
                }
            }
            lastFinish = cluster.originalGlyphLineEnd;
        }
        for (int j = lastFinish; j < glyphLine.end; ++j) {
            newGlyphLine.add(glyphLine.get(j));
        }
        int newEnd = newGlyphLine.size();
        for (int j = glyphLine.end; j < glyphLine.size(); ++j) {
            newGlyphLine.add(glyphLine.get(j));
        }
        newGlyphLine.start = newStart;
        newGlyphLine.end = newEnd;
        return newGlyphLine;
    }

    private static String[] getOtfScriptTags(Character.UnicodeScript script) {
        if (script != null) {
            return otfScriptTags.get(EnumUtil.throwIfNull((Enum)script));
        }
        return null;
    }

    private static String extractFeatures(TrueTypeFont font, Character.UnicodeScript unicodeScript, Map<String, List<OpenTableLookup>> extractedFeatures) {
        String[] otfScriptTags = Shaper.getOtfScriptTags(unicodeScript);
        return Shaper.extractFeatures(font, otfScriptTags, extractedFeatures);
    }

    private static String extractFeatures(TrueTypeFont font, String[] otfScriptTags, Map<String, List<OpenTableLookup>> extractedFeatures) {
        List<String> otfScriptTagsList = new ArrayList<String>();
        if (otfScriptTags != null) {
            otfScriptTagsList.addAll(Arrays.asList(otfScriptTags));
        }
        String dfltScriptTag = "DFLT";
        otfScriptTagsList.add(dfltScriptTag);
        GlyphSubstitutionTableReader gsubTable = font.getGsubTable();
        String usedScriptTag = Shaper.extractFeaturesFromTable((OpenTypeFontTableReader)gsubTable, otfScriptTagsList, extractedFeatures);
        String finalUsedScriptTag = null;
        if (usedScriptTag != null && !dfltScriptTag.equals(usedScriptTag)) {
            otfScriptTagsList = Arrays.asList(usedScriptTag, dfltScriptTag);
            finalUsedScriptTag = usedScriptTag;
        }
        GlyphPositioningTableReader gposTable = font.getGposTable();
        usedScriptTag = Shaper.extractFeaturesFromTable((OpenTypeFontTableReader)gposTable, otfScriptTagsList, extractedFeatures);
        if (finalUsedScriptTag == null) {
            finalUsedScriptTag = usedScriptTag;
        }
        return finalUsedScriptTag;
    }

    private static String extractFeaturesFromTable(OpenTypeFontTableReader table, List<String> otfScriptTagsList, Map<String, List<OpenTableLookup>> extractedFeatures) {
        String usedScriptTag = null;
        LanguageRecord languageRecord = null;
        if (table != null) {
            for (String scriptTag : otfScriptTagsList) {
                languageRecord = table.getLanguageRecord(scriptTag);
                if (languageRecord == null) continue;
                usedScriptTag = scriptTag;
                break;
            }
        }
        if (languageRecord != null) {
            for (Object featureIndex : (Object)languageRecord.features) {
                FeatureRecord feature = (FeatureRecord)table.getFeatureRecords().get((int)featureIndex);
                List lookups = table.getLookups(new FeatureRecord[]{feature});
                extractedFeatures.put(feature.tag, lookups);
            }
        }
        return usedScriptTag;
    }

    private static void unicodeDecompose(TrueTypeFont font, GlyphLine glyphLine) {
        for (int pos = glyphLine.start; pos < glyphLine.end; ++pos) {
            String normalized;
            Glyph g = glyphLine.get(pos);
            String unicode = null;
            if (g.hasValidUnicode()) {
                unicode = new String(TextUtil.convertFromUtf32((int)g.getUnicode()));
            } else if (g.getChars() != null) {
                unicode = new String(g.getChars());
            }
            if (unicode == null || unicode.equals(normalized = Normalizer.normalize(unicode, Normalizer.Form.NFD))) continue;
            glyphLine.idx = pos;
            int[] unicodeChars = TextUtil.convertToUtf32((String)normalized);
            int[] glyphIds = new int[unicodeChars.length];
            boolean allGlyphsFound = true;
            for (int i = 0; i < unicodeChars.length; ++i) {
                Glyph glyph = font.getGlyph(unicodeChars[i]);
                if (glyph == null || glyph.getCode() == 0) {
                    allGlyphsFound = false;
                    logger.warn(MessageFormatUtil.format((String)"Glyph for unicode {0} was not found in the font", (Object[])new Object[]{unicodeChars[i]}));
                    break;
                }
                glyphIds[i] = glyph.getCode();
            }
            if (!allGlyphsFound) continue;
            glyphLine.substituteOneToMany((OpenTypeFontTableReader)font.getGsubTable(), glyphIds);
        }
    }

    private static boolean applyInitMediFinaShaping(GlyphLine glyphLine, List<OpenTableLookup> init, List<OpenTableLookup> medi, List<OpenTableLookup> fina, OpenTypeGdefTableReader gdefTableReader, List<Integer> words) {
        if (init == null || medi == null || fina == null) {
            return false;
        }
        boolean transformed = false;
        for (int i = 0; i < words.size(); i += 2) {
            int wordStart = words.get(i);
            int wordEnd = words.get(i + 1);
            ArrayList<Integer> nonMarkWordChars = new ArrayList<Integer>();
            for (int charInd = wordStart; charInd < wordEnd; ++charInd) {
                boolean isMark = gdefTableReader.getGlyphClassTable().isMarkOtfClass(glyphLine.get(charInd).getCode());
                if (isMark) continue;
                nonMarkWordChars.add(charInd);
            }
            if (nonMarkWordChars.size() > 1) {
                glyphLine.idx = (Integer)nonMarkWordChars.get(0);
                if (Shaper.transformOne(init, glyphLine)) {
                    transformed = true;
                }
            }
            for (int k = 1; k < nonMarkWordChars.size() - 1; ++k) {
                glyphLine.idx = (Integer)nonMarkWordChars.get(k);
                if (!Shaper.transformOne(medi, glyphLine)) continue;
                transformed = true;
            }
            if (nonMarkWordChars.size() <= 1) continue;
            glyphLine.idx = (Integer)nonMarkWordChars.get(nonMarkWordChars.size() - 1);
            if (!Shaper.transformOne(fina, glyphLine)) continue;
            transformed = true;
        }
        return transformed;
    }

    private static List<Integer> splitArabicGlyphLineIntoWords(GlyphLine glyphLine, List<OpenTableLookup> init, List<OpenTableLookup> medi, List<OpenTableLookup> fina, OpenTypeGdefTableReader gdefTableReader) {
        ArrayList<Integer> words = new ArrayList<Integer>();
        boolean started = false;
        int tatweel = 1600;
        boolean finishPostponed = false;
        for (int i = 0; i < glyphLine.size(); ++i) {
            boolean isArabic;
            Glyph currentGlyph = glyphLine.get(i);
            boolean isMark = gdefTableReader.getGlyphClassTable().isMarkOtfClass(currentGlyph.getCode());
            boolean isNextGlyphMark = i + 1 < glyphLine.end && gdefTableReader.getGlyphClassTable().isMarkOtfClass(glyphLine.get(i + 1).getCode());
            boolean bl = isArabic = Character.UnicodeScript.ARABIC.equals((Object)Character.UnicodeScript.of(currentGlyph.getUnicode())) || isMark || tatweel == currentGlyph.getUnicode();
            if (started) {
                boolean letterIsFinal;
                boolean bl2 = letterIsFinal = !isMark && !Shaper.canArabicLetterBeMedial(currentGlyph.getUnicodeString());
                if (!isNextGlyphMark && (letterIsFinal || finishPostponed) || !isArabic) {
                    if (!isArabic) {
                        words.add(i);
                    } else {
                        words.add(i + 1);
                    }
                    started = false;
                    finishPostponed = false;
                    continue;
                }
                if (finishPostponed) continue;
                finishPostponed = letterIsFinal;
                continue;
            }
            if (!isArabic || !Shaper.canArabicLetterBeMedial(currentGlyph.getUnicodeString())) continue;
            words.add(i);
            started = true;
        }
        if (words.size() % 2 != 0) {
            words.add(glyphLine.size());
        }
        return words;
    }

    private static boolean canArabicLetterBeMedial(String letter) {
        String normalized = Normalizer.normalize(letter, Normalizer.Form.NFKD);
        for (int i = 0; i < normalized.length(); ++i) {
            if (Arrays.binarySearch(ARABIC_LETTERS_WHICH_HAVE_ONLY_ISOLATED_AND_FINAL_FORMS, (int)normalized.charAt(i)) < 0) continue;
            return false;
        }
        return true;
    }

    private static boolean applyRligFeature(GlyphLine glyphLine, List<OpenTableLookup> rlig) {
        boolean transformed = false;
        if (glyphLine != null && rlig != null) {
            for (OpenTableLookup lookup : rlig) {
                if (lookup == null || !lookup.transformLine(glyphLine)) continue;
                transformed = true;
            }
        }
        return transformed;
    }

    private static Glyph transform(List<OpenTableLookup> feature, Glyph glyph) {
        if (feature != null) {
            for (OpenTableLookup lookup : feature) {
                if (lookup == null || !lookup.hasSubstitution(glyph.getCode())) continue;
                GlyphLine gl = new GlyphLine(Arrays.asList(glyph), 0, 1);
                gl.idx = 0;
                lookup.transformOne(gl);
                return gl.get(0);
            }
        }
        return null;
    }

    private static boolean transformLine(List<OpenTableLookup> featureLookups, GlyphLine glyphLine) {
        return Shaper.transform(featureLookups, glyphLine, false);
    }

    private static boolean transformOne(List<OpenTableLookup> featureLookups, GlyphLine glyphLine) {
        return Shaper.transform(featureLookups, glyphLine, true);
    }

    private static boolean transform(List<OpenTableLookup> featureLookups, GlyphLine glyphLine, boolean one) {
        boolean transformed = false;
        if (featureLookups != null) {
            for (OpenTableLookup lookup : featureLookups) {
                if (lookup == null) continue;
                if (one) {
                    if (!lookup.transformOne(glyphLine)) continue;
                    transformed = true;
                    continue;
                }
                if (!lookup.transformLine(glyphLine)) continue;
                transformed = true;
            }
        }
        return transformed;
    }

    private static boolean transformLine(List<OpenTableLookup> featureLookups, Feature feature, GlyphLine glyphLine) {
        boolean transformed = false;
        if (featureLookups != null) {
            for (OpenTableLookup lookup : featureLookups) {
                if (lookup == null) continue;
                if (feature.isGlobal) {
                    if (!lookup.transformLine(glyphLine)) continue;
                    transformed = true;
                    continue;
                }
                int originalStart = glyphLine.start;
                int originalEnd = glyphLine.end;
                int curStart = originalStart;
                while (curStart < originalEnd) {
                    int curEnd;
                    while (curStart < originalEnd && (((IndicCluster.IndicGlyph)glyphLine.get((int)curStart)).mask & feature.mask) == 0) {
                        ++curStart;
                    }
                    if (curStart >= originalEnd) continue;
                    for (curEnd = curStart + 1; curEnd < originalEnd && (((IndicCluster.IndicGlyph)glyphLine.get((int)curEnd)).mask & feature.mask) != 0; ++curEnd) {
                    }
                    glyphLine.start = curStart;
                    glyphLine.end = curEnd;
                    if (lookup.transformLine(glyphLine)) {
                        transformed = true;
                    }
                    curStart = glyphLine.end;
                    glyphLine.start = originalStart;
                    glyphLine.end = originalEnd += glyphLine.end - curEnd;
                }
            }
        }
        return transformed;
    }

    private static IndicCluster applyAllFeaturesAtOnceOptimally(IndicCluster cluster, Feature[] featureList, Map<String, List<OpenTableLookup>> features) {
        SubstitutedItem bestPossibility = null;
        ArrayDeque q = new ArrayDeque();
        HashSet<SubstitutedItem> met = new HashSet<SubstitutedItem>();
        met.add(new SubstitutedItem(cluster, featureList.length));
        q.addAll(met);
        while (!q.isEmpty()) {
            SubstitutedItem curItem = (SubstitutedItem)q.pop();
            IndicCluster curCluster = curItem.cluster;
            boolean anyTransformation = false;
            for (int i = 0; i < featureList.length; ++i) {
                Feature feature = featureList[i];
                if (curItem.usedFeatures[i]) continue;
                IndicCluster initial = (IndicCluster)curCluster.copy(curCluster.start, curCluster.end);
                boolean transformed = Shaper.transformLine(features.get(feature.name), feature, initial);
                if (!transformed) continue;
                SubstitutedItem possibility = new SubstitutedItem(initial, curItem.getUsedFeatures());
                possibility.setUsedFeature(i);
                if (met.contains(possibility)) continue;
                met.add(possibility);
                q.addLast(possibility);
                anyTransformation = true;
            }
            if (anyTransformation) continue;
            bestPossibility = Shaper.getBetterPossibility(curItem, bestPossibility);
        }
        return bestPossibility == null ? cluster : bestPossibility.cluster;
    }

    private static SubstitutedItem getBetterPossibility(SubstitutedItem curItem, SubstitutedItem bestPossibility) {
        int curNumfOfSubstitutions;
        if (null == bestPossibility) {
            return curItem;
        }
        int bestNumfOfSubstitutions = bestPossibility.getNumberOfSubstitutions();
        return bestNumfOfSubstitutions < (curNumfOfSubstitutions = curItem.getNumberOfSubstitutions()) || bestNumfOfSubstitutions == curNumfOfSubstitutions && bestPossibility.length() > curItem.length() ? curItem : bestPossibility;
    }

    static {
        otfScriptTags.put(Character.UnicodeScript.ARABIC, new String[]{"arab"});
        otfScriptTags.put(Character.UnicodeScript.ARMENIAN, new String[]{"armn"});
        otfScriptTags.put(Character.UnicodeScript.BENGALI, new String[]{"bng2", "beng"});
        otfScriptTags.put(Character.UnicodeScript.CYRILLIC, new String[]{"cyrl"});
        otfScriptTags.put(Character.UnicodeScript.DEVANAGARI, new String[]{"dev2", "deva"});
        otfScriptTags.put(Character.UnicodeScript.GEORGIAN, new String[]{"geor"});
        otfScriptTags.put(Character.UnicodeScript.GREEK, new String[]{"grek"});
        otfScriptTags.put(Character.UnicodeScript.GUJARATI, new String[]{"gjr2", "gujr"});
        otfScriptTags.put(Character.UnicodeScript.GURMUKHI, new String[]{"gur2", "guru"});
        otfScriptTags.put(Character.UnicodeScript.HEBREW, new String[]{"hebr"});
        otfScriptTags.put(Character.UnicodeScript.KANNADA, new String[]{"knd2", "knda"});
        otfScriptTags.put(Character.UnicodeScript.KHMER, new String[]{"khmr"});
        otfScriptTags.put(Character.UnicodeScript.LATIN, new String[]{"latn"});
        otfScriptTags.put(Character.UnicodeScript.MALAYALAM, new String[]{"mlm2", "mlym"});
        otfScriptTags.put(Character.UnicodeScript.OGHAM, new String[]{"ogam"});
        otfScriptTags.put(Character.UnicodeScript.ORIYA, new String[]{"ory2", "orya"});
        otfScriptTags.put(Character.UnicodeScript.RUNIC, new String[]{"runr"});
        otfScriptTags.put(Character.UnicodeScript.TAMIL, new String[]{"tml2", "taml"});
        otfScriptTags.put(Character.UnicodeScript.TELUGU, new String[]{"tel2", "telu"});
        otfScriptTags.put(Character.UnicodeScript.THAI, new String[]{"thai"});
        otfScriptTags.put(Character.UnicodeScript.BALINESE, new String[]{"bali"});
        otfScriptTags.put(Character.UnicodeScript.BOPOMOFO, new String[]{"bopo"});
        otfScriptTags.put(Character.UnicodeScript.BRAILLE, new String[]{"brai"});
        otfScriptTags.put(Character.UnicodeScript.BUGINESE, new String[]{"bugi"});
        otfScriptTags.put(Character.UnicodeScript.BUHID, new String[]{"buhd"});
        otfScriptTags.put(Character.UnicodeScript.CARIAN, new String[]{"cari"});
        otfScriptTags.put(Character.UnicodeScript.CHAM, new String[]{"cham"});
        otfScriptTags.put(Character.UnicodeScript.CHEROKEE, new String[]{"cher"});
        otfScriptTags.put(Character.UnicodeScript.COPTIC, new String[]{"copt"});
        otfScriptTags.put(Character.UnicodeScript.DESERET, new String[]{"dsrt"});
        otfScriptTags.put(Character.UnicodeScript.ETHIOPIC, new String[]{"ethi"});
        otfScriptTags.put(Character.UnicodeScript.GLAGOLITIC, new String[]{"glag"});
        otfScriptTags.put(Character.UnicodeScript.GOTHIC, new String[]{"goth"});
        otfScriptTags.put(Character.UnicodeScript.HANGUL, new String[]{"hang", "jamo"});
        otfScriptTags.put(Character.UnicodeScript.HANUNOO, new String[]{"hano"});
        otfScriptTags.put(Character.UnicodeScript.HIRAGANA, new String[]{"kana"});
        otfScriptTags.put(Character.UnicodeScript.JAVANESE, new String[]{"java"});
        otfScriptTags.put(Character.UnicodeScript.KATAKANA, new String[]{"kana"});
        otfScriptTags.put(Character.UnicodeScript.KAYAH_LI, new String[]{"kali"});
        otfScriptTags.put(Character.UnicodeScript.KHAROSHTHI, new String[]{"khar"});
        otfScriptTags.put(Character.UnicodeScript.LAO, new String[]{"lao "});
        otfScriptTags.put(Character.UnicodeScript.LEPCHA, new String[]{"lepc"});
        otfScriptTags.put(Character.UnicodeScript.LIMBU, new String[]{"limb"});
        otfScriptTags.put(Character.UnicodeScript.LINEAR_B, new String[]{"linb"});
        otfScriptTags.put(Character.UnicodeScript.LYCIAN, new String[]{"lyci"});
        otfScriptTags.put(Character.UnicodeScript.LYDIAN, new String[]{"lydi"});
        otfScriptTags.put(Character.UnicodeScript.MONGOLIAN, new String[]{"mong"});
        otfScriptTags.put(Character.UnicodeScript.MYANMAR, new String[]{"mym2"});
        otfScriptTags.put(Character.UnicodeScript.NEW_TAI_LUE, new String[]{"talu"});
        otfScriptTags.put(Character.UnicodeScript.NKO, new String[]{"nko "});
        otfScriptTags.put(Character.UnicodeScript.OL_CHIKI, new String[]{"olck"});
        otfScriptTags.put(Character.UnicodeScript.OLD_ITALIC, new String[]{"ital"});
        otfScriptTags.put(Character.UnicodeScript.OLD_PERSIAN, new String[]{"xpeo"});
        otfScriptTags.put(Character.UnicodeScript.OSMANYA, new String[]{"osma"});
        otfScriptTags.put(Character.UnicodeScript.PHAGS_PA, new String[]{"phag"});
        otfScriptTags.put(Character.UnicodeScript.PHOENICIAN, new String[]{"phnx"});
        otfScriptTags.put(Character.UnicodeScript.REJANG, new String[]{"rjng"});
        otfScriptTags.put(Character.UnicodeScript.SAURASHTRA, new String[]{"saur"});
        otfScriptTags.put(Character.UnicodeScript.SHAVIAN, new String[]{"shaw"});
        otfScriptTags.put(Character.UnicodeScript.SINHALA, new String[]{"sinh"});
        otfScriptTags.put(Character.UnicodeScript.SUNDANESE, new String[]{"sund"});
        otfScriptTags.put(Character.UnicodeScript.SYLOTI_NAGRI, new String[]{"sylo"});
        otfScriptTags.put(Character.UnicodeScript.SYRIAC, new String[]{"syrc"});
        otfScriptTags.put(Character.UnicodeScript.TAGALOG, new String[]{"tglg"});
        otfScriptTags.put(Character.UnicodeScript.TAGBANWA, new String[]{"tagb"});
        otfScriptTags.put(Character.UnicodeScript.TAI_LE, new String[]{"tale"});
        otfScriptTags.put(Character.UnicodeScript.THAANA, new String[]{"thaa"});
        otfScriptTags.put(Character.UnicodeScript.TIBETAN, new String[]{"tibt"});
        otfScriptTags.put(Character.UnicodeScript.TIFINAGH, new String[]{"tfng"});
        otfScriptTags.put(Character.UnicodeScript.UGARITIC, new String[]{"ugar"});
        otfScriptTags.put(Character.UnicodeScript.VAI, new String[]{"vai "});
        otfScriptTags.put(Character.UnicodeScript.YI, new String[]{"yi  "});
    }

    @FunctionalInterface
    private static interface PositioningFunction {
        public boolean apply(Map<String, List<OpenTableLookup>> var1, GlyphLine var2);
    }

    private static class Feature {
        String name;
        boolean isGlobal;
        int mask;

        public Feature(String name, boolean isGlobal, int mask) {
            this.name = name;
            this.isGlobal = isGlobal;
            this.mask = mask;
        }
    }

    private static class SubstitutedItem {
        IndicCluster cluster;
        boolean[] usedFeatures;

        public SubstitutedItem(IndicCluster cluster, int numberOfFeatures) {
            this.cluster = cluster;
            this.usedFeatures = new boolean[numberOfFeatures];
        }

        public SubstitutedItem(IndicCluster cluster, boolean[] featuresUsed) {
            this.cluster = cluster;
            this.usedFeatures = (boolean[])featuresUsed.clone();
        }

        public boolean[] getUsedFeatures() {
            return this.usedFeatures;
        }

        public void setUsedFeature(int i) {
            this.usedFeatures[i] = true;
        }

        public int hashCode() {
            int result = this.cluster.hashCode();
            for (int i = 0; i < this.usedFeatures.length; ++i) {
                result = 31 * result + (this.usedFeatures[i] ? 1 : 0);
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SubstitutedItem other = (SubstitutedItem)obj;
            if (!this.cluster.equals((Object)other.cluster)) {
                return false;
            }
            return Arrays.equals(this.usedFeatures, other.usedFeatures);
        }

        int getNumberOfSubstitutions() {
            int result = 0;
            for (int i = 0; i < this.usedFeatures.length; ++i) {
                if (!this.usedFeatures[i]) continue;
                ++result;
            }
            return result;
        }

        int length() {
            return this.cluster.end - this.cluster.start;
        }
    }
}

