/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.myanmar;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.typography.ordering.TypographyCluster;
import com.itextpdf.typography.ordering.TypographyGlyph;
import com.itextpdf.typography.ordering.myanmar.MyanmarShaper;
import java.util.ArrayList;
import java.util.List;

public class MyanmarCluster
extends TypographyCluster {
    public MyanmarCluster(List<Glyph> glyphs, int originalGlyphLineStart, int originalGlyphLineEnd, String actualText) {
        super(MyanmarCluster.constructMyanmarGlyphList(glyphs), originalGlyphLineStart, originalGlyphLineEnd, actualText);
    }

    public MyanmarCluster(GlyphLine glyphLine, int start, int end, String actualText) {
        super(glyphLine, start, end, actualText);
        ArrayList<Glyph> indicGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.glyphs) {
            indicGlyphs.add((Glyph)(glyph instanceof MyanmarGlyph ? glyph : new MyanmarGlyph(glyph)));
        }
        this.glyphs = new ArrayList(indicGlyphs);
        this.originalGlyphLineStart = 0;
        this.originalGlyphLineEnd = indicGlyphs.size();
        this.clusterActualText = actualText;
    }

    public static List<Glyph> constructMyanmarGlyphList(List<Glyph> glyphs) {
        ArrayList<Glyph> newGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : glyphs) {
            newGlyphs.add(new MyanmarGlyph(glyph));
        }
        return newGlyphs;
    }

    @Override
    public TypographyGlyph createGlyphForSubstitution(Glyph glyph, TypographyGlyph oldGlyph) {
        return new MyanmarGlyph(glyph, oldGlyph.category, oldGlyph.position, oldGlyph.mask);
    }

    @Override
    public TypographyGlyph createComplexGlyph(Glyph glyph) {
        return new MyanmarGlyph(glyph);
    }

    public GlyphLine copy(int left, int right) {
        GlyphLine gl = super.copy(left, right);
        MyanmarCluster copy = new MyanmarCluster(gl, gl.start, gl.end, this.getClusterActualText());
        copy.originalGlyphLineStart = this.originalGlyphLineStart;
        copy.originalGlyphLineEnd = this.originalGlyphLineEnd;
        return copy;
    }

    @Override
    public TypographyCluster createCluster(List<Glyph> glyphs, int originalGlyphLineStart, int originalGlyphLineEnd, String actualText) {
        return new MyanmarCluster(glyphs, originalGlyphLineStart, originalGlyphLineEnd, actualText);
    }

    public static class MyanmarGlyph
    extends TypographyGlyph {
        public MyanmarGlyph(Glyph glyph) {
            super(glyph);
            MyanmarShaper.setMyanmarProperties(this);
        }

        public MyanmarGlyph(Glyph glyph, int category, int indicPos, int mask) {
            super(glyph, category, indicPos, mask);
        }
    }
}

