/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.ln.server.ConfigManager;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.logging.log4j.web.Log4jServletContextListener;

public class ContextListener
implements ServletContextListener {
    private Log4jServletContextListener m_listener = new Log4jServletContextListener();

    public void contextDestroyed(ServletContextEvent event) {
        this.m_listener.contextDestroyed(event);
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        ConfigManager configManager = ConfigManager.getConfigManager(context);
        String loggerPath = configManager.getLog4jFile().toString();
        context.setInitParameter("log4jConfiguration", loggerPath);
        this.m_listener.contextInitialized(event);
        File props = new File(configManager.getConfigDir(), "configuration.properties");
        configManager.setAuthenticator(props);
        configManager.setMetricsUrl(props);
    }
}

