/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import com.infor.erpln.utils.oauth10.Authenticator;
import com.infor.erpln.utils.oauth10.AuthorizationStatus;
import com.infor.erpln.utils.oauth10.BaseUriUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AuthFilter
implements Filter {
    private static final String ATTR_AUTH = "Authenticator";
    private static final Logger LOG = LogManager.getLogger(AuthFilter.class);

    public static void setAuthenticator(ServletContext context, boolean strict, String key, String secret) {
        AuthenticatorWrapper wrapper = new AuthenticatorWrapper(strict, key, secret);
        context.setAttribute(ATTR_AUTH, (Object)wrapper);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            AuthenticatorWrapper wrapper = (AuthenticatorWrapper)request.getServletContext().getAttribute(ATTR_AUTH);
            if (wrapper == null) {
                ((HttpServletResponse)response).sendError(500, "Authenticator not configured");
                return;
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            String authHeader = httpRequest.getHeader("Authorization");
            if (authHeader == null) {
                if (wrapper.isStrict() && !this.skipAuthorization(httpRequest)) {
                    LOG.debug("Signature missing");
                    ((HttpServletResponse)response).sendError(401, "Signature missing");
                    return;
                }
            } else {
                AuthorizationStatus status = wrapper.getAuthenticator().verify(httpRequest.getMethod(), BaseUriUtil.getBaseUri((HttpServletRequest)httpRequest), httpRequest.getQueryString(), authHeader);
                if (!status.isOk()) {
                    ((HttpServletResponse)response).sendError(401, "Signature verification error");
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    private boolean skipAuthorization(HttpServletRequest request) {
        String host;
        String requestUri = request.getRequestURI();
        boolean skip = requestUri.endsWith("/log") ? (host = request.getHeader("host")) != null && host.contains("localhost") : requestUri.endsWith("/ping");
        return skip;
    }

    private static class AuthenticatorWrapper {
        private final Authenticator m_authenticator;
        private final boolean m_strict;

        AuthenticatorWrapper(boolean strict, String key, String secret) {
            this.m_authenticator = Authenticator.getInstance((String)key, (String)secret);
            this.m_strict = strict;
        }

        Authenticator getAuthenticator() {
            return this.m_authenticator;
        }

        boolean isStrict() {
            return this.m_strict;
        }
    }
}

