/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontCache;
import com.itextpdf.io.font.cmap.AbstractCMap;
import com.itextpdf.io.font.cmap.CMapLocationFromBytes;
import com.itextpdf.io.font.cmap.CMapParser;
import com.itextpdf.io.font.cmap.CMapToUnicode;
import com.itextpdf.io.font.cmap.CMapUniCid;
import com.itextpdf.io.font.cmap.ICMapLocation;
import com.itextpdf.io.util.IntHashtable;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import java.util.Arrays;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontUtil {
    private static final HashMap<String, CMapToUnicode> uniMaps = new HashMap();

    public static String addRandomSubsetPrefixForFontName(String fontName) {
        StringBuilder newFontName = new StringBuilder(fontName.length() + 7);
        for (int k = 0; k < 6; ++k) {
            newFontName.append((char)(Math.random() * 26.0 + 65.0));
        }
        newFontName.append('+').append(fontName);
        return newFontName.toString();
    }

    static CMapToUnicode processToUnicode(PdfObject toUnicode) {
        CMapToUnicode cMapToUnicode = null;
        if (toUnicode instanceof PdfStream) {
            try {
                byte[] uniBytes = ((PdfStream)toUnicode).getBytes();
                CMapLocationFromBytes lb = new CMapLocationFromBytes(uniBytes);
                cMapToUnicode = new CMapToUnicode();
                CMapParser.parseCid((String)"", (AbstractCMap)cMapToUnicode, (ICMapLocation)lb);
            }
            catch (Exception e) {
                Logger logger = LoggerFactory.getLogger(CMapToUnicode.class);
                logger.error("Unknown error while processing CMap.");
                cMapToUnicode = CMapToUnicode.EmptyCMapToUnicodeMap;
            }
        } else if (PdfName.IdentityH.equals(toUnicode)) {
            cMapToUnicode = CMapToUnicode.getIdentity();
        }
        return cMapToUnicode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CMapToUnicode getToUnicodeFromUniMap(String uniMap) {
        if (uniMap == null) {
            return null;
        }
        HashMap<String, CMapToUnicode> hashMap = uniMaps;
        synchronized (hashMap) {
            CMapToUnicode toUnicode;
            if (uniMaps.containsKey(uniMap)) {
                return uniMaps.get(uniMap);
            }
            if ("Identity-H".equals(uniMap)) {
                toUnicode = CMapToUnicode.getIdentity();
            } else {
                CMapUniCid uni = FontCache.getUni2CidCmap((String)uniMap);
                if (uni == null) {
                    return null;
                }
                toUnicode = uni.exportToUnicode();
            }
            uniMaps.put(uniMap, toUnicode);
            return toUnicode;
        }
    }

    static String createRandomFontName() {
        StringBuilder s = new StringBuilder("");
        for (int k = 0; k < 7; ++k) {
            s.append((char)(Math.random() * 26.0 + 65.0));
        }
        return s.toString();
    }

    static int[] convertSimpleWidthsArray(PdfArray widthsArray, int first, int missingWidth) {
        int[] res = new int[256];
        Arrays.fill(res, missingWidth);
        if (widthsArray == null) {
            Logger logger = LoggerFactory.getLogger(FontUtil.class);
            logger.warn("Font dictionary does not contain required /Widths entry.");
            return res;
        }
        for (int i = 0; i < widthsArray.size() && first + i < 256; ++i) {
            PdfNumber number = widthsArray.getAsNumber(i);
            res[first + i] = number != null ? number.intValue() : missingWidth;
        }
        return res;
    }

    static IntHashtable convertCompositeWidthsArray(PdfArray widthsArray) {
        IntHashtable res = new IntHashtable();
        if (widthsArray == null) {
            return res;
        }
        for (int k = 0; k < widthsArray.size(); ++k) {
            PdfObject obj;
            int c1 = widthsArray.getAsNumber(k).intValue();
            if ((obj = widthsArray.get(++k)).isArray()) {
                PdfArray subWidths = (PdfArray)obj;
                for (int j = 0; j < subWidths.size(); ++j) {
                    int c2 = subWidths.getAsNumber(j).intValue();
                    res.put(c1++, c2);
                }
                continue;
            }
            int c2 = ((PdfNumber)obj).intValue();
            int w = widthsArray.getAsNumber(++k).intValue();
            while (c1 <= c2) {
                res.put(c1, w);
                ++c1;
            }
        }
        return res;
    }
}

