/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.resolve.shorthand.impl;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.styledxmlparser.css.util.CssTypesValidationUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontShorthandResolver
implements IShorthandResolver {
    private static final Set<String> UNSUPPORTED_VALUES_OF_FONT_SHORTHAND = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("caption", "icon", "menu", "message-box", "small-caption", "status-bar")));
    private static final Set<String> FONT_WEIGHT_NOT_DEFAULT_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900")));
    private static final Set<String> FONT_SIZE_VALUES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("medium", "xx-small", "x-small", "small", "large", "x-large", "xx-large", "smaller", "larger")));

    @Override
    public List<CssDeclaration> resolveShorthand(String shorthandExpression) {
        if (UNSUPPORTED_VALUES_OF_FONT_SHORTHAND.contains(shorthandExpression)) {
            Logger logger = LoggerFactory.getLogger(FontShorthandResolver.class);
            logger.error(MessageFormatUtil.format((String)"The \"{0}\" value of CSS shorthand property \"font\" is not supported", (Object[])new Object[]{shorthandExpression}));
        }
        if ("initial".equals(shorthandExpression) || "inherit".equals(shorthandExpression)) {
            return Arrays.asList(new CssDeclaration("font-style", shorthandExpression), new CssDeclaration("font-variant", shorthandExpression), new CssDeclaration("font-weight", shorthandExpression), new CssDeclaration("font-size", shorthandExpression), new CssDeclaration("line-height", shorthandExpression), new CssDeclaration("font-family", shorthandExpression));
        }
        String fontStyleValue = null;
        String fontVariantValue = null;
        String fontWeightValue = null;
        String fontSizeValue = null;
        String lineHeightValue = null;
        String fontFamilyValue = null;
        List<String> properties = this.getFontProperties(shorthandExpression.replaceAll("\\s*,\\s*", ","));
        for (String value : properties) {
            int slashSymbolIndex = value.indexOf(47);
            if ("italic".equals(value) || "oblique".equals(value)) {
                fontStyleValue = value;
                continue;
            }
            if ("small-caps".equals(value)) {
                fontVariantValue = value;
                continue;
            }
            if (FONT_WEIGHT_NOT_DEFAULT_VALUES.contains(value)) {
                fontWeightValue = value;
                continue;
            }
            if (slashSymbolIndex > 0) {
                fontSizeValue = value.substring(0, slashSymbolIndex);
                lineHeightValue = value.substring(slashSymbolIndex + 1, value.length());
                continue;
            }
            if (FONT_SIZE_VALUES.contains(value) || CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isNumber(value) || CssTypesValidationUtils.isRelativeValue(value)) {
                fontSizeValue = value;
                continue;
            }
            fontFamilyValue = value;
        }
        List<CssDeclaration> cssDeclarations = Arrays.asList(new CssDeclaration("font-style", fontStyleValue == null ? "initial" : fontStyleValue), new CssDeclaration("font-variant", fontVariantValue == null ? "initial" : fontVariantValue), new CssDeclaration("font-weight", fontWeightValue == null ? "initial" : fontWeightValue), new CssDeclaration("font-size", fontSizeValue == null ? "initial" : fontSizeValue), new CssDeclaration("line-height", lineHeightValue == null ? "initial" : lineHeightValue), new CssDeclaration("font-family", fontFamilyValue == null ? "initial" : fontFamilyValue));
        return cssDeclarations;
    }

    private List<String> getFontProperties(String shorthandExpression) {
        boolean doubleQuotesAreSpotted = false;
        boolean singleQuoteIsSpotted = false;
        ArrayList<String> properties = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < shorthandExpression.length(); ++i) {
            char currentChar = shorthandExpression.charAt(i);
            if (currentChar == '\"') {
                doubleQuotesAreSpotted = !doubleQuotesAreSpotted;
                sb.append(currentChar);
                continue;
            }
            if (currentChar == '\'') {
                singleQuoteIsSpotted = !singleQuoteIsSpotted;
                sb.append(currentChar);
                continue;
            }
            if (!doubleQuotesAreSpotted && !singleQuoteIsSpotted && Character.isWhitespace(currentChar)) {
                if (sb.length() <= 0) continue;
                properties.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(currentChar);
        }
        if (sb.length() > 0) {
            properties.add(sb.toString());
        }
        return properties;
    }
}

