/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.Logger;

public class Utils {
    public static void setCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=0");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static void logRequest(Logger logger, HttpServletRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("Protocol: {}", (Object)request.getProtocol());
            StringBuffer url = request.getRequestURL();
            if (request.getQueryString() != null) {
                url.append('?').append(request.getQueryString());
            }
            logger.debug("{}: {}", (Object)request.getMethod(), (Object)url);
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    logger.debug("Cookie {}={}", (Object)cookie.getName(), (Object)cookie.getValue());
                }
            }
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                StringBuilder header = new StringBuilder(name);
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    header.append(": ").append((String)values.nextElement());
                }
                logger.debug("Header {}", (Object)header);
            }
        }
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }

    private Utils() {
    }
}

