/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Metrics
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(Metrics.class);
    private final URL m_url;
    private final ThreadLocal<Long> m_start;
    private final BlockingQueue<String> m_queue;

    public Metrics(URL url) {
        this.m_url = url;
        this.m_start = new ThreadLocal();
        this.m_queue = new ArrayBlockingQueue<String>(100);
        Thread handler = new Thread(this);
        handler.setName(this.getClass().getSimpleName());
        handler.setDaemon(true);
        handler.start();
    }

    public void start() {
        this.m_start.set(new Date().getTime());
    }

    public void send(String serviceName, String tenantId, String fields) {
        long duration = new Date().getTime() - this.m_start.get();
        this.m_start.remove();
        this.handleMetric(serviceName, tenantId, duration, fields);
    }

    private void handleMetric(String serviceName, String tenantId, long duration, String fields) {
        StringBuilder s = new StringBuilder();
        s.append(serviceName);
        if (tenantId != null && !tenantId.isEmpty()) {
            s.append(",tenant=").append(tenantId);
        }
        s.append(" duration=");
        s.append(duration);
        if (fields != null && !fields.isEmpty()) {
            s.append(",");
            s.append(fields);
        }
        this.handle(s.toString());
    }

    private HttpURLConnection getConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }

    private void handle(String measurement) {
        boolean success = this.m_queue.offer(measurement);
        if (!success) {
            LOG.error("No space available");
        }
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                String item = this.m_queue.take();
                HttpURLConnection connection = this.getConnection();
                OutputStream out = connection.getOutputStream();
                Throwable throwable = null;
                try {
                    IOUtils.write((String)item, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
                    int httpStatus = connection.getResponseCode();
                    if (httpStatus < 300) continue;
                    LOG.error("HTTP status {} sending measurement to {}: {}", (Object)httpStatus, (Object)this.m_url, (Object)IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    out.close();
                }
            }
            catch (IOException e) {
                LOG.error("Exception sending measurement to {}", (Object)this.m_url, (Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

