/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.server;

import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KmsUtil {
    public static final String KMS_PREFIX = "$1AWSKMS$";
    private static KmsUtil s_theInstance;
    private static final Logger LOG;
    private Class<?> m_utilClazz;

    public static KmsUtil getInstance() {
        if (s_theInstance == null) {
            s_theInstance = new KmsUtil();
        }
        return s_theInstance;
    }

    public String kmsEncrypt(String plaintext) {
        if (this.m_utilClazz != null) {
            try {
                Method method = this.m_utilClazz.getMethod("kmsEncrypt", String.class);
                Object retval = method.invoke(null, plaintext);
                if (retval instanceof String) {
                    return KMS_PREFIX + (String)retval;
                }
            }
            catch (Exception e) {
                LOG.error("Exception calling com.infor.eln.fips.Util.kmsEncrypt()", (Throwable)e);
            }
        }
        return "";
    }

    public String kmsDecrypt(String encrytedPassword) {
        if (encrytedPassword.startsWith(KMS_PREFIX)) {
            String base64Encrypted = encrytedPassword.substring(KMS_PREFIX.length());
            if (this.m_utilClazz != null) {
                try {
                    Method method = this.m_utilClazz.getMethod("kmsDecrypt", String.class);
                    Object retval = method.invoke(null, base64Encrypted);
                    if (retval instanceof String) {
                        return (String)retval;
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception calling com.infor.eln.fips.Util.kmsDecrypt()", (Throwable)e);
                }
            }
        }
        return "";
    }

    public void init() {
        if (this.m_utilClazz != null) {
            try {
                Method method = this.m_utilClazz.getMethod("init", new Class[0]);
                method.invoke(null, new Object[0]);
                LOG.info("Completed com.infor.eln.fips.Util.init()");
            }
            catch (Exception e) {
                LOG.error("Exception calling com.infor.eln.fips.Util.init()", (Throwable)e);
            }
        }
    }

    private KmsUtil() {
        try {
            this.m_utilClazz = Class.forName("com.infor.eln.fips.Util");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Class com.infor.eln.fips.Util not found", (Throwable)e);
        }
    }

    static {
        LOG = LogManager.getLogger(KmsUtil.class);
    }
}

