/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractBranchSvgNodeRenderer;

public abstract class AbstractContainerSvgNodeRenderer
extends AbstractBranchSvgNodeRenderer {
    @Override
    public boolean canConstructViewPort() {
        return true;
    }

    @Override
    protected boolean canElementFill() {
        return false;
    }

    @Override
    protected void doDraw(SvgDrawContext context) {
        context.addViewPort(this.calculateViewPort(context));
        super.doDraw(context);
    }

    Rectangle calculateViewPort(SvgDrawContext context) {
        Rectangle currentViewPort = context.getCurrentViewPort();
        float portX = currentViewPort.getX();
        float portY = currentViewPort.getY();
        float portWidth = currentViewPort.getWidth();
        float portHeight = currentViewPort.getHeight();
        if (this.attributesAndStyles != null) {
            if (this.attributesAndStyles.containsKey("x")) {
                portX = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("x")));
            }
            if (this.attributesAndStyles.containsKey("y")) {
                portY = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("y")));
            }
            if (this.attributesAndStyles.containsKey("width")) {
                portWidth = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("width")));
            }
            if (this.attributesAndStyles.containsKey("height")) {
                portHeight = CssDimensionParsingUtils.parseAbsoluteLength((String)((String)this.attributesAndStyles.get("height")));
            }
        }
        return new Rectangle(portX, portY, portWidth, portHeight);
    }
}

