/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml.birt;

import org.xml.sax.Attributes;

public class ReportField {
    private String kind;
    private String id;
    private String fldtype;
    private String align;
    private int col;
    private int height;
    private int width;
    private String bold;
    private String underline;
    private String content;
    private String font;

    public ReportField(String kind, Attributes attributes) {
        this.kind = kind;
        this.id = null;
        this.fldtype = attributes.getValue("fldtype");
        this.align = attributes.getValue("align");
        String s_col = attributes.getValue("col");
        this.col = s_col == null ? 0 : Integer.parseInt(s_col);
        String s_height = attributes.getValue("height");
        this.height = s_height == null ? 0 : Integer.parseInt(s_height);
        String s_width = attributes.getValue("width");
        this.width = s_width == null ? 0 : Integer.parseInt(s_width);
        this.bold = attributes.getValue("bold");
        this.underline = attributes.getValue("underline");
        this.content = attributes.getValue("content");
        this.font = attributes.getValue("font");
    }

    ReportField(ReportField f) {
        this.kind = f.kind;
        this.id = null;
        this.fldtype = f.fldtype;
        this.align = f.align;
        this.col = f.col;
        this.height = f.height - 1;
        this.width = f.width;
        this.bold = f.bold;
        this.underline = f.underline;
        this.content = f.content;
        this.font = f.font;
    }

    public int getStartPosition() {
        return this.col;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.kind.equals("text") ? this.content.length() : this.width;
    }

    public String getAlignment() {
        if ("left".equalsIgnoreCase(this.align)) {
            return "left";
        }
        if ("right".equalsIgnoreCase(this.align)) {
            return "right";
        }
        if ("centered".equalsIgnoreCase(this.align)) {
            return "center";
        }
        if ("double".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        if ("float".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        if ("integer".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        if ("long".equalsIgnoreCase(this.fldtype)) {
            return "right";
        }
        return "left";
    }

    public boolean hasDataItem() {
        return !this.hasText();
    }

    public String getName() {
        return this.id;
    }

    public void setName(String _id) {
        this.id = _id;
    }

    public boolean hasText() {
        return this.kind.equals("text");
    }

    public String getText() {
        return this.content == null ? "" : this.content;
    }

    public boolean isBold() {
        return "yes".equalsIgnoreCase(this.bold);
    }

    public boolean isUnderlined() {
        return "yes".equalsIgnoreCase(this.underline);
    }
}

