/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.BarcodeImageFactory;
import com.ssaglobal.bml.BarcodeParameter;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public class BarcodeImage {
    private static final String BARTYPE = "barType";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String FILETYPE = "fileType";
    private static final Map<String, Integer> TYPES = new HashMap<String, Integer>(){
        private static final long serialVersionUID = -5018979056472423799L;
        {
            this.put("BAR39", 0);
            this.put("BAR39EXT", 1);
            this.put("CODE93", 9);
            this.put("CODE11", 3);
            this.put("CODABAR", 4);
            this.put("CODE93EXT", 14);
            this.put("CODE128", 13);
            this.put("EAN13", 10);
            this.put("EAN8", 11);
            this.put("EAN128", 16);
            this.put("INTERLEAVED25", 2);
            this.put("POSTNET", 15);
            this.put("UPCA", 6);
            this.put("UPCE", 12);
            this.put("IND25", 7);
            this.put("MAT25", 8);
            this.put("MSI", 5);
            this.put("PDF417", 30);
            this.put("QRCODE", 500);
            this.put("DATAMATRIX", 31);
            this.put("AZTECCODE", 600);
        }
    };
    private final String value;
    private final String type;
    private final Map<String, BarcodeParameter> keyValuePairs = new HashMap<String, BarcodeParameter>();
    private boolean rotated = false;
    private Cache m_cache;

    public BarcodeImage(String type, String value, String ... parameters) {
        this.value = value;
        this.type = type;
        this.setParameterMap(parameters);
    }

    public void setCache(Cache cache) {
        this.m_cache = cache;
    }

    public boolean isRotated() {
        return this.rotated;
    }

    public BufferedImage getBarcodeImage(int widthInChars, int heightInNumberOfLines, double fontSizeFactor, boolean neverUtf8Hint) {
        try {
            BufferedImage bi;
            if (this.m_cache != null && this.type.equals("QRCODE") && (bi = this.m_cache.get(this.value)) != null) {
                return bi;
            }
            BarcodeImageFactory bif = new BarcodeImageFactory(TYPES.get(this.type), this.value, this.keyValuePairs, widthInChars, heightInNumberOfLines, fontSizeFactor, neverUtf8Hint);
            bif.createBarcode();
            this.rotated = bif.isRotated();
            if (this.m_cache != null && this.type.equals("QRCODE")) {
                this.m_cache.put(this.value, bif.getBarcodeImage());
            }
            return bif.getBarcodeImage();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot generate barcode for type " + this.type + " and value " + this.value, ex);
        }
    }

    private void setParameterMap(String ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        String pairDelim = "[;]";
        String keyValueDelim = "[=]";
        for (int j = 0; j < parameters.length; ++j) {
            if (parameters[j] == null || parameters[j].length() <= 0) continue;
            String[] tokens = parameters[j].split("[;]");
            for (int i = 0; i < tokens.length; ++i) {
                String key = tokens[i];
                String[] keyValuePair = key.split("[=]");
                String parKey = keyValuePair[0].trim().toUpperCase();
                if (keyValuePair.length <= 1) continue;
                BarcodeParameter par = new BarcodeParameter(keyValuePair[0].trim(), keyValuePair[1].trim(), this.useReflection(parKey));
                this.keyValuePairs.put(keyValuePair[0].trim(), par);
            }
        }
    }

    private boolean useReflection(String key) {
        return !key.equalsIgnoreCase(WIDTH) && !key.equalsIgnoreCase(HEIGHT) && !key.equalsIgnoreCase(BARTYPE) && !key.equalsIgnoreCase(FILETYPE) && !key.startsWith("image");
    }

    public static class Cache {
        private static HashMap<String, BufferedImage> m_cache = new HashMap();

        public BufferedImage get(String value) {
            return m_cache.get(value);
        }

        public void put(String value, BufferedImage bi) {
            m_cache.put(value, bi);
        }

        public void clear() {
            m_cache.clear();
        }
    }
}

