/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.ssaglobal.bml.FileCache;
import com.ssaglobal.bml.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BMLConverter
extends DefaultHandler {
    private Writer m_writer;
    private StringBuffer m_chars;
    private String m_charsSetDirectly;
    private int m_pass = 1;
    protected Stack m_tags = new Stack();
    private boolean m_stopWriting = false;
    private boolean m_multipleDocuments = false;
    private boolean m_lastOne = false;
    private boolean m_firstOne = true;
    private FileCache m_fileCache;
    private String m_reportId;
    private static final Logger LOG = Logger.getLogger(BMLConverter.class.getName());

    public int getNumberOfPasses() {
        return 1;
    }

    public boolean getReencodeCharacters() {
        return true;
    }

    public boolean getReencodeCharacterApos() {
        return true;
    }

    public int getPass() {
        return this.m_pass;
    }

    protected void init() {
        this.m_stopWriting = false;
        this.m_tags.clear();
    }

    protected boolean isWritingStopped() {
        return this.m_stopWriting;
    }

    protected void stopWriting() {
        this.m_stopWriting = true;
    }

    protected void startWriting() {
        this.m_stopWriting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert(String a_bmlFile, String a_file) throws SAXException, IOException {
        this.init();
        XMLReader saxParser = IOUtils.createXMLReader();
        saxParser.setContentHandler(this);
        this.m_writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(a_file), StandardCharsets.UTF_8));
        try {
            if (a_file.endsWith("xml")) {
                this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            }
            saxParser.setFeature("http://xml.org/sax/features/namespaces", false);
            saxParser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            this.parse(saxParser, a_bmlFile);
        }
        finally {
            IOUtils.closeQuietly(this.m_writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(XMLReader a_saxParser, String a_bmlFile) throws SAXException, IOException {
        try {
            this.m_multipleDocuments = false;
            for (int i = 0; i < this.getNumberOfPasses(); ++i) {
                this.m_pass = i + 1;
                try {
                    a_saxParser.parse(a_bmlFile);
                    continue;
                }
                catch (StopParsingException stopParsingException) {
                    // empty catch block
                }
            }
        }
        catch (SAXParseException e) {
            this.m_multipleDocuments = true;
            this.m_lastOne = false;
            this.m_firstOne = true;
            StringBuffer xml = new StringBuffer();
            FileInputStream fis = new FileInputStream(new File(a_bmlFile));
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                if (line.trim().startsWith("<?xml")) {
                    this.parseSingleDocument(a_saxParser, xml);
                    this.m_firstOne = false;
                    xml = new StringBuffer();
                }
                xml.append(line);
                xml.append("\n");
                line = br.readLine();
            }
            this.m_lastOne = true;
            try {
                this.parseSingleDocument(a_saxParser, xml);
            }
            finally {
                br.close();
                isr.close();
                fis.close();
            }
        }
    }

    private void parseSingleDocument(XMLReader saxParser, StringBuffer xml) throws SAXException, IOException {
        if (xml.length() > 0) {
            this.init();
            for (int i = 0; i < this.getNumberOfPasses(); ++i) {
                this.m_pass = i + 1;
                try {
                    StringReader sr = new StringReader(xml.toString());
                    InputSource source = new InputSource(sr);
                    saxParser.parse(source);
                    continue;
                }
                catch (StopParsingException stopParsingException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean hasMultipleDocuments() {
        return this.m_multipleDocuments;
    }

    public boolean isLastDocument() {
        return this.m_lastOne;
    }

    public boolean isFirstDocument() {
        return this.m_firstOne;
    }

    public void writeStartTag(String a_tag) throws IOException {
        this.writeStartTag(a_tag, true);
    }

    public void writeStartTag(String a_tag, boolean a_closeTag) throws IOException {
        if (!this.m_stopWriting) {
            this.writeSpaces();
            this.m_tags.push(new Object[]{a_tag, null});
            String s = "<" + a_tag;
            if (a_closeTag) {
                s = s + ">";
            }
            this.write(s);
        }
    }

    protected void writeSpaces() throws IOException {
        String spaces = System.getProperty("line.separator");
        for (int i = 0; i < this.m_tags.size(); ++i) {
            spaces = spaces + "   ";
        }
        this.write(spaces);
    }

    public String getCurrentTag() {
        if (this.m_tags.size() == 0) {
            return "none";
        }
        return (String)((Object[])this.m_tags.peek())[0];
    }

    public Object getCurrentExtra() {
        if (this.m_tags.size() == 0) {
            return null;
        }
        return ((Object[])this.m_tags.peek())[1];
    }

    public void setCurrentExtra(Object a_extra) {
        ((Object[])this.m_tags.elementAt((int)(this.m_tags.size() - 1)))[1] = a_extra;
    }

    public void writeEndTag() throws IOException {
        if (!this.m_stopWriting) {
            String tag = this.getCurrentTag();
            this.m_tags.pop();
            this.write("</" + tag + ">");
        }
    }

    public void write(String a_text) throws IOException {
        if (a_text != null && !this.m_stopWriting) {
            this.m_writer.write(a_text);
        }
    }

    public void writeData(String a_text) throws IOException {
        this.write("<![CDATA[" + a_text + "]]>");
    }

    public void writeTagAndData(String a_tag, String a_text) throws IOException {
        this.writeSpaces();
        this.write("<" + a_tag + ">");
        this.writeData(a_text);
        this.write("</" + a_tag + ">");
    }

    public void writeTag(String a_tag, String a_text) throws IOException {
        this.writeSpaces();
        this.write("<" + a_tag + ">");
        this.write(a_text);
        this.write("</" + a_tag + ">");
    }

    @Override
    public void startElement(String not_used_1, String not_used_2, String name, Attributes attributes) throws SAXException {
        if (name.equals("report")) {
            String id = attributes.getValue("id");
            if (id == null) {
                id = "<unknown>";
            }
            if (id.length() > 15) {
                try {
                    String reportId;
                    this.m_reportId = reportId = id.substring(1, 3) + id.substring(13, id.length());
                }
                catch (Exception e) {
                    this.m_reportId = id;
                }
            }
        }
    }

    @Override
    public void endElement(String not_used_1, String not_used_2, String name) throws SAXException {
    }

    @Override
    public void characters(char[] chars, int i0, int i1) {
        if (this.m_chars != null) {
            String s = new String(chars, i0, i1);
            if (this.getReencodeCharacters() && s.length() == 1) {
                char c = s.charAt(0);
                switch (c) {
                    case '<': {
                        s = "&lt;";
                        break;
                    }
                    case '>': {
                        s = "&gt;";
                        break;
                    }
                    case '&': {
                        s = "&amp;";
                        break;
                    }
                    case '\"': {
                        s = "&quot;";
                    }
                }
                if (c == '\'' && this.getReencodeCharacterApos()) {
                    s = "&apos;";
                }
            }
            this.m_chars.append(s);
        }
    }

    public void startCharacters() {
        this.m_chars = new StringBuffer();
    }

    public void addCharacters(String a_string) {
        this.m_chars.append(a_string);
    }

    public boolean isCharactersStarted() {
        return this.m_chars != null;
    }

    public void setCharactersDirectly(String a_value) {
        this.m_charsSetDirectly = a_value;
    }

    public String getCharacters() {
        if (this.m_charsSetDirectly != null) {
            return this.m_charsSetDirectly;
        }
        if (this.m_chars == null) {
            return "";
        }
        return this.m_chars.toString();
    }

    public void stopCharacters() {
        this.m_chars = null;
        this.m_charsSetDirectly = null;
    }

    protected void setWriter(Writer a_writer) {
        this.m_writer = a_writer;
    }

    protected Writer getWriter() {
        return this.m_writer;
    }

    public void setFileCache(FileCache fileCache) {
        this.m_fileCache = fileCache;
    }

    public FileCache getFileCache() {
        return this.m_fileCache;
    }

    public String getLocalFileName(String a_file) {
        if (this.m_fileCache != null) {
            try {
                return this.m_fileCache.getLocalFileName(a_file);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot get the file from the FileCache", e);
            }
        }
        return a_file;
    }

    public File getLocalFile(String a_file) {
        return new File(this.getLocalFileName(a_file));
    }

    public File getLocalFileNoException(String a_file) {
        try {
            return this.getLocalFile(a_file);
        }
        catch (Exception e) {
            return new File("Error: " + a_file);
        }
    }

    public String getReportId() {
        return this.m_reportId;
    }

    protected void setReportId(String id) {
        this.m_reportId = id;
    }

    public static String convertBML(String fileService, String[] args) throws Exception {
        String[] newArgs = new String[args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = args[i];
        }
        newArgs[args.length] = "fileservice=" + fileService;
        return BMLConverter.convertAndReturnReportId(newArgs);
    }

    public static String convert(String[] args) {
        try {
            BMLConverter.main(args);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return sw.toString();
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        BMLConverter.convertAndReturnReportId(args);
    }

    public static String convertAndReturnReportId(String[] args) throws Exception {
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < args.length; ++j) {
                sb.append("arg[" + j + "]='" + args[j].trim() + "';");
            }
            LOG.info("Method 'main' called, " + sb.toString());
        }
        try {
            String className = "com.ssaglobal.bml.BML2" + args[0].trim();
            Class<?> clazz = Class.forName(className);
            int size = args.length - 1;
            Class[] argumentTypes = new Class[size];
            Object[] arguments = new Object[size];
            for (int i = 0; i < size; ++i) {
                argumentTypes[i] = String.class;
                arguments[i] = args[i + 1].trim();
            }
            Method convert = clazz.getMethod("convertBML", argumentTypes);
            Object reportId = convert.invoke(null, arguments);
            return (String)reportId;
        }
        catch (Exception e) {
            System.out.println("\nExample usage: java -classpath bml2pdf.jar;. com.ssaglobal.bml.BMLConverter PDF <BML file in> <PDF file out>");
            System.out.println("\n    Supported conversions: HTML, BIRT, BIRTData, BIRTDesign, PDF, Rosettanet, TXT");
            if (e instanceof InvocationTargetException) {
                LOG.log(Level.SEVERE, "BMLConverter failed", ((InvocationTargetException)e).getCause());
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw e;
            }
            LOG.log(Level.SEVERE, "BMLConverter failed", e);
            throw e;
        }
    }

    public class StopParsingException
    extends RuntimeException {
    }
}

