/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.commons.utils.Base64;
import com.ssaglobal.bml.BML2PDF;
import com.ssaglobal.bml.BMLConverter;
import com.ssaglobal.bml.BarcodeCellLayout;
import com.ssaglobal.bml.CellLayout;
import com.ssaglobal.bml.IOUtils;
import com.ssaglobal.bml.ImageCellLayout;
import com.ssaglobal.bml.LinesCellLayout;
import com.ssaglobal.bml.NPagesTextCellLayout;
import com.ssaglobal.bml.PageNo;
import com.ssaglobal.bml.PageNoTextCellLayout;
import com.ssaglobal.bml.Style;
import com.ssaglobal.bml.TextCellLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class BML2HTML
extends BMLConverter {
    private Hashtable<String, RowLayout> m_rowLayouts;
    private RowLayout m_currentRow;
    private Vector<Object[]> m_fieldsWithHeightHigherThanOne;
    private ArrayList<TextCellLayout> m_waitingFields;
    private int m_countPages;
    private int m_pwidth;
    private boolean m_monospace;
    private int m_pageNoPageBreak;
    private ArrayList<PageNoTextCellLayout> m_pageNoTextCellLayouts;
    private int m_pageNoTextCellLayoutIndex;
    private PageNo m_pageNo;
    private boolean m_testMode;
    private boolean m_showNavigation;
    private boolean m_showCompanyLogo;
    protected String m_negativeSignOnNumbersOnTheRight;
    private boolean m_largeReport;
    private static final int LARGE_REPORT = 500;
    private String m_font;
    private String m_monospacedFont;
    private boolean m_pendingPagebreak;
    private String m_locale;
    private boolean m_bidi;
    private int m_numberOfCharactersForTheCurrentLine;
    private String m_layoutFont;
    private String m_reportFont;
    private Hashtable<String, Integer> m_numberOfCharactersOnLinePerFont;
    private String m_currentCharactersBeforeBarcode;
    private int m_numberOfSpacesForTab;
    private boolean m_inBody;
    private BarcodeCellLayout m_currentBarcodeCellLayout;
    private String m_currentOptionName;
    private Boolean m_justify;
    private Boolean m_layoutJustify;
    private float m_rowFixedOffset;
    private String m_reportTitle;
    private boolean m_firstLayout = true;
    private String m_reportLanguage;
    private ArrayList<Style> m_styles = new ArrayList();
    private ArrayList<Style> m_currentHeaderStyles = new ArrayList();
    private ArrayList<Style> m_currentBodyStyles = new ArrayList();
    private String m_bgItems = null;

    @Override
    protected void init() {
        super.init();
        this.m_rowLayouts = new Hashtable();
        this.m_currentRow = null;
        this.m_fieldsWithHeightHigherThanOne = new Vector();
        this.m_waitingFields = new ArrayList();
        this.m_countPages = 0;
        this.m_pwidth = 0;
        this.m_monospace = false;
        this.m_pageNoPageBreak = 1;
        this.m_pageNoTextCellLayouts = new ArrayList();
        this.m_pageNoTextCellLayoutIndex = 0;
        this.m_pageNo = null;
        this.m_testMode = false;
        this.m_showNavigation = true;
        this.m_showCompanyLogo = true;
        this.m_negativeSignOnNumbersOnTheRight = "-";
        this.m_largeReport = false;
        this.m_font = "font-family:verdana;font-size:x-small";
        this.m_monospacedFont = "font-family:courier new;font-size:x-small";
        this.m_pendingPagebreak = false;
        this.m_locale = "ISO88591";
        this.m_bidi = false;
        this.m_numberOfCharactersForTheCurrentLine = 0;
        this.m_layoutFont = null;
        this.m_reportFont = null;
        this.m_numberOfCharactersOnLinePerFont = new Hashtable();
        this.m_currentCharactersBeforeBarcode = null;
        this.m_numberOfSpacesForTab = 0;
        this.m_inBody = false;
        this.m_currentBarcodeCellLayout = null;
        this.m_currentOptionName = null;
        this.m_justify = null;
        this.m_layoutJustify = null;
        this.m_rowFixedOffset = -1.0f;
        this.m_reportTitle = null;
        this.m_numberOfSpacesForTab = this.getSpacesPerTab();
    }

    protected int getSpacesPerTab() {
        return 8;
    }

    public boolean isBidi() {
        return this.m_bidi;
    }

    public void setBidi(boolean a_bidi) {
        this.m_bidi = a_bidi;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public int getPWidth() {
        return this.m_pwidth;
    }

    @Override
    public boolean getReencodeCharacters() {
        return true;
    }

    @Override
    public boolean getReencodeCharacterApos() {
        return false;
    }

    protected void setNumberOfCharactersForTheCurrentLine(int a_number, String a_font, boolean a_justify) {
        this.m_numberOfCharactersForTheCurrentLine = a_number;
    }

    protected int getNumberOfCharactersForTheCurrentLine() {
        return this.m_numberOfCharactersForTheCurrentLine;
    }

    protected void writeBorderCell(int col, int a_width, int a_borderType, Style a_style) throws IOException {
        if (a_width != 1) {
            this.write("<td colspan=\"" + a_width + "\"' ");
        } else {
            this.write("<td ");
        }
        this.write("class=\"b" + a_borderType + "\">&nbsp&nbsp</td>");
    }

    protected void writeTextCell(String a_text, int col, int a_width, int a_align, boolean a_splitUpTheTextInSpans, String a_font, Style a_style) throws IOException {
        boolean monospace = this.isMonospaced() || a_style != null && a_style.getMonospace() != null && a_style.getMonospace() != false;
        this.write("<td ");
        if (a_width != 1) {
            this.write("colspan=\"" + a_width + "\" ");
        }
        this.write("class=\"");
        if (a_align == 0) {
            this.write("al ");
        } else if (a_align == 1) {
            this.write("ac ");
        } else if (a_align == 2) {
            this.write("ar ");
        }
        if (monospace) {
            this.write("bold ");
        }
        if (monospace) {
            this.write("mono ");
        }
        if (a_text.trim().equals("")) {
            a_text = "&nbsp;";
        }
        this.write("\" ");
        if (this.m_testMode) {
            if (a_align == 0) {
                this.write("align=left ");
            } else if (a_align == 1) {
                this.write("align=center ");
            } else if (a_align == 2) {
                this.write("align=right ");
            }
            if (a_style != null && a_style.getBold().booleanValue()) {
                this.write("style='font-weight:bold' ");
            }
        }
        this.write(" >");
        if (a_style != null && a_style.getUnderline() != null && a_style.getUnderline().booleanValue()) {
            this.write("<u>");
        }
        if (a_splitUpTheTextInSpans && !monospace) {
            char lastChar = a_text.charAt(a_text.length() - 1);
            String txt = null;
            boolean signIsNotVisible = Character.isDigit(lastChar);
            if (signIsNotVisible) {
                txt = a_text;
            } else {
                txt = a_text.substring(0, a_text.length() - 1);
                this.m_negativeSignOnNumbersOnTheRight = "" + lastChar;
            }
            this.write("<span>" + txt + "</span><span");
            if (signIsNotVisible) {
                this.write(" style='visibility:hidden'");
            }
            this.write(" >" + this.m_negativeSignOnNumbersOnTheRight + "</span>");
        } else {
            if (monospace) {
                a_text = a_text.replaceAll(" ", "&nbsp;");
            }
            this.write(a_text + "</td>");
        }
        if (a_style != null && a_style.getUnderline() != null && a_style.getUnderline().booleanValue()) {
            this.write("</u>");
        }
    }

    protected void writeBarcode(int col, int width, BarCode barCode, String a_font, Style a_style) throws IOException {
    }

    protected void writeImage(int col, int width, int height, String filePath, int halign, int valign, Style a_style, String a_signatureId, boolean svg, boolean background) {
    }

    private void writeRulerIfNeeded() throws IOException {
        if (this.m_testMode) {
            // empty if block
        }
    }

    protected void writePageHeader() throws IOException {
        int previousPage = this.m_countPages - 1;
        int nextPage = this.m_countPages + 1;
        if (this.m_countPages == 1 || this.m_largeReport) {
            if (this.m_testMode) {
                this.write("\n<table border='1' cellspacing='0' cellpadding='0' class='main'>");
                this.writeRulerIfNeeded();
            } else {
                this.write("\n<table border='0' cellspacing='0' cellpadding='0' class='main'>");
            }
        }
        this.write("<tr><td colspan=" + (this.m_pwidth + 2) + ">");
        if (this.m_countPages == 1) {
            this.write("<div id=\"" + this.m_countPages + "\" class=\"default-bg\"><span>");
        } else {
            this.write("<div id=\"" + this.m_countPages + "\" class=\"newpage default-bg\"><span>");
        }
        if (this.m_showNavigation) {
            if (this.m_showCompanyLogo) {
                if (this.m_testMode) {
                    this.write("<img name='clogo' class='clogo' src='companylogo.gif'/>");
                } else {
                    this.write("<img name='clogo' class='clogo' src='../images/ssa/header/companylogo.gif'/>");
                }
            }
            this.write("<a class=\"nav firstPage\" onclick=\"gotoPage(1)\"><img src='../images/ssa/grid/icon_first15x15_enabled.png'/></a>");
            this.write("<a class=\"nav prevPage\"  onclick=\"gotoPage(" + previousPage + ")\"><img src='../images/ssa/grid/icon_previous15x15_enabled.png'/></a>");
            this.write("<a class=\"nav nextPage\"  onclick=\"gotoPage(" + nextPage + ")\"><img src='../images/ssa/grid/icon_next15x15_enabled.png'/></a>");
            this.write("<a class=\"nav lastPage\"  onclick=\"lastPage()\"><img src='../images/ssa/grid/icon_last15x15_enabled.png'/></a>");
        }
        this.write("</span></div>");
        this.write("</td></tr>\n");
        if (!this.m_largeReport && this.m_countPages == 1) {
            this.write("<tr style='visibility:hidden'>");
            for (int i = 1; i <= this.m_pwidth + 2; ++i) {
                this.write("<td>&nbsp;</td>");
            }
            this.write("</tr>\n");
        } else if (this.m_largeReport) {
            this.write("<tr style='visibility:hidden'>");
            for (int i = 1; i <= this.m_pwidth + 2; ++i) {
                this.write("<td>_</td>");
            }
            this.write("</tr>\n");
        }
    }

    private void writePageHeaderIfNeeded() throws IOException {
        if (this.m_pendingPagebreak) {
            if (this.getPass() == 1) {
                ++this.m_countPages;
            }
            this.writePageHeader();
        }
        this.m_pendingPagebreak = false;
    }

    protected void writeReportHeader(String a_reportTitle, String reportLanguage) throws IOException {
        this.write("<html>");
        this.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>\n");
        this.write("<title>" + a_reportTitle + "</title>\n");
        if (this.m_testMode) {
            this.write("<link href=\"report.css\" type=\"text/css\" rel=\"stylesheet\">");
        } else {
            this.write("<link href=\"../stylesheets/ssa/report.css\" type=\"text/css\" rel=\"stylesheet\">");
        }
        this.write("<style type=\"text/css\">\n");
        if (this.m_monospace) {
            this.write("body{" + this.m_monospacedFont + "}\n");
            this.write("table{" + this.m_monospacedFont + "}\n");
        } else {
            this.write("body{" + this.m_font + "}\n");
            this.write("table{" + this.m_font + "}\n");
            this.write(".mono{" + this.m_monospacedFont + "}\n");
        }
        this.write("</style>\n");
        if (this.m_bidi) {
            this.write("<body dir=\"RTL\">\n");
        } else {
            this.write("<body>\n");
        }
    }

    protected void writeStartOfNewLine() throws IOException {
        this.writeStartTag("tr");
        this.write("<td class='lc'>&nbsp;</td>");
    }

    protected void writeEmptyLine() throws IOException {
        this.write("\n<tr>\n\t<td>&nbsp;</td>\n</tr>");
    }

    protected void writePageBreakIfNeeded() throws IOException {
        if (this.m_largeReport) {
            this.write("\n</td></tr></table>");
        }
    }

    public int parseInt(String value, int defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        int i = defaultValue;
        try {
            i = (int)Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    protected double parseDouble(String value, double defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        double d = defaultValue;
        try {
            d = Double.parseDouble(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private String getFont(Attributes attributes, boolean cellLevel) {
        Integer n;
        String fontSize = attributes.getValue("fontsize");
        String fontName = attributes.getValue("font");
        if (fontSize != null && !fontSize.isEmpty()) {
            int index;
            if (fontName == null || fontName.isEmpty()) {
                fontName = this.m_currentRow.getRowFont();
            }
            if ((index = fontName.indexOf(" (")) != -1) {
                fontName = fontName.substring(0, index);
            }
            return fontName + " (" + fontSize + " pt)";
        }
        if (cellLevel && this.m_currentRow.getRowFont().indexOf("pt)") != -1) {
            if (fontName == null || fontName.isEmpty()) {
                return this.m_currentRow.getRowFont();
            }
            int index = fontName.indexOf(" (");
            if (index != -1) {
                fontName = fontName.substring(0, index);
            }
            index = this.m_currentRow.getRowFont().indexOf(" (");
            return fontName + this.m_currentRow.getRowFont().substring(index);
        }
        if (cellLevel && fontName != null && !fontName.isEmpty() && (n = this.m_numberOfCharactersOnLinePerFont.get(fontName)) != null) {
            double pt = this.getFontSizeInPt(n);
            int index = fontName.indexOf(" (");
            if (index != -1) {
                fontName = fontName.substring(0, index);
            }
            return fontName + " (" + pt + " pt)";
        }
        if (cellLevel && fontName != null && fontName.indexOf("cpi") != -1) {
            double pt = this.getFontSizePt(fontName);
            int index = fontName.indexOf(" (");
            if (index != -1) {
                fontName = fontName.substring(0, index);
            }
            return fontName + " (" + pt + " pt)";
        }
        return fontName;
    }

    protected double getFontSizeInPt(int n) {
        return (double)BML2PDF.DEFAULT_FONT_SIZE_FACTOR * 510.0 / (double)n;
    }

    private double getFontSizeCpi(String a_font) {
        int index = a_font.indexOf(" cpi") - 1;
        if (index > 0) {
            String s = "";
            char c = a_font.charAt(index);
            while (index > 0 && (Character.isDigit(c) || c == '.')) {
                s = c + s;
                c = a_font.charAt(--index);
            }
            double size = 12.0;
            try {
                size = Double.parseDouble(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return size;
        }
        return -1.0;
    }

    private double getFontSizePt(String a_font) {
        double cpi = this.getFontSizeCpi(a_font);
        if (cpi > 0.0) {
            double pt = 120.0 / cpi;
            return pt;
        }
        return -1.0;
    }

    public static int getAlign(String align) {
        if (align == null) {
            return 0;
        }
        if ((align = align.toLowerCase()).contains("right")) {
            return 2;
        }
        if (align.contains("center")) {
            return 1;
        }
        if (align.contains("left")) {
            return 0;
        }
        if (align.contains("top")) {
            return 0;
        }
        if (align.contains("bottom")) {
            return 2;
        }
        return 0;
    }

    public static String getHAlign(Attributes attributes) {
        String align = attributes.getValue("align");
        if (align == null) {
            align = attributes.getValue("halign");
        }
        return align;
    }

    private void handleClasses(String classNames, Style style) {
        if (classNames != null) {
            String[] classes = classNames.split(" ");
            for (int i = 0; i < this.m_styles.size(); ++i) {
                String name = this.m_styles.get(i).getName();
                for (int j = 0; j < classes.length; ++j) {
                    String clazz = classes[j];
                    if (!clazz.equals(name)) continue;
                    Style s = this.getStyle(clazz);
                    style.merge(s, true);
                }
            }
        }
    }

    private void endStyle(String tag, boolean header) {
        if (header) {
            this.m_currentHeaderStyles.remove(this.m_currentHeaderStyles.size() - 1);
        } else {
            this.m_currentBodyStyles.remove(this.m_currentBodyStyles.size() - 1);
        }
    }

    private Style createStyle(String tag, Attributes attributes, boolean header) {
        Style style = this.createStyle(tag, header);
        this.createPlainStyle(attributes, style);
        return style;
    }

    private Style createStyle(String tag, boolean header) {
        Style style;
        if (tag.equals("style")) {
            return new Style();
        }
        if (header) {
            if (this.m_currentHeaderStyles.size() > 0) {
                Style prev = this.m_currentHeaderStyles.get(this.m_currentHeaderStyles.size() - 1);
                style = new Style();
                style.merge(prev, false);
            } else {
                style = new Style();
            }
            style.setTag(tag);
            this.m_currentHeaderStyles.add(style);
        } else {
            if (this.m_currentBodyStyles.size() > 0) {
                Style prev = this.m_currentBodyStyles.get(this.m_currentBodyStyles.size() - 1);
                style = new Style();
                style.merge(prev, false);
            } else {
                style = new Style();
            }
            style.setTag(tag);
            this.m_currentBodyStyles.add(style);
        }
        return style;
    }

    private void createPlainStyle(Attributes attributes, Style style) {
        String classNames = attributes.getValue("class");
        this.handleClasses(classNames, style);
        String fgcolor = attributes.getValue("fgcolor");
        String bgcolor = attributes.getValue("bgcolor");
        String linefgcolor = attributes.getValue("linefgcolor");
        String linebgcolor = attributes.getValue("linebgcolor");
        String bgcolor1 = attributes.getValue("bgcolortopleft");
        String bgcolor2 = attributes.getValue("bgcolortopright");
        String bgcolor4 = attributes.getValue("bgcolorbottomleft");
        String bgcolor3 = attributes.getValue("bgcolorbottomright");
        String thickness = attributes.getValue("thickness");
        String lineStyle = attributes.getValue("linestyle");
        String height = attributes.getValue("height");
        String border = attributes.getValue("border");
        String borderLeft = attributes.getValue("borderleft");
        String borderRight = attributes.getValue("borderright");
        String borderTop = attributes.getValue("bordertop");
        String borderBottom = attributes.getValue("borderbottom");
        String bold = attributes.getValue("bold");
        String italic = attributes.getValue("italic");
        String underline = attributes.getValue("underline");
        String monospace = attributes.getValue("monospace");
        String halign = attributes.getValue("halign");
        String valign = attributes.getValue("valign");
        if (fgcolor != null) {
            style.setForegroundColor(fgcolor);
        }
        if (bgcolor != null) {
            style.setBackgroundColor(bgcolor);
        }
        if (linefgcolor != null) {
            style.setLineForegroundColor(linefgcolor);
        }
        if (linebgcolor != null) {
            style.setLineBackgroundColor(linebgcolor);
        }
        if (bgcolor1 != null) {
            style.setBackgroundColor1(bgcolor1);
        }
        if (bgcolor2 != null) {
            style.setBackgroundColor2(bgcolor2);
        }
        if (bgcolor3 != null) {
            style.setBackgroundColor3(bgcolor3);
        }
        if (bgcolor4 != null) {
            style.setBackgroundColor4(bgcolor4);
        }
        if (thickness != null) {
            style.setThickness(this.parseDouble(thickness, 0.0));
        }
        if (lineStyle != null) {
            style.setLineStyle(Style.BorderType.valueOf(lineStyle));
        }
        if (height != null) {
            style.setHeight(this.parseInt(height, 1));
        }
        if (border != null) {
            style.setBorder(Style.createBorder(border));
        }
        if (borderLeft != null) {
            style.setBorderLeft(Style.createBorder(borderLeft));
        }
        if (borderRight != null) {
            style.setBorderRight(Style.createBorder(borderRight));
        }
        if (borderTop != null) {
            style.setBorderTop(Style.createBorder(borderTop));
        }
        if (borderBottom != null) {
            style.setBorderBottom(Style.createBorder(borderBottom));
        }
        if (bold != null) {
            style.setBold("Yes".equals(bold));
        }
        if (italic != null) {
            style.setItalic("Yes".equals(italic));
        }
        if (underline != null) {
            style.setUnderline("Yes".equals(underline));
        }
        if (monospace != null) {
            style.setMonospace("Yes".equals(monospace));
        }
        if (halign != null) {
            style.setHAlign(BML2HTML.getAlign(halign));
        }
        if (valign != null) {
            style.setVAlign(BML2HTML.getAlign(valign));
        }
    }

    private void setStyle(CellLayout cell) {
        Style style = this.m_currentHeaderStyles.get(this.m_currentHeaderStyles.size() - 1);
        cell.setStyle(style);
    }

    @Override
    public void startElement(String not_used_1, String not_used_2, String name, Attributes attributes) throws SAXException {
        block80: {
            try {
                super.startElement(not_used_1, not_used_2, name, attributes);
                if (name.equals("report")) {
                    this.createStyle("report", attributes, true);
                    this.m_firstLayout = true;
                    this.m_reportTitle = attributes.getValue("desc");
                    this.m_reportLanguage = attributes.getValue("lang");
                    this.m_pwidth = this.parseInt(attributes.getValue("pwidth"), -1);
                    this.m_monospace = "Yes".equals(attributes.getValue("monospace"));
                    this.m_reportFont = this.getFont(attributes, false);
                    String justify = attributes.getValue("justify");
                    if (justify != null && !justify.isEmpty()) {
                        this.m_justify = "Yes".equals(justify);
                    }
                    if (this.getPass() == 1) {
                        this.m_countPages = 1;
                    }
                    if (this.m_pageNo != null) {
                        this.m_pageNo.reset(this.getPass());
                    }
                    this.m_pageNoTextCellLayoutIndex = 0;
                    this.m_pageNoPageBreak = 1;
                    break block80;
                }
                if (name.equals("row")) {
                    this.writePageHeaderIfNeeded();
                    this.writeRulerIfNeeded();
                    this.createStyle("row", attributes, false);
                    String currentRowId = attributes.getValue("layout");
                    this.fillCurrentRow(attributes);
                    this.checkFixedOffset(attributes);
                    if (this.m_currentRow == null) {
                        if (this.m_testMode) {
                            System.err.println("There is no lline with this ID: " + currentRowId + ". Row will not be printed.");
                        }
                    } else {
                        this.writeStartOfNewLine();
                    }
                    break block80;
                }
                if (name.equals("e")) {
                    this.createStyle(name, attributes, false);
                    String pv = attributes.getValue("pv");
                    if (pv != null && pv.length() > 0 && this.m_currentRow != null) {
                        CellLayout cell = this.m_currentRow.addE(pv);
                        if (cell instanceof TextCellLayout) {
                            TextCellLayout textCell = (TextCellLayout)cell;
                            textCell.setIgnoreDifo(true);
                        }
                    } else {
                        this.startCharacters();
                    }
                    break block80;
                }
                if (name.equals("body")) {
                    this.m_inBody = true;
                    this.createStyle("body", attributes, false);
                    break block80;
                }
                if (name.equals("head")) {
                    this.m_inBody = false;
                    this.createStyle("head", attributes, true);
                    break block80;
                }
                if (name.equals("barcode")) {
                    if (this.m_inBody) {
                        this.m_currentCharactersBeforeBarcode = this.getCharacters();
                        int type = this.parseInt(attributes.getValue("type"), -1);
                        int height = this.parseInt(attributes.getValue("height"), 3);
                        String options = attributes.getValue("options");
                        boolean base64Encoded = !"false".equals(attributes.getValue("base64"));
                        String value = attributes.getValue("caption");
                        if (value != null && !value.isEmpty()) {
                            base64Encoded = false;
                        }
                        int width = -1;
                        CellLayout cellLayout = this.m_currentRow.get(false);
                        if (cellLayout != null) {
                            width = cellLayout.getWidth();
                        }
                        BarCode bc = new BarCode(type, width, height, options, this.m_currentCharactersBeforeBarcode.length(), base64Encoded);
                        if (value != null && !value.isEmpty()) {
                            bc.setValue(value);
                        }
                        this.m_currentRow.addBarCode(bc);
                        this.startCharacters();
                    } else {
                        int col = this.parseInt(attributes.getValue("col"), -1);
                        int width = this.parseInt(attributes.getValue("width"), -1);
                        int height = this.parseInt(attributes.getValue("height"), -1);
                        String type = attributes.getValue("barcodeType");
                        this.createStyle(name, attributes, true);
                        BarcodeCellLayout cell = new BarcodeCellLayout(col, width, height, type);
                        this.setStyle(cell);
                        this.m_currentRow.addCell(cell);
                        this.m_currentBarcodeCellLayout = cell;
                    }
                    break block80;
                }
                if (name.equals("option")) {
                    this.m_currentOptionName = attributes.getValue("name");
                    this.startCharacters();
                    break block80;
                }
                if (name.equals("pagebreak")) {
                    ++this.m_pageNoPageBreak;
                    if (this.m_pageNo != null) {
                        this.m_pageNo.nextPage(this.getPass());
                    }
                    this.writePageBreakIfNeeded();
                    this.m_pendingPagebreak = true;
                    break block80;
                }
                if (name.equals("emptyline")) {
                    this.createStyle("emptyline", attributes, false);
                    if (this.useExactPosition()) {
                        this.writePageHeaderIfNeeded();
                        this.checkFixedOffset(attributes);
                        this.fillCurrentRow(attributes);
                        this.writeStartOfNewLine();
                    } else {
                        this.writePageHeaderIfNeeded();
                        if (this.m_waitingFields != null && this.m_waitingFields.size() > 0) {
                            RowLayout currentRow = null;
                            String currentRowId = attributes.getValue("layout");
                            if (currentRowId != null) {
                                currentRow = this.m_rowLayouts.get(currentRowId);
                            }
                            if (currentRow == null) {
                                currentRow = new RowLayout();
                            }
                            this.m_currentRow = currentRow;
                            this.m_bgItems = attributes.getValue("bgitems");
                            this.m_currentRow.createTempStyles();
                            this.writeStartOfNewLine();
                            this.writeRow();
                        } else {
                            String currentRowId = attributes.getValue("layout");
                            if (currentRowId != null && !currentRowId.isEmpty()) {
                                this.m_currentRow = this.m_rowLayouts.get(currentRowId);
                                this.m_bgItems = attributes.getValue("bgitems");
                                if (this.m_currentRow != null) {
                                    this.m_currentRow.createTempStyles();
                                }
                                this.writeStartOfNewLine();
                                this.writeRow();
                            } else {
                                this.writeEmptyLine();
                            }
                        }
                    }
                    break block80;
                }
                if (name.equals("lline")) {
                    String justify;
                    this.createStyle(name, attributes, true);
                    String currentRowId = attributes.getValue("id");
                    this.m_currentRow = new RowLayout();
                    this.m_currentRow.setFont(this.m_layoutFont);
                    if (this.m_layoutJustify != null) {
                        this.m_currentRow.setJustify(this.m_layoutJustify);
                    }
                    if ((justify = attributes.getValue("justify")) != null && !justify.isEmpty()) {
                        this.m_currentRow.setJustify("Yes".equals(justify));
                    }
                    this.m_rowLayouts.put(currentRowId, this.m_currentRow);
                    for (int i = 0; i < this.m_fieldsWithHeightHigherThanOne.size(); ++i) {
                        Object[] field = this.m_fieldsWithHeightHigherThanOne.elementAt(i);
                        CellLayout cell = (CellLayout)field[0];
                        int[] height = (int[])field[1];
                        this.m_currentRow.addCell(cell);
                        height[0] = height[0] - 1;
                        if (height[0] > 0) continue;
                        this.m_fieldsWithHeightHigherThanOne.remove(i);
                        --i;
                    }
                    break block80;
                }
                if (name.equals("image") || name.equals("signature") || name.equals("svg")) {
                    int col = this.parseInt(attributes.getValue("col"), -1);
                    int width = this.parseInt(attributes.getValue("width"), -1);
                    int height = this.parseInt(attributes.getValue("height"), -1);
                    String halignString = attributes.getValue("halign");
                    int halign = BML2HTML.getAlign(halignString);
                    String valignString = attributes.getValue("valign");
                    int valign = BML2HTML.getAlign(valignString);
                    this.createStyle(name, attributes, true);
                    ImageCellLayout cell = new ImageCellLayout(col, width, height, halign, valign, name.equals("signature") ? attributes.getValue("id") : null, name.equals("svg"));
                    this.setStyle(cell);
                    this.m_currentRow.addCell(cell);
                    break block80;
                }
                if (name.equals("special") || name.equals("field")) {
                    boolean showAsImage;
                    String difo;
                    boolean number;
                    String align = BML2HTML.getHAlign(attributes);
                    String fldtype = attributes.getValue("fldtype");
                    boolean bl = number = fldtype != null && (fldtype.equalsIgnoreCase("double") || fldtype.equalsIgnoreCase("float") || fldtype.equalsIgnoreCase("integer"));
                    if (!number && (difo = attributes.getValue("difo")) != null && difo.startsWith("%A")) {
                        number = true;
                    }
                    if ((align == null || align.equals("") || align.toLowerCase().startsWith("not")) && number) {
                        align = "Right";
                    }
                    boolean addAnotherCellForTheMinusSign = false;
                    if (number) {
                        addAnotherCellForTheMinusSign = true;
                    }
                    int col = this.parseInt(attributes.getValue("col"), -1);
                    int width = this.parseInt(attributes.getValue("width"), -1);
                    TextCellLayout cell = new TextCellLayout(col, width, align, addAnotherCellForTheMinusSign);
                    if ("Page No.".equals(attributes.getValue("type")) || "lattr.pageno".equals(attributes.getValue("fldname"))) {
                        if (this.getPass() == 1) {
                            if (this.m_pageNo == null) {
                                this.m_pageNo = new PageNo();
                            }
                            PageNoTextCellLayout pageNoTextCellLayout = new PageNoTextCellLayout(col, width, align, addAnotherCellForTheMinusSign, this.m_pageNo);
                            this.m_pageNoTextCellLayouts.add(pageNoTextCellLayout);
                            cell = pageNoTextCellLayout;
                        } else {
                            cell = this.m_pageNoTextCellLayouts.get(this.m_pageNoTextCellLayoutIndex);
                            ++this.m_pageNoTextCellLayoutIndex;
                        }
                    } else if ("Total Pages".equals(attributes.getValue("type"))) {
                        cell = new NPagesTextCellLayout(col, width, align, addAnotherCellForTheMinusSign);
                    }
                    this.createStyle(name, attributes, true);
                    this.setStyle(cell);
                    if (!"Yes".equals(attributes.getValue("eformatted"))) {
                        cell.setDifo(attributes.getValue("difo"));
                    }
                    if (showAsImage = "Yes".equals(attributes.getValue("showAsImage"))) {
                        int height = attributes.getValue("height") == null ? 1 : this.parseInt(attributes.getValue("height"), -1);
                        int ha = BML2HTML.getAlign(attributes.getValue("halign"));
                        int va = BML2HTML.getAlign(attributes.getValue("valign"));
                        ImageCellLayout imageCell = new ImageCellLayout(col, width, height, ha, va, null, false);
                        this.m_currentRow.addCell(imageCell);
                    } else {
                        String font;
                        int skip;
                        int height;
                        this.m_currentRow.addCell(cell);
                        int n = height = attributes.getValue("height") == null ? 0 : this.parseInt(attributes.getValue("height"), -1);
                        if (height > 1) {
                            this.m_fieldsWithHeightHigherThanOne.addElement(new Object[]{cell.copy(), new int[]{height - 1}});
                        }
                        int n2 = skip = attributes.getValue("skip") == null ? 0 : this.parseInt(attributes.getValue("skip"), -1);
                        if (skip > 0) {
                            cell.setWait(skip);
                            cell.setCurrentWait(skip);
                        }
                        if ((font = this.getFont(attributes, true)) != null && !font.equals("")) {
                            cell.setFont(font);
                        }
                    }
                    break block80;
                }
                if (name.equals("text")) {
                    int skip;
                    String alignString = BML2HTML.getHAlign(attributes);
                    int align = BML2HTML.getAlign(alignString);
                    String font = this.getFont(attributes, true);
                    Style style = this.createStyle(name, attributes, true);
                    String width = attributes.getValue("width");
                    String txt = attributes.getValue("content");
                    int w = -1;
                    if (width != null && !width.isEmpty()) {
                        try {
                            w = Integer.parseInt(width);
                            if (w == txt.length()) {
                                w = -1;
                            }
                        }
                        catch (Exception e) {
                            w = -1;
                        }
                    }
                    int n = skip = attributes.getValue("skip") == null ? 0 : this.parseInt(attributes.getValue("skip"), -1);
                    if (w == -1) {
                        this.addCells(this.parseInt(attributes.getValue("col"), -1), txt, font, align, skip, style);
                    } else {
                        this.addCell(this.parseInt(attributes.getValue("col"), -1), txt, w, -1, font, align, skip, style);
                    }
                    break block80;
                }
                if (name.equals("bgitem")) {
                    int col = this.parseInt(attributes.getValue("col"), -1);
                    int width = this.parseInt(attributes.getValue("width"), -1);
                    this.createStyle(name, attributes, true);
                    LinesCellLayout cell = new LinesCellLayout(col, width, -1);
                    this.setStyle(cell);
                    this.m_currentRow.addCell(cell);
                } else if (name.equals("layout")) {
                    if (this.m_firstLayout) {
                        this.writeReportHeader(this.m_reportTitle, this.m_reportLanguage);
                        this.writePageHeader();
                        this.m_firstLayout = false;
                    }
                    this.createStyle(name, attributes, true);
                    String font = this.getFont(attributes, false);
                    if (font != null && !font.equals("")) {
                        this.m_layoutFont = font;
                        if (this.m_reportFont.indexOf("pt)") != -1 && this.m_layoutFont.indexOf("pt)") == -1) {
                            int index = this.m_layoutFont.indexOf(" (");
                            if (index != -1) {
                                this.m_layoutFont = this.m_layoutFont.substring(0, index);
                            }
                            index = this.m_reportFont.indexOf(" (");
                            this.m_layoutFont = this.m_layoutFont + this.m_reportFont.substring(index);
                        }
                    }
                    this.m_layoutJustify = null;
                    String justify = attributes.getValue("justify");
                    if (justify != null && !justify.isEmpty()) {
                        this.m_layoutJustify = "Yes".equals(justify);
                    }
                    if (this.useExactPosition()) {
                        String currentRowId = attributes.getValue("id");
                        this.m_currentRow = new RowLayout();
                        this.m_currentRow.setFont(this.m_layoutFont);
                        this.m_rowLayouts.put(currentRowId, this.m_currentRow);
                        this.m_currentRow.setHeight((float)this.parseDouble(attributes.getValue("height"), -1.0));
                        this.m_currentRow.setFixedOffset((float)this.parseDouble(attributes.getValue("fixedoffset"), -1.0));
                    }
                } else if (name.equals("locale")) {
                    this.m_locale = attributes.getValue("value");
                } else if (name.equals("bidi")) {
                    if (!this.m_bidi) {
                        this.m_bidi = "1".equals(attributes.getValue("value"));
                    }
                } else if (name.equals("style") && this.getPass() == 1) {
                    String styleName = attributes.getValue("name");
                    Style style = this.createStyle(name, attributes, true);
                    style.setName(styleName);
                    this.m_styles.add(style);
                }
            }
            catch (BMLConverter.StopParsingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
    }

    private void fillCurrentRow(Attributes attributes) throws IOException {
        String currentRowId = attributes.getValue("layout");
        if (currentRowId != null) {
            this.m_currentRow = this.m_rowLayouts.get(currentRowId);
            if (this.m_currentRow != null) {
                this.m_bgItems = attributes.getValue("bgitems");
                this.m_currentRow.createTempStyles();
            }
        } else {
            this.m_currentRow = null;
        }
    }

    public Style getStyle(String name) {
        for (Style style : this.m_styles) {
            if (!name.equals(style.getName())) continue;
            return style;
        }
        return Style.EMPTY_STYLE;
    }

    public boolean useDynamicCols() {
        return false;
    }

    private void checkFixedOffset(Attributes attributes) {
        this.m_rowFixedOffset = -1.0f;
        String rowFixedOffset = attributes.getValue("fixedoffset");
        if (rowFixedOffset != null && !rowFixedOffset.isEmpty()) {
            this.m_rowFixedOffset = (float)this.parseDouble(attributes.getValue("fixedoffset"), -1.0);
        }
    }

    private void addCells(int a_col, String a_text, String font, int align, int skip, Style style) {
        int borderType = -1;
        int col = a_col;
        String text = "";
        boolean minusAsLine = a_text.indexOf("---") != -1 || a_text.indexOf("===") != -1;
        Style originalStyle = style.copy();
        for (int i = 0; i < a_text.length(); ++i) {
            boolean stuffToDrawSeparatelyExceptForHorizontalLine;
            char c = a_text.charAt(i);
            int width = text.length();
            boolean bl = stuffToDrawSeparatelyExceptForHorizontalLine = c >= '\u2501' && c <= '\u256c';
            if (stuffToDrawSeparatelyExceptForHorizontalLine && width > 0) {
                this.addCell(col, text, -1, borderType, font, align, skip, style);
                style = originalStyle;
                col += width;
                text = "";
            }
            text = text + c;
            if (c == '\u2500' || minusAsLine && (c == '-' || c == '=')) {
                if (width > 0 && borderType != 1 && borderType != 12) {
                    text = text.substring(0, text.length() - 1);
                    this.addCell(col, text, -1, borderType, font, align, skip, style);
                    style = originalStyle;
                    col += text.length();
                    text = "" + c;
                }
                if (c == '=') {
                    if (style.getForegroundColor() == null) {
                        style = style.copy();
                        style.setForegroundColor("0x000000");
                    }
                    borderType = 12;
                } else if (c == '-') {
                    if (style.getForegroundColor() == null) {
                        style = style.copy();
                        style.setForegroundColor("0x000000");
                    }
                    borderType = 1;
                } else {
                    borderType = 1;
                }
            } else if (c == '\u2502') {
                borderType = 2;
            } else if (stuffToDrawSeparatelyExceptForHorizontalLine) {
                borderType = c == '\u2502' || c == '\u2503' || c == '\u2506' || c == '\u2507' || c == '\u250a' || c == '\u250b' ? 2 : (c <= '\u250b' ? 1 : (c <= '\u250f' ? 3 : (c <= '\u2513' ? 4 : (c <= '\u2517' ? 5 : (c <= '\u251b' ? 6 : (c <= '\u2523' ? 7 : (c <= '\u252b' ? 8 : (c <= '\u2533' ? 9 : (c <= '\u253b' ? 10 : 11)))))))));
            } else if ((borderType == 1 || borderType == 12) && text.length() > 1) {
                text = text.substring(0, text.length() - 1);
                this.addCell(col, text, -1, borderType, font, align, skip, style);
                style = originalStyle;
                col += text.length();
                text = "" + c;
                borderType = -1;
            }
            if (!stuffToDrawSeparatelyExceptForHorizontalLine) continue;
            this.addCell(col, text, -1, borderType, font, align, skip, style);
            style = originalStyle;
            ++col;
            text = "";
            borderType = -1;
        }
        if (text.length() > 0) {
            this.addCell(col, text, -1, borderType, font, align, skip, style);
        }
        style = originalStyle;
    }

    private CellLayout addCell(int a_col, String a_text, int a_width, int a_borderType, String font, int align, int skip, Style style) {
        CellLayout cell = null;
        if (a_borderType < 0) {
            int w = a_text.length();
            if (a_width < 0) {
                if (a_text.indexOf("%npages;") != -1) {
                    w -= 6;
                } else if (a_text.indexOf("%pageno;") != -1) {
                    w -= 6;
                }
            } else {
                w = a_width;
            }
            cell = new TextCellLayout(a_col, a_text, w, align);
            if (font != null && !font.isEmpty()) {
                ((TextCellLayout)cell).setFont(font);
            }
            cell.setStyle(style);
            if (skip > 0) {
                ((TextCellLayout)cell).setWait(skip);
                ((TextCellLayout)cell).setCurrentWait(skip);
            }
        } else {
            cell = new LinesCellLayout(a_col, a_text.length(), a_borderType);
            cell.setStyle(style);
        }
        this.m_currentRow.addCell(cell);
        return cell;
    }

    protected void writeReportEnd() throws IOException {
        this.write("\n</table>");
        if (this.m_showNavigation) {
            this.write("\n<script type=\"text/javascript\">");
            this.write("\n\t function lastPage() {");
            this.write("\n\t\t gotoPage(" + this.m_countPages + ");");
            this.write("\n}");
            this.write("\n\t function gotoPage(page) {");
            this.write("\n\t\t var elem = document.getElementById(page);");
            this.write("\n\t\t var top = elem.offsetTop - 8;");
            this.write("\n\t\t var cur = elem.offsetParent;");
            this.write("\n\t\t while (cur && (cur.nodeType == 1)) {");
            this.write("\n\t\t   top += cur.offsetTop;");
            this.write("\n\t\t   cur = cur.offsetParent;");
            this.write("\n\t\t }");
            this.write("\n\t\t window.scrollTo(0, top);");
            this.write("\n}");
            this.write("\n</script>");
        }
        this.write("\n</body>");
        this.write("\n</html>");
    }

    protected void writeEndOfLine() throws IOException {
        this.write("<td class='rc'>&nbsp;</td>");
        this.writeEndTag();
    }

    @Override
    public void endElement(String not_used_1, String not_used_2, String name) throws SAXException {
        try {
            super.endElement(not_used_1, not_used_2, name);
            if (name.equals("report")) {
                this.endStyle(name, true);
                this.m_pendingPagebreak = false;
                this.writeReportEnd();
            } else if (name.equals("e")) {
                if (this.m_currentRow != null && this.isCharactersStarted()) {
                    this.m_currentRow.addE(this.getCharacters());
                    this.stopCharacters();
                }
                this.endStyle(name, false);
            } else if (name.equals("barcode")) {
                if (this.m_inBody) {
                    if (this.m_currentRow != null && this.isCharactersStarted()) {
                        String barcodeValue = this.getCharacters();
                        if (this.m_currentRow.getCurrentBarCode().getValue() == null) {
                            this.m_currentRow.getCurrentBarCode().setValue(barcodeValue);
                        }
                        this.startCharacters();
                        this.addCharacters(this.m_currentCharactersBeforeBarcode);
                    }
                } else {
                    this.endStyle(name, true);
                    this.m_currentBarcodeCellLayout = null;
                }
            } else if (name.equals("option")) {
                if (this.m_currentOptionName != null && this.m_currentBarcodeCellLayout != null) {
                    this.m_currentBarcodeCellLayout.addOption(this.m_currentOptionName, this.getCharacters());
                    this.stopCharacters();
                }
            } else if (name.equals("row")) {
                this.writeRow();
                this.endStyle(name, false);
            } else if (name.equals("emptyline")) {
                if (this.useExactPosition()) {
                    this.writeRow();
                }
                this.endStyle(name, false);
            } else if (name.equals("body")) {
                this.endStyle(name, false);
            } else if (name.equals("head")) {
                this.endStyle(name, true);
            } else if (name.equals("lline")) {
                if (this.m_currentRow != null) {
                    this.m_currentRow.sort();
                }
                this.endStyle(name, true);
            } else if (name.equals("layout")) {
                this.endStyle(name, true);
                this.m_layoutFont = null;
            } else if (name.equals("special") || name.equals("field") || name.equals("text") || name.equals("bgitem")) {
                this.endStyle(name, true);
            } else if (name.equals("image") || name.equals("signature") || name.equals("svg")) {
                this.endStyle(name, true);
            }
        }
        catch (BMLConverter.StopParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    private void writeRow() throws IOException {
        if (this.m_currentRow != null) {
            ArrayList<TextCellLayout> waitingFields = new ArrayList<TextCellLayout>();
            for (TextCellLayout textCell : this.m_waitingFields) {
                waitingFields.add(textCell);
            }
            for (TextCellLayout textCell : waitingFields) {
                this.m_currentRow.addCell(textCell);
            }
            this.m_currentRow.writeHTML();
            for (TextCellLayout textCell : waitingFields) {
                this.m_currentRow.removeCell(textCell);
            }
            this.m_currentRow.clearEs();
            this.writeEndOfLine();
        }
    }

    private void fillNumberOfCharactersOnLinePerFont(String a_font, int a_number) {
        if (a_font != null) {
            if (this.m_numberOfCharactersOnLinePerFont.containsKey(a_font)) {
                Integer n = this.m_numberOfCharactersOnLinePerFont.get(a_font);
                if (n < a_number) {
                    this.m_numberOfCharactersOnLinePerFont.put(a_font, new Integer(a_number));
                }
            } else {
                this.m_numberOfCharactersOnLinePerFont.put(a_font, new Integer(a_number));
            }
        }
    }

    @Override
    public void convert(String a_bmlFile, String a_file) throws SAXException, IOException {
        File bml = this.getLocalFile(a_bmlFile);
        this.m_largeReport = bml.length() / 1024L > 500L;
        super.convert(a_bmlFile, a_file);
    }

    public static String convertBML(String a_bmlFile, String a_file, boolean a_showCompanyLogo, boolean a_showNavigation, String a_font, String a_monospacedFont, boolean a_bidi) {
        try {
            BML2HTML b2h = new BML2HTML();
            b2h.m_showCompanyLogo = a_showCompanyLogo;
            b2h.m_showNavigation = a_showNavigation;
            b2h.m_font = a_font;
            b2h.m_monospacedFont = a_monospacedFont;
            b2h.m_monospacedFont = a_monospacedFont.replaceAll("Monospaced", "Courier New");
            b2h.m_bidi = a_bidi;
            b2h.convert(a_bmlFile, a_file);
            return b2h.getReportId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String convertBML2HTML(String a_bmlFile, String a_file, boolean a_showCompanyLogo, boolean a_showNavigation, String a_font, String a_monospacedFont, boolean a_bidi) {
        return BML2HTML.convertBML(a_bmlFile, a_file, a_showCompanyLogo, a_showNavigation, a_font, a_monospacedFont, a_bidi);
    }

    public static String convertToHTML(String a_bmlFile, String a_file, boolean a_showCompanyLogo, boolean a_showNavigation, String a_font, String a_monospacedFont, boolean a_bidi) {
        try {
            final int[] numberOfPages = new int[]{0};
            XMLReader saxParser = IOUtils.createXMLReader();
            saxParser.setContentHandler(new DefaultHandler(){

                @Override
                public void endElement(String not_used_1, String not_used_2, String name) throws SAXException {
                    if (name.equals("pagebreak")) {
                        numberOfPages[0] = numberOfPages[0] + 1;
                    }
                }
            });
            saxParser.setFeature("http://xml.org/sax/features/namespaces", false);
            saxParser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            saxParser.parse(a_bmlFile);
            int maxPages = 100;
            if (numberOfPages[0] > maxPages) {
                return BML2PDF.convertToPDF(a_bmlFile, a_file, a_showCompanyLogo, a_showNavigation, a_font, a_monospacedFont, a_bidi);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BML2HTML.convertBML(a_bmlFile, a_file, a_showCompanyLogo, a_showNavigation, a_font, a_monospacedFont, a_bidi);
        return "HTML";
    }

    public boolean isMonospaced() {
        return this.m_monospace;
    }

    public int getNumberOfPages() {
        if (this.m_pageNo != null && this.m_pageNo.isUsed()) {
            return this.m_pageNo.getNumberOfPages();
        }
        return this.m_countPages;
    }

    public CellLayout getLastAddedCell() {
        return this.m_currentRow.getLastAddedCell();
    }

    public float getRowHeight() {
        return this.m_currentRow.getHeight();
    }

    public boolean isFirstTextOfCurrentLineRtl() {
        return this.m_currentRow.m_firstTextIsRtl;
    }

    public float getRowFixedOffset() {
        if (this.m_rowFixedOffset < 0.0f && this.m_currentRow != null) {
            return this.m_currentRow.getFixedOffset();
        }
        return this.m_rowFixedOffset;
    }

    public boolean useExactPosition() {
        return false;
    }

    public boolean isRtlText(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isLetter(c)) continue;
            return c >= '\u05d0' && c <= '\u06ff';
        }
        return false;
    }

    public class RowLayout {
        private int m_index = 0;
        private Vector<CellLayout> m_cellLayouts = new Vector();
        private String m_rowFont;
        private Boolean m_rowJustify;
        private float m_height = -1.0f;
        private float m_fixedOffset = -1.0f;
        private boolean m_firstTextIsRtl = false;

        public void setFont(String a_font) {
            this.m_rowFont = a_font;
        }

        public void setJustify(boolean a_justify) {
            this.m_rowJustify = a_justify;
        }

        public void addCell(CellLayout a_cell) {
            this.m_cellLayouts.addElement(a_cell);
        }

        public void removeCell(CellLayout a_cell) {
            this.m_cellLayouts.removeElement(a_cell);
        }

        public boolean hasCell(CellLayout a_cell) {
            return this.m_cellLayouts.contains(a_cell);
        }

        public CellLayout getLastAddedCell() {
            return this.m_cellLayouts.lastElement();
        }

        public void setHeight(float height) {
            this.m_height = height;
        }

        public float getHeight() {
            return this.m_height;
        }

        public void setFixedOffset(float fixedOffset) {
            this.m_fixedOffset = fixedOffset;
        }

        public float getFixedOffset() {
            return this.m_fixedOffset;
        }

        public void sort() {
            Collections.sort(this.m_cellLayouts);
            CellLayout prevCell = null;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cell = this.m_cellLayouts.elementAt(i);
                if (cell.canOverlap()) continue;
                if (prevCell != null) {
                    int currentCol = prevCell.getCol();
                    if (prevCell.getWidth() != 1) {
                        int w = cell.getCol() - currentCol;
                        if (prevCell instanceof TextCellLayout && cell instanceof TextCellLayout && cell.getWidth() > 2) {
                            --w;
                        }
                        if (prevCell.getWidth() < w) {
                            boolean callSetWidth = true;
                            if (prevCell instanceof TextCellLayout && ((TextCellLayout)prevCell).getAlign() != 0) {
                                callSetWidth = false;
                            }
                            if (!prevCell.isExpandable()) {
                                callSetWidth = false;
                            }
                            if (callSetWidth) {
                                prevCell.setWidth(w);
                            }
                        } else if (prevCell.getWidth() > w) {
                            prevCell.setWidth(w);
                        }
                    }
                }
                prevCell = cell;
            }
            if (this.m_cellLayouts.size() > 0) {
                CellLayout lastCell = this.m_cellLayouts.lastElement();
                int numberOfChars = lastCell.getCol() + lastCell.getWidth() - 1;
                if (!BML2HTML.this.useDynamicCols() && BML2HTML.this.m_layoutFont != null && BML2HTML.this.m_layoutFont.equals(BML2HTML.this.m_reportFont) && BML2HTML.this.m_pwidth > 0) {
                    numberOfChars = BML2HTML.this.m_pwidth;
                }
                BML2HTML.this.fillNumberOfCharactersOnLinePerFont(BML2HTML.this.m_layoutFont, numberOfChars);
            }
        }

        public int getNumberOfCharacters() {
            Integer n;
            if (this.m_rowFont != null && (n = (Integer)BML2HTML.this.m_numberOfCharactersOnLinePerFont.get(this.m_rowFont)) != null) {
                return n;
            }
            return BML2HTML.this.m_pwidth;
        }

        public String getRowFont() {
            if (this.m_rowFont == null) {
                return BML2HTML.this.m_reportFont;
            }
            return this.m_rowFont;
        }

        public boolean getRowJustify() {
            if (this.m_rowJustify != null) {
                return this.m_rowJustify;
            }
            if (BML2HTML.this.m_justify != null) {
                return BML2HTML.this.m_justify;
            }
            return true;
        }

        public void createTempStyles() {
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cell = this.m_cellLayouts.get(i);
                if (cell.hasE()) continue;
                this.createTempStyle(cell);
            }
        }

        private void createTempStyle(CellLayout cell) {
            LinesCellLayout linesCellLayout;
            cell.backup();
            Style currentStyle = cell.getStyle();
            Style bodyStyle = (Style)BML2HTML.this.m_currentBodyStyles.get(BML2HTML.this.m_currentBodyStyles.size() - 1);
            currentStyle.merge(bodyStyle, false);
            if (cell instanceof LinesCellLayout && BML2HTML.this.m_bgItems != null && BML2HTML.this.m_bgItems.length() > 0 && (linesCellLayout = (LinesCellLayout)cell).isBgItem()) {
                char c = BML2HTML.this.m_bgItems.charAt(0);
                BML2HTML.this.m_bgItems = BML2HTML.this.m_bgItems.substring(1);
                if (c == '0') {
                    Style emptyStyle = new Style();
                    emptyStyle.setExactPosData(currentStyle.getExactPosData());
                    cell.setStyle(emptyStyle);
                }
            }
        }

        public CellLayout addE(String a_e) {
            CellLayout cell = this.get(true);
            if (cell != null) {
                this.createTempStyle(cell);
                cell.setText(a_e);
            }
            return cell;
        }

        public void clearEs() {
            this.m_index = 0;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                CellLayout cell = this.m_cellLayouts.elementAt(i);
                cell.setText("");
                cell.setBarCode(null);
                cell.restore();
            }
        }

        public int getIndex() {
            return this.m_index;
        }

        private CellLayout get(boolean moveToNext) {
            while (this.m_index < this.m_cellLayouts.size()) {
                CellLayout cellLayout = this.m_cellLayouts.get(this.m_index);
                if (!cellLayout.hasE()) {
                    ++this.m_index;
                    continue;
                }
                if (moveToNext) {
                    ++this.m_index;
                }
                return cellLayout;
            }
            if (moveToNext) {
                ++this.m_index;
            }
            return null;
        }

        public void addBarCode(BarCode bc) {
            CellLayout cellLayout = this.get(false);
            if (cellLayout != null) {
                cellLayout.setBarCode(bc);
            }
        }

        public BarCode getCurrentBarCode() {
            CellLayout cellLayout = this.m_cellLayouts.get(this.m_index);
            return cellLayout.getBarCode();
        }

        public String getFont(CellLayout cell) {
            if (cell == null) {
                return BML2HTML.this.m_reportFont;
            }
            if (cell instanceof TextCellLayout && ((TextCellLayout)cell).getFont() != null) {
                return ((TextCellLayout)cell).getFont();
            }
            if (this.m_rowFont != null) {
                return this.m_rowFont;
            }
            return BML2HTML.this.m_reportFont;
        }

        public String replaceTabs(String s, int n) {
            if (s == null) {
                return null;
            }
            if (BML2HTML.this.useExactPosition()) {
                return s;
            }
            s = s.replaceAll("\n", "");
            int index = s.indexOf("\t");
            while (index != -1) {
                int nspaces = n - index % n;
                s = s.substring(0, index) + this.spaces(nspaces) + s.substring(index + 1);
                index = s.indexOf("\t");
            }
            return s;
        }

        public String spaces(int n) {
            String s = "                                         ";
            return s.substring(0, n);
        }

        public void writeHTML() throws IOException {
            int number = this.getNumberOfCharacters();
            BML2HTML.this.setNumberOfCharactersForTheCurrentLine(number, this.getRowFont(), this.getRowJustify());
            boolean foundFirstText = false;
            this.m_firstTextIsRtl = false;
            int currentCol = 1;
            for (int i = 0; i < this.m_cellLayouts.size(); ++i) {
                TextCellLayout textCell;
                LinesCellLayout linesCell;
                CellLayout cell = this.m_cellLayouts.elementAt(i);
                String text = cell.getText();
                if (text == null) {
                    text = "";
                }
                if (text.length() > 0 && !foundFirstText) {
                    foundFirstText = true;
                    this.m_firstTextIsRtl = BML2HTML.this.isRtlText(text);
                }
                if (cell instanceof LinesCellLayout && (linesCell = (LinesCellLayout)cell).getBorderType() == -1) {
                    BML2HTML.this.writeBorderCell(cell.getCol(), cell.getWidth(), -1, linesCell.getStyle());
                    continue;
                }
                if (currentCol < cell.getCol() && !BML2HTML.this.useExactPosition()) {
                    BML2HTML.this.writeTextCell("", currentCol, cell.getCol() - currentCol, 0, false, "", null);
                    currentCol = currentCol + cell.getCol() - currentCol;
                } else if (currentCol > cell.getCol()) {
                    currentCol = cell.getCol();
                }
                if (cell instanceof TextCellLayout) {
                    text = ((TextCellLayout)cell).formatAccordingToDifo(text);
                    if ((text = this.replaceTabs(text, BML2HTML.this.m_numberOfSpacesForTab)).indexOf("%npages;") != -1) {
                        text = text.replaceAll("%npages;", "" + BML2HTML.this.getNumberOfPages());
                    }
                    if (text.indexOf("%pageno;") != -1) {
                        PageNoTextCellLayout pageNoTextCellLayout;
                        String pageNo = "" + BML2HTML.this.m_pageNoPageBreak;
                        PageNoTextCellLayout pageNoTextCellLayout2 = pageNoTextCellLayout = BML2HTML.this.m_pageNoTextCellLayouts.size() > 0 ? (PageNoTextCellLayout)BML2HTML.this.m_pageNoTextCellLayouts.get(0) : null;
                        if (pageNoTextCellLayout != null && pageNoTextCellLayout.getText() != null) {
                            pageNo = pageNoTextCellLayout.getText();
                        }
                        text = text.replaceAll("%pageno;", pageNo);
                    }
                }
                if (cell instanceof LinesCellLayout) {
                    linesCell = (LinesCellLayout)cell;
                    int border = linesCell.getBorderType();
                    if (BML2HTML.this.isBidi()) {
                        if (border == 3) {
                            border = 4;
                        } else if (border == 4) {
                            border = 3;
                        } else if (border == 5) {
                            border = 6;
                        } else if (border == 6) {
                            border = 5;
                        } else if (border == 7) {
                            border = 8;
                        } else if (border == 8) {
                            border = 7;
                        }
                    }
                    BML2HTML.this.writeBorderCell(currentCol, cell.getWidth(), border, linesCell.getStyle());
                } else if (cell instanceof TextCellLayout) {
                    textCell = (TextCellLayout)cell;
                    BML2HTML.this.writeTextCell(text, currentCol, textCell.getWidth(), textCell.getAlign(), textCell.addAnotherCellForTheMinusSign(), this.getFont(cell), textCell.getStyle());
                    if (textCell.getBarCode() != null) {
                        this.writeBarcode(currentCol, textCell.getWidth(), textCell.getBarCode(), this.getFont(cell), cell.getStyle());
                    }
                } else if (cell instanceof ImageCellLayout) {
                    String filePath = text;
                    BML2HTML.this.writeImage(currentCol, cell.getWidth(), ((ImageCellLayout)cell).getHeight(), filePath, ((ImageCellLayout)cell).getHAlign(), ((ImageCellLayout)cell).getVAlign(), cell.getStyle(), ((ImageCellLayout)cell).getSignatureId(), ((ImageCellLayout)cell).isSvg(), false);
                } else if (cell instanceof BarcodeCellLayout) {
                    BarCode bc = new BarCode(-1, ((BarcodeCellLayout)cell).getWidth(), ((BarcodeCellLayout)cell).getHeight(), ((BarcodeCellLayout)cell).getOptions(), 1, true);
                    bc.setValue(text);
                    bc.setJ4LType(((BarcodeCellLayout)cell).getType());
                    BML2HTML.this.writeBarcode(currentCol, cell.getWidth(), bc, null, cell.getStyle());
                }
                if (cell instanceof TextCellLayout) {
                    textCell = (TextCellLayout)cell;
                    if (textCell.getCurrentWait() > 0) {
                        if (textCell.getCurrentWait() == textCell.getWait()) {
                            TextCellLayout copy = (TextCellLayout)textCell.copy();
                            copy.setCurrentWait(copy.getWait() - 1);
                            copy.setWait(-1);
                            BML2HTML.this.m_waitingFields.add(copy);
                        } else {
                            textCell.setCurrentWait(textCell.getCurrentWait() - 1);
                        }
                    } else if (textCell.getWait() == -1) {
                        BML2HTML.this.m_waitingFields.remove(textCell);
                    }
                }
                if (cell.getWidth() <= 0) continue;
                currentCol += cell.getWidth();
            }
        }

        public void writeBarcode(int col, int width, BarCode bc, String a_font, Style a_style) throws IOException {
            BML2HTML.this.writeBarcode(col + bc.m_position, width - bc.m_position, bc, a_font, a_style);
        }
    }

    public class BarCode {
        private int m_width;
        private int m_height;
        private int m_type;
        private String m_options;
        private int m_position;
        private String m_value;
        private boolean m_base64Encoded;
        private String m_j4lType;
        private boolean m_rotated = false;

        public BarCode(int type, int width, int height, String options, int position, boolean base64Encoded) {
            this.m_type = type;
            this.m_width = width;
            this.m_height = height;
            this.m_options = options;
            this.m_position = position;
            this.m_base64Encoded = base64Encoded;
        }

        public void setValue(String a_value) {
            if (this.m_base64Encoded) {
                try {
                    byte[] bytes = Base64.decode((String)a_value);
                    a_value = new String(bytes, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_value = a_value;
        }

        public String getJ4LType() {
            return this.m_j4lType;
        }

        public void setJ4LType(String type) {
            this.m_j4lType = type;
        }

        public String getOptions() {
            return this.m_options;
        }

        public int getPosition() {
            return this.m_position;
        }

        public int getWidth() {
            return this.m_width;
        }

        public int getHeight() {
            return this.m_height;
        }

        public String getValue() {
            return this.m_value;
        }

        public int getType() {
            return this.m_type;
        }

        public void setRotated(boolean rotated) {
            this.m_rotated = rotated;
        }

        public boolean isRotated() {
            return this.m_rotated;
        }
    }
}

