/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.RootElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.renderer.CanvasRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Canvas
extends RootElement<Canvas> {
    protected PdfCanvas pdfCanvas;
    protected Rectangle rootArea;
    protected PdfPage page;
    private boolean isCanvasOfPage;

    public Canvas(PdfPage page, Rectangle rootArea) {
        this(Canvas.initPdfCanvasOrThrowIfPageIsFlushed(page), rootArea);
        this.enableAutoTagging(page);
        this.isCanvasOfPage = true;
    }

    public Canvas(PdfCanvas pdfCanvas, Rectangle rootArea) {
        this.pdfDocument = pdfCanvas.getDocument();
        this.pdfCanvas = pdfCanvas;
        this.rootArea = rootArea;
    }

    public Canvas(PdfCanvas pdfCanvas, Rectangle rootArea, boolean immediateFlush) {
        this(pdfCanvas, rootArea);
        this.immediateFlush = immediateFlush;
    }

    public Canvas(PdfFormXObject formXObject, PdfDocument pdfDocument) {
        this(new PdfCanvas(formXObject, pdfDocument), formXObject.getBBox().toRectangle());
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public Rectangle getRootArea() {
        return this.rootArea;
    }

    public PdfCanvas getPdfCanvas() {
        return this.pdfCanvas;
    }

    public void setRenderer(CanvasRenderer canvasRenderer) {
        this.rootRenderer = canvasRenderer;
    }

    public PdfPage getPage() {
        return this.page;
    }

    public void enableAutoTagging(PdfPage page) {
        if (this.isCanvasOfPage() && this.page != page) {
            Logger logger = LoggerFactory.getLogger(Canvas.class);
            logger.error("The page passed to Canvas#enableAutoTagging(PdfPage) method shall be the one on which this canvas will be rendered. However the actual passed PdfPage instance sets not such page. This might lead to creation of malformed PDF document.");
        }
        this.page = page;
    }

    public boolean isAutoTaggingEnabled() {
        return this.page != null;
    }

    public boolean isCanvasOfPage() {
        return this.isCanvasOfPage;
    }

    public void relayout() {
        IRenderer nextRelayoutRenderer;
        if (this.immediateFlush) {
            throw new IllegalStateException("Operation not supported with immediate flush");
        }
        IRenderer iRenderer = nextRelayoutRenderer = this.rootRenderer != null ? this.rootRenderer.getNextRenderer() : null;
        if (nextRelayoutRenderer == null || !(nextRelayoutRenderer instanceof RootRenderer)) {
            nextRelayoutRenderer = new CanvasRenderer(this, this.immediateFlush);
        }
        this.rootRenderer = (RootRenderer)nextRelayoutRenderer;
        for (IElement element : this.childElements) {
            this.createAndAddRendererSubTree(element);
        }
    }

    public void flush() {
        this.rootRenderer.flush();
    }

    @Override
    public void close() {
        if (this.rootRenderer != null) {
            this.rootRenderer.close();
        }
    }

    @Override
    protected RootRenderer ensureRootRendererNotNull() {
        if (this.rootRenderer == null) {
            this.rootRenderer = new CanvasRenderer(this, this.immediateFlush);
        }
        return this.rootRenderer;
    }

    private static PdfCanvas initPdfCanvasOrThrowIfPageIsFlushed(PdfPage page) {
        if (page.isFlushed()) {
            throw new PdfException("Cannot draw elements on already flushed pages.");
        }
        return new PdfCanvas(page);
    }
}

