/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.ReportingType;
import com.itextpdf.licensing.base.util.JsonUtil;
import com.itextpdf.licensing.base.util.LicenseKeyIoUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class LicenseFileUtil {
    private static final long MILLISECONDS_IN_MINUTE = 60000L;
    private static final long MILLISECONDS_IN_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_DAY = 86400000L;

    private LicenseFileUtil() {
    }

    public static long parseGracePeriodStrToMilliseconds(String gracePeriod) {
        try {
            String daysStr = gracePeriod.substring(0, gracePeriod.indexOf(100));
            String hoursStr = gracePeriod.substring(gracePeriod.indexOf(100) + 1, gracePeriod.indexOf(104));
            String minutesStr = gracePeriod.substring(gracePeriod.indexOf(104) + 1, gracePeriod.indexOf(109));
            int days = Integer.parseInt(daysStr);
            int hours = Integer.parseInt(hoursStr);
            int minutes = Integer.parseInt(minutesStr);
            return (long)days * 86400000L + (long)hours * 3600000L + (long)minutes * 60000L;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormatUtil.format((String)"Unable to parse grace period \"{0}\".", (Object[])new Object[]{gracePeriod}));
        }
    }

    public static ReportingType parseStringToReportingType(String toParse) {
        if ("local".equals(toParse)) {
            return ReportingType.local;
        }
        if ("remote".equals(toParse)) {
            return ReportingType.remote;
        }
        throw new IllegalArgumentException("Invalid reporting type.");
    }

    public static List<LicenseFile> parseStringToLicenseFiles(String licenseFileStr) {
        if (LicenseKeyIoUtil.isJsonArray(licenseFileStr)) {
            LicenseFile[] licenseFiles = JsonUtil.deserializeFromString(licenseFileStr, LicenseFile[].class);
            return licenseFiles == null ? null : Arrays.asList(licenseFiles);
        }
        LicenseFile licenseFile = JsonUtil.deserializeFromString(licenseFileStr, LicenseFile.class);
        return licenseFile == null ? null : Arrays.asList(licenseFile);
    }

    public static int compareLicensesByCreationDate(LicenseFile file1, LicenseFile file2) {
        try {
            Date creationDate1 = DateTimeUtil.parseWithDefaultPattern((String)file1.getCreationDate());
            Date creationDate2 = DateTimeUtil.parseWithDefaultPattern((String)file2.getCreationDate());
            return creationDate1.compareTo(creationDate2);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

