/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.strategy;

import com.itextpdf.commons.actions.ProductNameConstant;
import com.itextpdf.licensing.base.LicenseKey;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.strategy.IStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AgplStrategy
implements IStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgplStrategy.class);
    private final String exceptionMessage;
    private final String switchedMessage;
    private final String productName;
    private volatile boolean isSuccessState = true;

    public AgplStrategy(String exceptionMessage, String switchedMessage, String productName) {
        this.exceptionMessage = exceptionMessage;
        this.switchedMessage = switchedMessage;
        this.productName = productName;
    }

    @Override
    public void onFailure() {
        this.isSuccessState = false;
    }

    @Override
    public void onSuccess() {
        this.isSuccessState = true;
    }

    @Override
    public void onProcessing() {
        if (this.isSuccessState) {
            return;
        }
        if (!ProductNameConstant.PRODUCT_NAMES.contains(this.productName)) {
            throw new LicenseKeyException(this.exceptionMessage);
        }
        LOGGER.warn(this.switchedMessage);
        LicenseKey.unloadLicenseForProduct(this.productName);
    }
}

