/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.itextpdf.commons.utils.MapUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ProductUsage {
    @JsonProperty(value="licenseKey")
    private final String licenseKey;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="events")
    private final Map<String, Long> events;
    @JsonProperty(value="eventTime")
    private final String eventTime;

    public ProductUsage(@JsonProperty(value="licenseKey") String licenseKey, @JsonProperty(value="productName") String productName, @JsonProperty(value="events") Map<String, Long> events, @JsonProperty(value="eventTime") String eventTime) {
        if (licenseKey == null) {
            throw new IllegalArgumentException("License file key can not be null.");
        }
        this.licenseKey = licenseKey;
        if (productName == null) {
            throw new IllegalArgumentException("Product name can not be null.");
        }
        this.productName = productName;
        if (events == null) {
            throw new IllegalArgumentException("Events can not be null.");
        }
        this.events = new LinkedHashMap<String, Long>(events);
        if (eventTime == null) {
            throw new IllegalArgumentException("Event time can not be null.");
        }
        this.eventTime = eventTime;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getProductName() {
        return this.productName;
    }

    public Map<String, Long> getEvents() {
        return Collections.unmodifiableMap(this.events);
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductUsage usage = (ProductUsage)o;
        return Objects.equals(this.licenseKey, usage.licenseKey) && Objects.equals(this.productName, usage.productName) && MapUtil.equals(this.events, usage.events) && Objects.equals(this.eventTime, usage.eventTime);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.licenseKey, this.productName, this.eventTime);
        return hashCode * 31 + (this.events == null ? 0 : MapUtil.getHashCode(this.events));
    }
}

