/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.resultprocessor;

import com.itextpdf.licensing.base.licensefile.Limit;
import com.itextpdf.licensing.base.reporting.resultprocessor.IVolumeResultProcessor;
import com.itextpdf.licensing.base.strategy.IStrategy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractEventTypeMapperProcessor<T extends IStrategy>
implements IVolumeResultProcessor {
    private final Object syncLock = new Object();
    private final Map<String, Map<String, T>> strategiesMap = new ConcurrentHashMap<String, Map<String, T>>();
    private final Map<String, Limit> defaultLimits = new ConcurrentHashMap<String, Limit>();

    public void putStrategy(String productName, String eventType, T strategy) {
        this.getStrategiesMap(productName).put(eventType, strategy);
    }

    public void putDefaultLimit(String productName, Limit defaultLimit) {
        this.defaultLimits.put(productName, defaultLimit);
    }

    public void putAllStrategiesWithDefaultLimit(String productName, Limit defaultLimit, Map<String, T> processors) {
        this.removeStrategies(productName);
        if (defaultLimit != null) {
            this.putDefaultLimit(productName, defaultLimit);
        }
        this.getStrategiesMap(productName).putAll(processors);
    }

    public void removeStrategies(String productName) {
        this.defaultLimits.remove(productName);
        this.getStrategiesMap(productName).clear();
    }

    public boolean isEmpty() {
        if (!this.defaultLimits.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Map<String, T>> entry : this.strategiesMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isProcessable(String productName, String eventType) {
        return this.getStrategy(productName, eventType) != null;
    }

    @Override
    public void onSuccess(String productName, String eventType) {
        T processor = this.getStrategy(productName, eventType);
        if (processor != null) {
            processor.onSuccess();
        }
    }

    @Override
    public void onFailure(String productName, String eventType) {
        T processor = this.getStrategy(productName, eventType);
        if (processor != null) {
            processor.onFailure();
        }
    }

    @Override
    public void onEventProcessing(String productName, String eventType) {
        T strategy = this.getStrategy(productName, eventType);
        if (strategy != null) {
            strategy.onProcessing();
        }
    }

    protected T getStrategy(String productName, String eventType) {
        IStrategy resultProcessor = (IStrategy)this.getStrategiesMap(productName).get(eventType);
        if (resultProcessor == null && this.defaultLimits.containsKey(productName) && (resultProcessor = this.createStrategyFromDefault(this.defaultLimits.get(productName), productName, eventType)) != null) {
            this.putStrategy(productName, eventType, resultProcessor);
        }
        return (T)resultProcessor;
    }

    protected abstract T createStrategyFromDefault(Limit var1, String var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, T> getStrategiesMap(String productName) {
        Object object = this.syncLock;
        synchronized (object) {
            Map<String, T> productMap = this.strategiesMap.get(productName);
            if (productMap == null) {
                productMap = new ConcurrentHashMap<String, T>();
                this.strategiesMap.put(productName, productMap);
            }
            return productMap;
        }
    }
}

