/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.ReportingType;
import com.itextpdf.licensing.base.reporting.AwsLicenseServer;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.ILicenseServerFactory;
import com.itextpdf.licensing.base.reporting.LicenseKeyReportingConfigurer;
import com.itextpdf.licensing.base.reporting.LocalFileLicenseServer;
import org.slf4j.LoggerFactory;

final class LicenseServerFactory
implements ILicenseServerFactory {
    private static final LicenseServerFactory INSTANCE = new LicenseServerFactory();

    private LicenseServerFactory() {
    }

    static LicenseServerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public ILicenseServer obtainConfiguredLicenseServer() {
        ILicenseServer result;
        ReportingType reportingType = LicenseKeyReportingConfigurer.getReportingType();
        switch (reportingType) {
            case remote: {
                result = LicenseServerFactory.tryToGetAwsLicenseServer();
                LoggerFactory.getLogger(LicenseServerFactory.class).info("AWS license server was created.");
                break;
            }
            case local: {
                result = LocalFileLicenseServer.getInstance();
                LoggerFactory.getLogger(LicenseServerFactory.class).info("Local file license server was created.");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid reporting type.");
            }
        }
        return result;
    }

    private static ILicenseServer tryToGetAwsLicenseServer() {
        try {
            return AwsLicenseServer.getInstance();
        }
        catch (NoClassDefFoundError error) {
            throw new LicenseKeyException("The 'licensing-remote' module which is required for sending events to AWS server may be missing or outdated. Please ensure that you have added the appropriate version of this module and that all its transitive dependencies are also available. If you continue to get this exception, please contact our support at 'https://itextpdf.com/support'.", error);
        }
    }
}

