/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.LicenseKeyProductData;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.EventReporting;
import com.itextpdf.licensing.base.licensefile.ReportingType;
import com.itextpdf.licensing.base.reporting.ReportingHandlerKeeper;
import com.itextpdf.licensing.base.statistics.LicensingUsageStatisticsEvent;
import com.itextpdf.licensing.base.statistics.ProductVersionStatisticsEvent;
import com.itextpdf.licensing.base.util.LicenseFileUtil;
import com.itextpdf.licensing.base.util.PortingUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class LicenseKeyReportingConfigurer {
    public static final String REMOTE_REPORTING_TYPE = "remote";
    public static final String LOCAL_REPORTING_TYPE = "local";
    private static final String REPORTING_TYPE_ENVIRONMENT_VARIABLE_NAME = "ITEXT_LICENSE_VOLUME_REPORTING_TYPE";
    private static final String REPORTING_TYPE_PROPERTY_NAME = "itext.license.volume.reporting.type";
    private static final String LOCAL_FILE_DIR_PATH_ENVIRONMENT_VARIABLE_NAME = "ITEXT_LICENSE_VOLUME_REPORTING_DIRECTORY";
    private static final String LOCAL_FILE_DIR_PATH_PROPERTY_NAME = "itext.license.volume.reporting.directory";
    private static final Set<String> ALL_REPORTING_TYPES_SET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("remote", "local")));
    private static final String DEFAULT_REPORTING_TYPE = "remote";
    private static final Object SYNC_LOCK = new Object();
    private static String reportingType = null;
    private static String localFileDir;
    private static final Set<String> allowedReportingTypes;
    private static final Map<String, Boolean> statisticsEnabledForProduct;

    private LicenseKeyReportingConfigurer() {
    }

    public static void useRemoteReporting() {
        LicenseKeyReportingConfigurer.tryUpdateReporting("remote", null);
    }

    public static void useLocalReporting(String directoryToWritePath) {
        if (directoryToWritePath != null) {
            try {
                LicenseKeyReportingConfigurer.checkLocalFileReportingDirectory(directoryToWritePath);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        LicenseKeyReportingConfigurer.tryUpdateReporting(LOCAL_REPORTING_TYPE, directoryToWritePath);
    }

    public static void resetApiConfiguration() {
        LicenseKeyReportingConfigurer.tryUpdateReporting(null, null);
    }

    public static ReportingType getReportingType() {
        String chosenType;
        if (reportingType != null) {
            chosenType = reportingType;
        } else {
            chosenType = SystemUtil.getPropertyOrEnvironmentVariable((String)REPORTING_TYPE_PROPERTY_NAME);
            if (chosenType == null || LicenseKeyReportingConfigurer.isIncorrectReportingTypeStr(chosenType)) {
                chosenType = SystemUtil.getPropertyOrEnvironmentVariable((String)REPORTING_TYPE_ENVIRONMENT_VARIABLE_NAME);
            }
            if (chosenType == null || LicenseKeyReportingConfigurer.isIncorrectReportingTypeStr(chosenType)) {
                if (allowedReportingTypes.isEmpty()) {
                    throw new LicenseKeyException("Available reporting types collection is empty.");
                }
                String string = chosenType = allowedReportingTypes.contains("remote") ? "remote" : (String)allowedReportingTypes.toArray()[0];
            }
        }
        if (!allowedReportingTypes.contains(chosenType)) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Your current license does not allow reporting type {0}.", (Object[])new Object[]{chosenType}));
        }
        return LicenseFileUtil.parseStringToReportingType(chosenType);
    }

    public static String getLocalFileRootDir() {
        String resultPath = localFileDir;
        if (resultPath == null) {
            resultPath = SystemUtil.getPropertyOrEnvironmentVariable((String)LOCAL_FILE_DIR_PATH_PROPERTY_NAME);
        }
        if (resultPath == null) {
            resultPath = SystemUtil.getPropertyOrEnvironmentVariable((String)LOCAL_FILE_DIR_PATH_ENVIRONMENT_VARIABLE_NAME);
        }
        LicenseKeyReportingConfigurer.checkLocalFileReportingDirectory(resultPath);
        return resultPath;
    }

    public static boolean isStatisticsEnabledForProduct(String productName) {
        if (LicenseKeyProductData.getInstance().getProductName().equals(productName)) {
            throw new LicenseKeyException("Statistics cannot be enabled or disabled for licensekey module itself. Licensekey statistics is considered enabled if statistics is enabled for at least one module for which license file is loaded. Otherwise it is considered disabled.");
        }
        return Boolean.TRUE.equals(statisticsEnabledForProduct.get(productName));
    }

    public static void overrideStatisticsSendingForProduct(String productName, boolean sendStatistics) {
        if (LicenseKeyProductData.getInstance().getProductName().equals(productName)) {
            throw new LicenseKeyException("Statistics cannot be enabled or disabled for licensekey module itself. Licensekey statistics is considered enabled if statistics is enabled for at least one module for which license file is loaded. Otherwise it is considered disabled.");
        }
        statisticsEnabledForProduct.put(productName, sendStatistics);
        if (sendStatistics) {
            EventManager.getInstance().onEvent((IEvent)new LicensingUsageStatisticsEvent(LicenseKeyProductData.getInstance()));
            EventManager.getInstance().onEvent((IEvent)new ProductVersionStatisticsEvent(LicenseKeyProductData.getInstance()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateLicenseData(EventReporting eventReporting) {
        Object object = SYNC_LOCK;
        synchronized (object) {
            allowedReportingTypes.clear();
            if (eventReporting != null && eventReporting.getReportingType() != null) {
                for (ReportingType reportingType : eventReporting.getReportingType()) {
                    allowedReportingTypes.add(reportingType.toString());
                }
            } else {
                allowedReportingTypes.addAll(ALL_REPORTING_TYPES_SET);
            }
        }
    }

    private static boolean isIncorrectReportingTypeStr(String reportingType) {
        return !ALL_REPORTING_TYPES_SET.contains(reportingType);
    }

    private static void checkLocalFileReportingDirectory(String path) {
        if (path == null) {
            throw new LicenseKeyException("Using local file reporting without specified reports root directory is forbidden.");
        }
        FileUtil.createDirectories((String)path);
        if (!FileUtil.directoryExists((String)path) || !PortingUtils.canReadAndWriteInDirectory(path)) {
            throw new LicenseKeyException("Specified local file reporting root directory is invalid.");
        }
    }

    private static void tryUpdateReporting(String reportingTypeToSet, String localFileDirToSet) {
        String oldReportingType = reportingType;
        String oldLocalFileDir = localFileDir;
        reportingType = reportingTypeToSet;
        localFileDir = localFileDirToSet;
        try {
            ReportingHandlerKeeper.getReportingHandler().updateReportingConfig();
            EventManager.getInstance().onEvent((IEvent)new LicensingUsageStatisticsEvent(LicenseKeyProductData.getInstance()));
            EventManager.getInstance().onEvent((IEvent)new ProductVersionStatisticsEvent(LicenseKeyProductData.getInstance()));
        }
        catch (Exception e) {
            localFileDir = oldLocalFileDir;
            reportingType = oldReportingType;
            throw e;
        }
    }

    static {
        allowedReportingTypes = new HashSet<String>(ALL_REPORTING_TYPES_SET);
        statisticsEnabledForProduct = new ConcurrentHashMap<String, Boolean>();
    }
}

