/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.util;

import com.itextpdf.io.util.ResourceUtil;
import com.itextpdf.io.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypographyShippedFontsUtil {
    static final String FONTS_DIR = "com/itextpdf/typography/font/";
    static final String[] CALLIGRAPHIC_FONT_NAMES = new String[]{"NotoSansArabic", "NotoSansGurmukhi", "NotoSansMyanmar", "NotoSansOriya", "NotoSerifBengali", "NotoSerifDevanagari", "NotoSerifGujarati", "NotoSerifHebrew", "NotoSerifKannada", "NotoSerifKhmer", "NotoSerifMalayalam", "NotoSerifMyanmar", "NotoSerifTamil", "NotoSerifTelugu", "NotoSerifThai"};

    public static Map<String, byte[]> loadShippedFonts() throws IOException {
        LinkedHashMap<String, byte[]> fontStreams = new LinkedHashMap<String, byte[]>(CALLIGRAPHIC_FONT_NAMES.length * 2);
        for (String fontName : CALLIGRAPHIC_FONT_NAMES) {
            fontStreams.put(fontName + "-Regular", TypographyShippedFontsUtil.process(FONTS_DIR + fontName + "-Regular.ttf"));
            fontStreams.put(fontName + "-Bold", TypographyShippedFontsUtil.process(FONTS_DIR + fontName + "-Bold.ttf"));
        }
        return fontStreams;
    }

    private static byte[] process(String fullFontName) throws IOException {
        try (InputStream resourceStream = ResourceUtil.getResourceStream((String)fullFontName);){
            byte[] byArray = StreamUtil.inputStreamToArray((InputStream)resourceStream);
            return byArray;
        }
    }
}

