/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.shaping;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.actions.sequence.SequenceId;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.TypographyUtils;
import com.itextpdf.layout.renderer.typography.AbstractTypographyApplier;
import com.itextpdf.typography.WordWrapper;
import com.itextpdf.typography.bidi.BidiAlgorithm;
import com.itextpdf.typography.bidi.BidiBracketMap;
import com.itextpdf.typography.bidi.BidiCharacterMap;
import com.itextpdf.typography.config.TypographyConfigurator;
import com.itextpdf.typography.shaping.Shaper;
import com.itextpdf.typography.util.TypographyShippedFontsUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class TypographyApplier
extends AbstractTypographyApplier {
    private TypographyApplier() {
    }

    public static void registerForLayout() {
        TypographyUtils.setTypographyApplierInstance((AbstractTypographyApplier)new TypographyApplier());
    }

    public boolean isPdfCalligraphInstance() {
        return true;
    }

    public boolean applyOtfScript(TrueTypeFont font, GlyphLine glyphLine, Character.UnicodeScript script, Object configurator, SequenceId id, IMetaInfo metaInfo) {
        if (!(configurator instanceof TypographyConfigurator)) {
            configurator = new TypographyConfigurator();
        }
        return Shaper.applyOtfScript(font, glyphLine, script, (TypographyConfigurator)configurator, id, metaInfo);
    }

    public Collection<Character.UnicodeScript> getSupportedScripts() {
        return Shaper.getSupportedScripts();
    }

    public Collection<Character.UnicodeScript> getSupportedScripts(Object configurator) {
        if (configurator instanceof TypographyConfigurator) {
            return Shaper.getSupportedScripts((TypographyConfigurator)configurator);
        }
        return this.getSupportedScripts();
    }

    public boolean applyKerning(FontProgram fontProgram, GlyphLine text, SequenceId sequenceId, IMetaInfo metaInfo) {
        return Shaper.applyKerning(fontProgram, text, sequenceId, metaInfo);
    }

    public byte[] getBidiLevels(BaseDirection baseDirection, int[] unicodeIds, SequenceId sequenceId, IMetaInfo metaInfo) {
        byte direction;
        switch (baseDirection) {
            case LEFT_TO_RIGHT: {
                direction = 0;
                break;
            }
            case RIGHT_TO_LEFT: {
                direction = 1;
                break;
            }
            default: {
                direction = 2;
            }
        }
        int len = unicodeIds.length;
        byte[] types = BidiCharacterMap.getCharacterTypes(unicodeIds, 0, len, sequenceId, metaInfo);
        byte[] pairTypes = BidiBracketMap.getBracketTypes(unicodeIds, 0, len, sequenceId, metaInfo);
        int[] pairValues = BidiBracketMap.getBracketValues(unicodeIds, 0, len, sequenceId, metaInfo);
        BidiAlgorithm bidiReorder = new BidiAlgorithm(types, pairTypes, pairValues, direction, sequenceId, metaInfo);
        return bidiReorder.getLevels(new int[]{len});
    }

    public int[] reorderLine(List<LineRenderer.RendererGlyph> line, byte[] lineLevels, byte[] levels) {
        if (levels == null) {
            return null;
        }
        int[] reorder = BidiAlgorithm.computeReordering(lineLevels);
        int[] inverseReorder = BidiAlgorithm.inverseReordering(reorder);
        ArrayList<LineRenderer.RendererGlyph> reorderedLine = new ArrayList<LineRenderer.RendererGlyph>(lineLevels.length);
        for (int i = 0; i < line.size(); ++i) {
            reorderedLine.add(line.get(reorder[i]));
            if (levels[reorder[i]] % 2 != 1 || !((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.hasValidUnicode()) continue;
            int unicode = ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.getUnicode();
            int pairedBracket = BidiBracketMap.getPairedBracket(((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).glyph.getUnicode());
            if (pairedBracket == unicode) continue;
            PdfFont font = ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).renderer.getPropertyAsFont(20);
            reorderedLine.set(i, new LineRenderer.RendererGlyph(font.getGlyph(pairedBracket), ((LineRenderer.RendererGlyph)reorderedLine.get((int)i)).renderer));
        }
        TypographyApplier.updateAnchorDeltaForReorderedLineGlyphs(reorder, inverseReorder, reorderedLine);
        line.clear();
        line.addAll(reorderedLine);
        return reorder;
    }

    public List<Integer> getPossibleBreaks(String str) {
        return WordWrapper.getPossibleBreaks(str);
    }

    public Map<String, byte[]> loadShippedFonts() throws IOException {
        return TypographyShippedFontsUtil.loadShippedFonts();
    }

    static void updateAnchorDeltaForReorderedLineGlyphs(int[] reorder, int[] inverseReorder, List<LineRenderer.RendererGlyph> reorderedLine) {
        for (int i = 0; i < reorderedLine.size(); ++i) {
            Glyph glyph = reorderedLine.get((int)i).glyph;
            if (!glyph.hasPlacement()) continue;
            int oldAnchor = reorder[i] + glyph.getAnchorDelta();
            int newPos = inverseReorder[oldAnchor];
            int newAnchorDelta = newPos - i;
            if (glyph.getAnchorDelta() == newAnchorDelta) continue;
            reorderedLine.get((int)i).glyph = glyph = new Glyph(glyph);
            glyph.setAnchorDelta((short)newAnchorDelta);
        }
    }
}

