/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.myanmar;

import com.itextpdf.typography.ordering.indic.IndicTable;
import com.itextpdf.typography.ordering.myanmar.MyanmarCluster;
import com.itextpdf.typography.ordering.myanmar.MyanmarUtil;

public abstract class MyanmarShaper {
    private MyanmarShaper() {
    }

    public static void initialReorderingConsonantSyllable(MyanmarCluster cluster) {
        int i;
        int end;
        int start = 0;
        int base = end = cluster.size();
        boolean hasReph = false;
        int limit = start;
        if (start + 3 <= end && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)start)).category == 16 && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)(start + 1))).category == 18 && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)(start + 2))).category == 4) {
            limit += 3;
            base = start;
            hasReph = true;
        }
        if (!hasReph) {
            base = limit;
        }
        for (int i2 = limit; i2 < end; ++i2) {
            if (!MyanmarUtil.isConsonant(cluster.get(i2), ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i2)).category)) continue;
            base = i2;
            break;
        }
        for (i = start; i < start + (hasReph ? 3 : 0); ++i) {
            ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).position = 5;
        }
        while (i < base) {
            ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).position = 3;
            ++i;
        }
        if (i < end) {
            ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).position = 4;
            ++i;
        }
        int pos = 5;
        while (i < end) {
            if (((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).category == 22) {
                ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).position = 3;
            } else if (((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).position >= 4) {
                ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).position = pos == 5 && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).category == 27 ? (pos = 8) : (pos == 8 && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).category == 10 ? 7 : (pos == 8 && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).category == 27 ? pos : (pos == 8 && ((MyanmarCluster.MyanmarGlyph)cluster.get((int)i)).category != 10 ? (pos = 9) : pos)));
            }
            ++i;
        }
        cluster.sortByPosition();
    }

    public static void setMyanmarProperties(MyanmarCluster.MyanmarGlyph glyph) {
        if (!glyph.hasValidUnicode()) {
            return;
        }
        int u = glyph.getUnicode();
        int type = IndicTable.getCategories(u);
        int cat = type & 0x7F;
        int pos = type >> 8;
        if (MyanmarUtil.inRange(u, 65024, 65039)) {
            cat = 30;
        }
        switch (u) {
            case 4174: {
                cat = 1;
                break;
            }
            case 45: 
            case 160: 
            case 215: 
            case 8210: 
            case 8211: 
            case 8212: 
            case 8213: 
            case 8226: 
            case 9676: 
            case 9723: 
            case 9724: 
            case 9725: 
            case 9726: {
                cat = 11;
                break;
            }
            case 4100: 
            case 4123: 
            case 4186: {
                cat = 16;
                break;
            }
            case 4146: 
            case 4150: {
                cat = 10;
                break;
            }
            case 4154: {
                cat = 18;
                break;
            }
            case 4161: 
            case 4162: 
            case 4163: 
            case 4164: 
            case 4165: 
            case 4166: 
            case 4167: 
            case 4168: 
            case 4169: 
            case 4240: 
            case 4241: 
            case 4242: 
            case 4243: 
            case 4244: 
            case 4245: 
            case 4246: 
            case 4247: 
            case 4248: 
            case 4249: {
                cat = 19;
                break;
            }
            case 4160: {
                cat = 19;
                break;
            }
            case 4158: 
            case 4192: {
                cat = 21;
                break;
            }
            case 4156: {
                cat = 22;
                break;
            }
            case 4157: 
            case 4226: {
                cat = 23;
                break;
            }
            case 4155: 
            case 4190: 
            case 4191: {
                cat = 24;
                break;
            }
            case 4195: 
            case 4196: 
            case 4201: 
            case 4202: 
            case 4203: 
            case 4204: 
            case 4205: 
            case 43643: {
                cat = 25;
                break;
            }
            case 4152: 
            case 4231: 
            case 4232: 
            case 4233: 
            case 4234: 
            case 4235: 
            case 4236: 
            case 4237: 
            case 4239: 
            case 4250: 
            case 4251: 
            case 4252: {
                cat = 8;
                break;
            }
            case 4170: 
            case 4171: {
                cat = 31;
            }
        }
        if (cat == 7) {
            switch (pos) {
                case 3: {
                    cat = 28;
                    pos = 2;
                    break;
                }
                case 6: {
                    cat = 26;
                    break;
                }
                case 8: {
                    cat = 27;
                    break;
                }
                case 11: {
                    cat = 29;
                }
            }
        }
        glyph.category = cat;
        glyph.position = pos;
    }
}

