/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.myanmar;

import java.util.LinkedHashMap;
import java.util.Map;

public final class MyanmarCategory {
    public static final char OT_X = '\u0000';
    public static final char OT_A = '\n';
    public static final char OT_As = '\u0012';
    public static final char OT_C = '\u0001';
    public static final char OT_D = '\u0013';
    public static final char OT_D0 = '\u0014';
    public static final char OT_DB = '\u0003';
    public static final char OT_GB = '\u000b';
    public static final char OT_H = '\u0004';
    public static final char OT_IV = '\u0002';
    public static final char OT_MH = '\u0015';
    public static final char OT_MR = '\u0016';
    public static final char OT_MW = '\u0017';
    public static final char OT_MY = '\u0018';
    public static final char OT_PT = '\u0019';
    public static final char OT_V = '\b';
    public static final char OT_VAbv = '\u001a';
    public static final char OT_VBlw = '\u001b';
    public static final char OT_VPre = '\u001c';
    public static final char OT_VPst = '\u001d';
    public static final char OT_VS = '\u001e';
    public static final char OT_ZWJ = '\u0006';
    public static final char OT_ZWNJ = '\u0005';
    public static final char OT_Ra = '\u0010';
    public static final char OT_P = '\u001f';
    public static final char OT_M = '\u0007';
    public static final char OT_SM = '\b';
    private static final Map<Integer, Character> categoryRegexChars = new LinkedHashMap<Integer, Character>();

    private MyanmarCategory() {
    }

    public static char getCategoryRegexChar(int category) {
        return categoryRegexChars.get(category).charValue();
    }

    public static String getSyllableRegex() {
        String A = String.valueOf(MyanmarCategory.getCategoryRegexChar(10));
        String As = String.valueOf(MyanmarCategory.getCategoryRegexChar(18));
        String C = String.valueOf(MyanmarCategory.getCategoryRegexChar(1));
        String D = String.valueOf(MyanmarCategory.getCategoryRegexChar(19));
        String D0 = String.valueOf(MyanmarCategory.getCategoryRegexChar(20));
        String DB = String.valueOf(MyanmarCategory.getCategoryRegexChar(3));
        String GB = String.valueOf(MyanmarCategory.getCategoryRegexChar(11));
        String H = String.valueOf(MyanmarCategory.getCategoryRegexChar(4));
        String IV = String.valueOf(MyanmarCategory.getCategoryRegexChar(2));
        String MH = String.valueOf(MyanmarCategory.getCategoryRegexChar(21));
        String MR = String.valueOf(MyanmarCategory.getCategoryRegexChar(22));
        String MW = String.valueOf(MyanmarCategory.getCategoryRegexChar(23));
        String MY = String.valueOf(MyanmarCategory.getCategoryRegexChar(24));
        String PT = String.valueOf(MyanmarCategory.getCategoryRegexChar(25));
        String V = String.valueOf(MyanmarCategory.getCategoryRegexChar(8));
        String VAbv = String.valueOf(MyanmarCategory.getCategoryRegexChar(26));
        String VBlw = String.valueOf(MyanmarCategory.getCategoryRegexChar(27));
        String VPre = String.valueOf(MyanmarCategory.getCategoryRegexChar(28));
        String VPst = String.valueOf(MyanmarCategory.getCategoryRegexChar(29));
        String VS = String.valueOf(MyanmarCategory.getCategoryRegexChar(30));
        String ZWJ = String.valueOf(MyanmarCategory.getCategoryRegexChar(6));
        String ZWNJ = String.valueOf(MyanmarCategory.getCategoryRegexChar(5));
        String Ra = String.valueOf(MyanmarCategory.getCategoryRegexChar(16));
        String P = String.valueOf(MyanmarCategory.getCategoryRegexChar(31));
        String j = "(" + ZWJ + "|" + ZWNJ + ")";
        String k = "((" + Ra + As + H + "))";
        String c = "(" + C + "|" + Ra + ")";
        String medial_group = "(" + MY + "?" + MR + "?" + MW + "?" + MH + "?" + As + "?)";
        String main_vowel_group = "(" + VPre + "*" + VAbv + "*" + VBlw + "*" + A + "*(" + DB + As + "?)?)";
        String post_vowel_group = "(" + VPst + MH + "?" + As + "*" + VAbv + "*" + A + "*(" + DB + As + "?)?)";
        String pwo_tone_group = "(" + PT + A + "*" + DB + "?" + As + "?)";
        String complex_syllable_tail = "(" + As + "*" + medial_group + main_vowel_group + post_vowel_group + "*" + pwo_tone_group + "*" + V + "*" + j + "?)";
        String syllable_tail = "((" + H + "|" + complex_syllable_tail + "))";
        String consonant_syllable = "(" + k + "?(" + c + "|" + IV + "|" + D + "|" + GB + ")" + VS + "?(" + H + "(" + c + "|" + IV + ")" + VS + "?)*" + syllable_tail + ")";
        String punctuation_cluster = "(" + P + V + ")";
        String broken_cluster = "(" + k + "?" + VS + "?" + syllable_tail + ")";
        String regexp = "(" + consonant_syllable + "|" + j + "|" + punctuation_cluster + "|" + broken_cluster + ")";
        return regexp;
    }

    static {
        categoryRegexChars.put(10, Character.valueOf('A'));
        categoryRegexChars.put(18, Character.valueOf('s'));
        categoryRegexChars.put(1, Character.valueOf('C'));
        categoryRegexChars.put(19, Character.valueOf('D'));
        categoryRegexChars.put(20, Character.valueOf('0'));
        categoryRegexChars.put(3, Character.valueOf('B'));
        categoryRegexChars.put(11, Character.valueOf('G'));
        categoryRegexChars.put(4, Character.valueOf('H'));
        categoryRegexChars.put(2, Character.valueOf('I'));
        categoryRegexChars.put(21, Character.valueOf('M'));
        categoryRegexChars.put(22, Character.valueOf('R'));
        categoryRegexChars.put(23, Character.valueOf('W'));
        categoryRegexChars.put(24, Character.valueOf('Y'));
        categoryRegexChars.put(25, Character.valueOf('P'));
        categoryRegexChars.put(8, Character.valueOf('V'));
        categoryRegexChars.put(26, Character.valueOf('b'));
        categoryRegexChars.put(27, Character.valueOf('l'));
        categoryRegexChars.put(28, Character.valueOf('r'));
        categoryRegexChars.put(29, Character.valueOf('t'));
        categoryRegexChars.put(30, Character.valueOf('S'));
        categoryRegexChars.put(6, Character.valueOf('Z'));
        categoryRegexChars.put(5, Character.valueOf('N'));
        categoryRegexChars.put(16, Character.valueOf('a'));
        categoryRegexChars.put(31, Character.valueOf('p'));
        categoryRegexChars.put(0, Character.valueOf('X'));
    }
}

