/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.indic;

import com.itextpdf.commons.utils.MessageFormatUtil;

public abstract class IndicConfig {
    protected final boolean hasOldSpec;
    protected final int virama;
    protected final int basePosition;
    protected final int rephPosition;
    protected final int rephMode;
    protected final int blwfMode;
    protected final int prefLen;

    protected IndicConfig(boolean hasOldSpec, int virama, int basePosition, int rephPosition, int rephMode, int blwfMode, int prefLen) {
        this.hasOldSpec = hasOldSpec;
        this.virama = virama;
        this.basePosition = basePosition;
        this.rephPosition = rephPosition;
        this.rephMode = rephMode;
        this.blwfMode = blwfMode;
        this.prefLen = prefLen;
    }

    public static IndicConfig getConfig(Character.UnicodeScript unicodeScript) {
        switch (unicodeScript) {
            case DEVANAGARI: {
                return new DevanagariConfig();
            }
            case TAMIL: {
                return new TamilConfig();
            }
            case GURMUKHI: {
                return new GurmukhiConfig();
            }
            case KANNADA: {
                return new KannadaConfig();
            }
            case KHMER: {
                return new KhmerConfig();
            }
            case ORIYA: {
                return new OdiaConfig();
            }
            case BENGALI: {
                return new BengaliConfig();
            }
            case MALAYALAM: {
                return new MalayalamConfig();
            }
            case GUJARATI: {
                return new GujaratiConfig();
            }
            case TELUGU: {
                return new TeluguConfig();
            }
        }
        throw new IllegalArgumentException(MessageFormatUtil.format((String)"Config was not found for {0}", (Object[])new Object[]{unicodeScript}));
    }

    public boolean hasOldSpec() {
        return this.hasOldSpec;
    }

    public int getBasePosition() {
        return this.basePosition;
    }

    public int getRephPosition() {
        return this.rephPosition;
    }

    public int getRephMode() {
        return this.rephMode;
    }

    public int getBlwfMode() {
        return this.blwfMode;
    }

    public int getPrefLen() {
        return this.prefLen;
    }

    public int getVirama() {
        return this.virama;
    }

    public static class KhmerConfig
    extends IndicConfig {
        public KhmerConfig() {
            super(false, 6098, 0, 1, 2, 0, 2);
        }
    }

    public static class GujaratiConfig
    extends IndicConfig {
        public GujaratiConfig() {
            super(true, 2765, 2, 10, 0, 0, 2);
        }
    }

    public static class TeluguConfig
    extends IndicConfig {
        public TeluguConfig() {
            super(true, 3149, 2, 12, 1, 1, 2);
        }
    }

    public static class MalayalamConfig
    extends IndicConfig {
        public MalayalamConfig() {
            super(true, 3405, 2, 5, 3, 0, 2);
        }
    }

    public static class BengaliConfig
    extends IndicConfig {
        public BengaliConfig() {
            super(true, 2509, 2, 9, 0, 0, 2);
        }
    }

    public static class OdiaConfig
    extends IndicConfig {
        public OdiaConfig() {
            super(true, 2893, 2, 5, 0, 0, 2);
        }
    }

    public static class KannadaConfig
    extends IndicConfig {
        public KannadaConfig() {
            super(true, 3277, 2, 12, 0, 1, 2);
        }
    }

    public static class GurmukhiConfig
    extends IndicConfig {
        public GurmukhiConfig() {
            super(true, 2637, 2, 7, 0, 0, 2);
        }
    }

    public static class TamilConfig
    extends IndicConfig {
        public TamilConfig() {
            super(true, 3021, 2, 12, 0, 0, 2);
        }
    }

    public static class DevanagariConfig
    extends IndicConfig {
        public DevanagariConfig() {
            super(true, 2381, 2, 10, 0, 0, 2);
        }
    }
}

