/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.indic;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.typography.ordering.TypographyCluster;
import com.itextpdf.typography.ordering.TypographyGlyph;
import com.itextpdf.typography.ordering.indic.IndicShaper;
import java.util.ArrayList;
import java.util.List;

public class IndicCluster
extends TypographyCluster {
    private int previousGlyphUnicode = -1;

    public IndicCluster(List<Glyph> glyphs, int originalGlyphLineStart, int originalGlyphLineEnd, String actualText) {
        super(IndicCluster.constructIndicGlyphList(glyphs), originalGlyphLineStart, originalGlyphLineEnd, actualText);
    }

    public IndicCluster(GlyphLine glyphLine, int start, int end, String actualText) {
        super(glyphLine, start, end);
        ArrayList<Glyph> indicGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.glyphs) {
            indicGlyphs.add((Glyph)(glyph instanceof IndicGlyph ? glyph : new IndicGlyph(glyph)));
        }
        this.setGlyphs(indicGlyphs);
        this.originalGlyphLineStart = start;
        this.originalGlyphLineEnd = end;
        this.clusterActualText = actualText;
    }

    public static List<Glyph> constructIndicGlyphList(List<Glyph> glyphs) {
        ArrayList<Glyph> newGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : glyphs) {
            newGlyphs.add(new IndicGlyph(glyph));
        }
        return newGlyphs;
    }

    public GlyphLine copy(int left, int right) {
        GlyphLine gl = super.copy(left, right);
        IndicCluster copy = new IndicCluster(gl, gl.start, gl.end, this.getClusterActualText());
        copy.originalGlyphLineStart = this.originalGlyphLineStart;
        copy.originalGlyphLineEnd = this.originalGlyphLineEnd;
        return copy;
    }

    @Override
    public TypographyGlyph createGlyphForSubstitution(Glyph glyph, TypographyGlyph oldGlyph) {
        return new IndicGlyph(glyph, oldGlyph.category, oldGlyph.position, oldGlyph.mask);
    }

    @Override
    public TypographyGlyph createComplexGlyph(Glyph glyph) {
        return new IndicGlyph(glyph);
    }

    public IndicCluster setPreviousGlyphUnicode(int previousGlyphUnicode) {
        this.previousGlyphUnicode = previousGlyphUnicode;
        return this;
    }

    @Override
    public TypographyCluster createCluster(List<Glyph> glyphs, int originalGlyphLineStart, int originalGlyphLineEnd, String actualText) {
        return new IndicCluster(glyphs, originalGlyphLineStart, originalGlyphLineEnd, actualText);
    }

    void memMove(int dest, int source, int count) {
        int i;
        ArrayList temp = new ArrayList(count);
        for (i = 0; i < count; ++i) {
            temp.add(this.glyphs.get(source + i));
        }
        for (i = 0; i < count; ++i) {
            this.glyphs.set(dest + i, temp.get(i));
        }
    }

    int getPreviousGlyphUnicode() {
        return this.previousGlyphUnicode;
    }

    public static class IndicGlyph
    extends TypographyGlyph {
        public IndicGlyph(Glyph glyph) {
            super(glyph);
            IndicShaper.setIndicProperties(this);
        }

        public IndicGlyph(Glyph glyph, int category, int indicPos, int mask) {
            super(glyph, category, indicPos, mask);
        }
    }
}

