/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.typography.ordering.TypographyGlyph;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class TypographyCluster
extends GlyphLine {
    public int originalGlyphLineStart;
    public int originalGlyphLineEnd;
    protected String clusterActualText;

    public TypographyCluster(List<Glyph> glyphs, int originalGlyphLineStart, int originalGlyphLineEnd, String actualText) {
        super(glyphs);
        this.originalGlyphLineStart = originalGlyphLineStart;
        this.originalGlyphLineEnd = originalGlyphLineEnd;
        this.clusterActualText = actualText;
    }

    public TypographyCluster(GlyphLine glyphLine, int start, int end, String actualText) {
        super(glyphLine, start, end);
        this.originalGlyphLineStart = start;
        this.originalGlyphLineEnd = end;
        this.clusterActualText = actualText;
    }

    public TypographyCluster(GlyphLine glyphLine, int start, int end) {
        super(glyphLine, start, end);
        this.originalGlyphLineStart = start;
        this.originalGlyphLineEnd = end;
    }

    public Glyph get(int pos) {
        if (!(this.glyphs.get(pos) instanceof TypographyGlyph)) {
            this.glyphs.set(pos, this.createComplexGlyph((Glyph)this.glyphs.get(pos)));
        }
        return (Glyph)this.glyphs.get(pos);
    }

    public void substituteManyToOne(OpenTypeFontTableReader tableReader, int lookupFlag, int rightPartLen, int substitutionGlyphIndex) {
        TypographyGlyph oldGlyph = (TypographyGlyph)this.get(this.idx);
        super.substituteManyToOne(tableReader, lookupFlag, rightPartLen, substitutionGlyphIndex);
        this.glyphs.set(this.idx, this.createGlyphForSubstitution((Glyph)this.glyphs.get(this.idx), oldGlyph).setLigated().setSubstituted());
    }

    public void substituteOneToOne(OpenTypeFontTableReader tableReader, int substitutionGlyphIndex) {
        TypographyGlyph oldGlyph = (TypographyGlyph)this.get(this.idx);
        super.substituteOneToOne(tableReader, substitutionGlyphIndex);
        this.glyphs.set(this.idx, this.createGlyphForSubstitution((Glyph)this.glyphs.get(this.idx), oldGlyph).setSubstituted());
    }

    public void substituteOneToMany(OpenTypeFontTableReader tableReader, int[] substGlyphIds) {
        TypographyGlyph oldGlyph = (TypographyGlyph)this.get(this.idx);
        super.substituteOneToMany(tableReader, substGlyphIds);
        for (int i = 0; i < substGlyphIds.length; ++i) {
            this.glyphs.set(this.idx - i, this.createGlyphForSubstitution((Glyph)this.glyphs.get(this.idx - i), oldGlyph).setSubstituted());
        }
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        TypographyCluster other = (TypographyCluster)((Object)obj);
        return this.originalGlyphLineEnd == other.originalGlyphLineEnd && this.originalGlyphLineStart == other.originalGlyphLineStart && this.clusterActualText.equals(other.clusterActualText);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.originalGlyphLineStart;
        result = 31 * result + this.originalGlyphLineEnd;
        result = 31 * result + this.clusterActualText.hashCode();
        return result;
    }

    public abstract TypographyGlyph createGlyphForSubstitution(Glyph var1, TypographyGlyph var2);

    public abstract TypographyGlyph createComplexGlyph(Glyph var1);

    public abstract TypographyCluster createCluster(List<Glyph> var1, int var2, int var3, String var4);

    public void sortByPosition() {
        Collections.sort(this.glyphs, new Comparator<Glyph>(){

            @Override
            public int compare(Glyph o1, Glyph o2) {
                if (!(o1 instanceof TypographyGlyph) || !(o2 instanceof TypographyGlyph)) {
                    throw new IllegalStateException();
                }
                TypographyGlyph a = (TypographyGlyph)o1;
                TypographyGlyph b = (TypographyGlyph)o2;
                if (a.position == b.position) {
                    return 0;
                }
                if (a.position < b.position) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public String getClusterActualText() {
        return this.clusterActualText;
    }
}

