/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.clustering;

import com.itextpdf.io.font.otf.ActualTextIterator;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.typography.clustering.IClusterCreationHelper;
import com.itextpdf.typography.ordering.TypographyCluster;
import com.itextpdf.typography.ordering.TypographyGlyph;
import com.itextpdf.typography.ordering.indic.IndicCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClusterCreatorUtil {
    private ClusterCreatorUtil() {
    }

    public static List<TypographyCluster> splitTypographyGlyphLineIntoClusters(GlyphLine originalGlyphLine, IClusterCreationHelper clusterCreation) {
        ArrayList<TypographyGlyph> indicGlyphs = new ArrayList<TypographyGlyph>();
        StringBuilder sb = new StringBuilder();
        ActualTextIterator iterator = new ActualTextIterator(originalGlyphLine, originalGlyphLine.start, originalGlyphLine.end);
        HashMap<Integer, GlyphLine.GlyphLinePart> partBeginnings = new HashMap<Integer, GlyphLine.GlyphLinePart>();
        while (iterator.hasNext()) {
            GlyphLine.GlyphLinePart part = iterator.next();
            for (int i = part.start; i < part.end; ++i) {
                Glyph oldGlyph = originalGlyphLine.get(i);
                TypographyGlyph typographyGlyph = clusterCreation.createComplexGlyph(oldGlyph);
                indicGlyphs.add(typographyGlyph);
                char typographyCategoryRegexChar = typographyGlyph.hasValidUnicode() ? (char)clusterCreation.getCategoryRegexChar(typographyGlyph.category) : (char)'X';
                sb.append(typographyCategoryRegexChar);
            }
            if (part.actualText == null) continue;
            partBeginnings.put(part.start, part);
        }
        String classes = sb.toString();
        Pattern pattern = Pattern.compile(clusterCreation.getSyllableRegex());
        Matcher matcher = pattern.matcher(classes);
        ArrayList<TypographyCluster> clusters = new ArrayList<TypographyCluster>();
        while (matcher.find()) {
            if (matcher.start() == matcher.end()) continue;
            StringBuilder actualText = new StringBuilder();
            for (int pos = originalGlyphLine.start + matcher.start(); pos < originalGlyphLine.start + matcher.end() && actualText != null; ++pos) {
                if (partBeginnings.get(pos) != null) {
                    GlyphLine.GlyphLinePart part = (GlyphLine.GlyphLinePart)partBeginnings.get(pos);
                    actualText.append(part.actualText);
                    pos += part.end - part.start - 1;
                    continue;
                }
                Glyph glyph = originalGlyphLine.get(pos);
                if (glyph.hasValidUnicode()) {
                    actualText.append(TextUtil.convertFromUtf32((int)glyph.getUnicode()));
                    continue;
                }
                actualText = null;
            }
            TypographyCluster newCluster = clusterCreation.createCluster(indicGlyphs.subList(matcher.start(), matcher.end()), originalGlyphLine.start + matcher.start(), originalGlyphLine.start + matcher.end(), actualText != null ? actualText.toString() : null);
            if (0 != matcher.start() && newCluster instanceof IndicCluster) {
                ((IndicCluster)newCluster).setPreviousGlyphUnicode(((Glyph)indicGlyphs.get(matcher.start() - 1)).getUnicode());
            }
            clusters.add(newCluster);
        }
        return clusters;
    }

    public static TypographyCluster wrapTypographyGlyphLineIntoSingleCluster(GlyphLine originalGlyphLine, IClusterCreationHelper clusterCreation) {
        TypographyCluster cluster = clusterCreation.createCluster(originalGlyphLine, originalGlyphLine.start, originalGlyphLine.end, originalGlyphLine.toString());
        return cluster;
    }
}

