define("ace/mode/baan_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;

var BaanHighlightRules = function() {

    var keywordControls = (
            "and|as|at|" +
            "base|break|by|" +
            "case|continue|" +
            "default|" +
            "else|end|endcase|endfor|endif|endwhile|endselect|eq|" +
            "for|from|function|" +
            "ge|goto|group|gt|" +
            "if|" +
            "le|lt|" +
            "ne|not|" +
            "on|or|order|" +
            "refers|repeat|return|rows|" +
            "select|selectbind|selectdo|selectempty|selecteos|selecterror|set|step|" +
            "then|to|" +
            "until|" +
            "where|wherebind|whereused|while|with"
        );

    var storageType = (
            "boolean|" +
            "domain|double|" +
            "long|" +
            "string|table|" +
            "void"
        );

    var storageModifiers = (
            "based|" +
            "common|const|" +
            "extern|" +
            "fixed|" +
            "global|" +
            "mb|multibyte|" +
            "ref|" +
            "static"
        );

    var builtinConstants = (
    		"ALL_ENUMS_EXCEPT|APPL.READ|APPL.WRITE|APPL.EXCL|APPL.WIDE|APPL.WAIT|" +
    		"DAL_NEW|DAL_UPDATE|DAL_DESTROY|DALHOOKERROR|DAL_GET_FIRST|DAL_GET_LAST|DAL_GET_NEXT|DAL_GET_PREV|DAL_GET_FIND|DAL_GET_CURR|" +
            "empty|" +
    		"EXTEND_APPEND|" +
    		"false|" +
    		"logname$|" +
    		"true"
        );

    var builtinFunctions = (
        "abs|acon|asin|atan|" +
        "cos|cosh|" +
        "double.comp|" +
        "format.round|" +
        "int|" +
        "log|log10|lpow|" +
        "max|min|" +
        "pow|" +
        "round|" +
        "set.fmax|set.fmin|set.max|set.min|sin|sinh|sqrt|" +
        "table.round|tan|tanh"
    );

    var keywordMapper = this.$keywords = this.createKeywordMapper({
        "keyword.control" : keywordControls,
        "storage.type" : storageType,
        "storage.modifier" : storageModifiers,
        "variable.language": "this",
        "constant.language": builtinConstants,
        "support.function": builtinFunctions
    }, "identifier", true);

    this.$rules = { 
            "start" : [
                {
                    token : "comment",
                    regex : "\\|.*$"
                }, {
                    token : "string", // single line
                    regex : '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
                }, {
                    token : "string", // single line
                    regex : "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
                }, {
                    token : "constant.numeric", // hex
                    regex : "0[xX][0-9a-fA-F]+(L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"
                }, {
                    token : "constant.numeric", // float
                    regex : "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?(L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"
                }, {
                    token : "directive", // pre-compiler directives
                    regex : "#\\s*(?:define|else|elif|endif|ident|if|ifdef|ifndef|include|pragma|undef)\\b"
                }, {
                    token : keywordMapper,
                    regex : "[a-zA-Z_$][a-zA-Z0-9_$\\.]*\\b"
                }, {
                    token : "keyword.operator",
                    regex : "!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|==|=|!=|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^="
                }, {
                    token : "punctuation.operator",
                    regex : "\\?|\\:|\\,|\\;"
                }, {
                    token : "paren.lparen",
                    regex : "[[({]"
                }, {
                    token : "paren.rparen",
                    regex : "[\\])}]"
                }, {
                    token : "text",
                    regex : "\\s+"
                }
            ]
        };

};

oop.inherits(BaanHighlightRules, TextHighlightRules);

exports.BaanHighlightRules = BaanHighlightRules;
});

define("ace/mode/baan_token_tooltip",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/range","ace/tooltip","ace/editor"], function(require, exports, module) {
"use strict";

var dom = require("ace/lib/dom");
var oop = require("ace/lib/oop");
var event = require("ace/lib/event");
var Range = require("ace/range").Range;
var Tooltip = require("ace/tooltip").Tooltip;

function TokenTooltip (editor) {
	if (editor.tokenTooltip)
      return;
  Tooltip.call(this, editor.container);
  editor.tokenTooltip = this;
  this.editor = editor;

  this.update = this.update.bind(this);
  this.onMouseMove = this.onMouseMove.bind(this);
  this.onMouseOut = this.onMouseOut.bind(this);
  event.addListener(editor.renderer.scroller, "mousemove", this.onMouseMove);
  event.addListener(editor.renderer.content, "mouseout", this.onMouseOut);
}

oop.inherits(TokenTooltip, Tooltip);

(function(){
  this.token = {};
  this.range = new Range();
  
  this.update = function() {
      this.$timer = null;
      
      var r = this.editor.renderer;
      if (this.lastT - (r.timeStamp || 0) > 1000) {
          r.rect = null;
          r.timeStamp = this.lastT;
          this.maxHeight = window.innerHeight;
          this.maxWidth = window.innerWidth;
      }

      var canvasPos = r.rect || (r.rect = r.scroller.getBoundingClientRect());
      var offset = (this.x + r.scrollLeft - canvasPos.left - r.$padding) / r.characterWidth;
      var row = Math.floor((this.y + r.scrollTop - canvasPos.top) / r.lineHeight);
      var col = Math.round(offset);

      var screenPos = {row: row, column: col, side: offset - col > 0 ? 1 : -1};
      var session = this.editor.session;
      var docPos = session.screenToDocumentPosition(screenPos.row, screenPos.column);
      var token = session.getTokenAt(docPos.row, docPos.column);

      if (!token && !session.getLine(docPos.row)) {
          token = {
              type: "",
              value: "",
              state: session.bgTokenizer.getState(0)
          };
      }
      if (!token) {
          session.removeMarker(this.marker);
          this.hide();
          return;
      }

      var tokenText = this.getTooltipText(token)

      if (!tokenText) {
          session.removeMarker(this.marker);
          this.hide();
          return;
      }
      
      if (this.tokenText != tokenText) {
          this.setText(tokenText);
          this.width = this.getWidth();
          this.height = this.getHeight();
          this.tokenText = tokenText;
      }

      this.show(null, this.x, this.y);

      this.token = token;
      session.removeMarker(this.marker);
      this.range = new Range(docPos.row, token.start, docPos.row, token.start + token.value.length);
      this.marker = session.addMarker(this.range, "ace_bracket", "text");
  };

  this.onMouseMove = function(e) {
      this.x = e.clientX;
      this.y = e.clientY;
      if (this.isOpen) {
          this.lastT = e.timeStamp;
          this.setPosition(this.x, this.y);
      }
      if (!this.$timer)
          this.$timer = setTimeout(this.update, 100);
  };

  this.onMouseOut = function(e) {
      if (e && e.currentTarget.contains(e.relatedTarget))
          return;
      this.hide();
      this.editor.session.removeMarker(this.marker);
      this.$timer = clearTimeout(this.$timer);
  };

  this.setPosition = function(x, y) {
      if (x + 10 + this.width > this.maxWidth)
          x = window.innerWidth - this.width - 10;
      if (y > window.innerHeight * 0.75 || y + 20 + this.height > this.maxHeight)
          y = y - this.height - 30;

      Tooltip.prototype.setPosition.call(this, x + 10, y + 20);
  };

  this.destroy = function() {
      this.onMouseOut();
      event.removeListener(this.editor.renderer.scroller, "mousemove", this.onMouseMove);
      event.removeListener(this.editor.renderer.content, "mouseout", this.onMouseOut);
      delete this.editor.tokenTooltip;
  };

}).call(TokenTooltip.prototype);

exports.TokenTooltip = TokenTooltip;

});

define("ace/mode/baan",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/baan_highlight_rules"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var BaanHighlightRules = require("./baan_highlight_rules").BaanHighlightRules;

var Mode = function() {
    this.HighlightRules = BaanHighlightRules;
};
oop.inherits(Mode, TextMode);

(function() {

    this.lineCommentStart = "|";

    this.$id = "ace/mode/baan";
}).call(Mode.prototype);

exports.Mode = Mode;

});

// remove text completer with "local" proposals
langTools = require("ace/ext/language_tools")
langTools.setCompleters([langTools.snippetCompleter, langTools.keyWordCompleter])

