/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.Breakpoint;
import com.infor.ln.dbg.wb.shared.LNSourceTypes;
import javax.xml.bind.annotation.XmlElement;

public final class Watchpoint
extends Breakpoint {
    @XmlElement(name="line")
    private int lineNumber;
    @XmlElement(name="variable")
    private String variable = "";
    @XmlElement(name="value")
    private String value;

    private Watchpoint() {
    }

    public Watchpoint(String scriptName, LNSourceTypes sourceType, int lineNumber, String variable, String value) {
        super(scriptName, sourceType);
        this.lineNumber = lineNumber;
        this.variable = variable;
        this.value = value;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getClassName() {
        if (this.value == null) {
            return "modification_watchpoint";
        }
        return "condition_watchpoint";
    }

    public String getDescription() {
        String scriptName = super.getDescription();
        if (this.value == null) {
            return scriptName + " [modification] - " + this.variable;
        }
        return scriptName + " [condition] - " + this.variable + "=" + this.value;
    }

    public int hashCode() {
        return this.getScriptName().hashCode() + this.lineNumber + this.variable.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Watchpoint && ((Watchpoint)o).getScriptName().equals(this.getScriptName()) && ((Watchpoint)o).getLineNumber() == this.lineNumber && ((Watchpoint)o).getVariable().equals(this.variable);
    }

    public int compareTo(Breakpoint other) {
        if (!this.getScriptName().equals(other.getScriptName())) {
            return this.getScriptName().compareTo(other.getScriptName());
        }
        if (other instanceof Watchpoint) {
            return this.variable.compareTo(((Watchpoint)other).getVariable());
        }
        return 1;
    }
}

