/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.IValue;
import com.infor.ln.dbg.wb.shared.StackFrame;
import com.infor.ln.dbg.wb.shared.Symbol;
import com.infor.ln.dbg.wb.shared.Utils;
import com.infor.ln.dbg.wb.shared.ValueArray;
import com.infor.ln.dbg.wb.shared.ValueComposed;
import com.infor.ln.dbg.wb.shared.ValueSimple;
import java.io.Serializable;
import java.util.ArrayList;

public class Variable
implements Serializable {
    public static final String SCOPE_INTERNAL = "internal";
    public static final String SCOPE_LOCAL = "local";
    public static final String SCOPE_GLOBAL = "global";
    public static final String SCOPE_EXTERNAL = "external";
    public static final String SCOPE_UNKNOWN = "unknown";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_MB_STRING = "mb string";
    public static final String TYPE_ML_STRING = "ml string";
    public static final String TYPE_BASE64 = "base64";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_HEX = "hex";
    public static final String TYPE_BIN = "bin";
    public static final String TYPE_LN_DATE = "date";
    public static final String TYPE_UTC = "utc";
    public static final String TYPE_TIME = "time";
    private StackFrame stackFrame;
    private String scope = "local";
    private String name = "";
    private String type = "";
    private String language = "";
    private boolean array;
    private boolean fixed;
    private boolean based;
    private IValue value;

    public Variable(StackFrame stackFrame, String name, String type, String scope, boolean array, boolean fixed, boolean based) {
        this.stackFrame = stackFrame;
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.array = array;
        this.fixed = fixed;
        this.based = based;
    }

    public Variable(StackFrame stackFrame, String scope, Symbol symbol) {
        this.stackFrame = stackFrame;
        this.scope = scope;
        this.convertSymbolToVariable(symbol);
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nm) {
        this.name = nm;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String tp) {
        this.type = tp;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isBased() {
        return this.based;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public IValue getValue() {
        return this.value;
    }

    public void setValue(IValue value) {
        this.value = value;
    }

    private String getSymbolName(Symbol symbol, String scope) {
        if ((scope.equals(SCOPE_LOCAL) || scope.equals(SCOPE_INTERNAL)) && symbol.getName().startsWith(this.getStackFrame().getFunctionName())) {
            return symbol.getName().substring(this.getStackFrame().getFunctionName().length() + 1);
        }
        return symbol.getName();
    }

    private Variable createVariable(String symbolName, Symbol.Value value) {
        Variable variable = null;
        if (value.getFormat().equals(TYPE_BASE64)) {
            variable = new Variable(this.getStackFrame(), symbolName, TYPE_HEX, SCOPE_INTERNAL, false, false, false);
            ValueSimple variableValue = new ValueSimple(this.getStackFrame(), this.getScope(), TYPE_HEX, this.convertBase64ToHexString(value.getValue()));
            variable.setValue((IValue)variableValue);
        } else {
            variable = new Variable(this.getStackFrame(), symbolName, value.getFormat(), SCOPE_INTERNAL, false, false, false);
            ValueSimple variableValue = new ValueSimple(this.getStackFrame(), this.getScope(), value.getFormat(), value.getValue());
            variable.setValue((IValue)variableValue);
        }
        return variable;
    }

    private String convertBase64ToHexString(String base64) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (base64 != null) {
            byte[] b = Utils.Base64.decode((String)base64);
            StringBuffer sb = new StringBuffer(b.length * 2);
            String hexCharacter = null;
            for (int i = 0; i < b.length; ++i) {
                sb.append("\\x");
                hexCharacter = String.valueOf(hexChar[(b[i] & 0xF0) >>> 4]);
                sb.append(hexCharacter.toUpperCase());
                hexCharacter = String.valueOf(hexChar[b[i] & 0xF]);
                sb.append(hexCharacter.toUpperCase());
            }
            return sb.toString();
        }
        return null;
    }

    private void convertSymbolToVariable(Symbol symbol) {
        String symbolName;
        this.name = symbolName = this.getSymbolName(symbol, this.scope);
        this.type = symbol.getType();
        this.array = symbol.isArray();
        this.based = symbol.isBased();
        this.fixed = symbol.isFixed();
        ValueArray variableValue = null;
        if (symbol.isArray()) {
            variableValue = new ValueArray(this.getStackFrame(), this.scope, symbolName, symbol.getType(), new int[0], symbol.getArrayDimensions(), 1, symbol.getArrayDimensions()[0]);
        } else {
            ArrayList<Variable> variableList = new ArrayList<Variable>();
            for (Symbol.Value symbolValue : symbol.getValues()) {
                Variable variable;
                if (variableValue == null && this.isSimpleType(symbolValue.getFormat())) {
                    variableValue = new ValueComposed(this.getStackFrame(), this.getScope(), symbolValue.getFormat(), symbolValue.getValue());
                }
                if ((variable = this.createVariable(symbolName, symbolValue)) == null) continue;
                variableList.add(variable);
            }
            for (Symbol.MlString mlString : symbol.getMlStrings()) {
                if (mlString.getValuesMl().size() <= 0) continue;
                for (Symbol.SlString slString : mlString.getValuesMl()) {
                    if (slString.getValueList().size() <= 0) continue;
                    for (Symbol.Value valueOfSl : slString.getValueList()) {
                        if (!valueOfSl.getFormat().equals(TYPE_STRING)) continue;
                        Variable variable = this.createVariable(symbolName, valueOfSl);
                        variable.setLanguage(slString.getLanguage());
                        variable.setType(TYPE_ML_STRING);
                        if (variableList.contains(variable)) continue;
                        variableList.add(variable);
                    }
                }
            }
            if (variableValue == null) {
                variableValue = new ValueComposed(this.getStackFrame(), this.getScope(), symbol.getType(), null);
            }
            variableValue.setVariables(variableList);
        }
        this.setValue((IValue)variableValue);
    }

    protected boolean variableIsValid(String scope, String variable) {
        if (scope.equals(SCOPE_LOCAL) || scope.equals(SCOPE_INTERNAL)) {
            return variable.startsWith(this.getStackFrame().getFunctionName());
        }
        return true;
    }

    protected String normalizeValue(String value) {
        String normalizedValue = value;
        try {
            if ((this.getType().equals(TYPE_STRING) || this.getType().equals(TYPE_MB_STRING)) && normalizedValue.startsWith("\"") && normalizedValue.endsWith("\"")) {
                normalizedValue = normalizedValue.substring(1, normalizedValue.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return normalizedValue;
    }

    public void setValue(String expression) {
    }

    public boolean supportsValueModification() {
        return this.hasValue() && this.isSimpleType() && !this.isArray() && !this.isUnknownScope();
    }

    public boolean verifyValue(String expression) {
        if (this.getType().equals(TYPE_STRING) || this.getType().equals(TYPE_MB_STRING)) {
            return expression.startsWith("\"") && expression.endsWith("\"");
        }
        if (this.getType().equals(TYPE_BOOLEAN)) {
            return this.isBoolean(expression);
        }
        return !expression.contains("\"");
    }

    private boolean isBoolean(String value) {
        return value.equals("true") || value.equals("false");
    }

    public boolean verifyValue(IValue value) {
        return true;
    }

    protected boolean hasValue() {
        try {
            return this.getValue() != null && this.getValue().getValue() != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isSimpleType() {
        return this.isSimpleType(this.getType());
    }

    private boolean isSimpleType(String type) {
        return type.equals(TYPE_LONG) || type.equals(TYPE_STRING) || type.equals(TYPE_MB_STRING) || type.equals(TYPE_BOOLEAN) || type.equals(TYPE_DOUBLE);
    }

    public boolean isLocalScope() {
        return this.scope.equals(SCOPE_LOCAL);
    }

    public boolean isInternalScope() {
        return this.scope.equals(SCOPE_INTERNAL);
    }

    public boolean isGlobalScope() {
        return this.scope.equals(SCOPE_GLOBAL);
    }

    public boolean isExternalScope() {
        return this.scope.equals(SCOPE_EXTERNAL);
    }

    public boolean isUnknownScope() {
        return this.scope.equals(SCOPE_UNKNOWN);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

