/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.IValue;
import com.infor.ln.dbg.wb.shared.StackFrame;
import com.infor.ln.dbg.wb.shared.Variable;
import com.infor.ln.dbg.wb.shared.VariableArray;
import com.infor.ln.dbg.wb.shared.VariableArrayPartition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ValueSimple
implements IValue,
Serializable {
    private StackFrame stackFrame;
    private String scope = "local";
    private String type;
    private String value;

    public ValueSimple(StackFrame stackFrame, String scope, String type, String value) {
        this.stackFrame = stackFrame;
        this.scope = scope;
        this.type = type;
        this.value = value;
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public String getScope() {
        return this.scope;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValueString() {
        if (this.getValue() != null) {
            if ("string".equals(this.type) || "mb string".equals(this.type)) {
                return "\"" + this.getValue() + "\"";
            }
            return this.getValue();
        }
        return "[" + this.getType() + "]";
    }

    private boolean isSimpleType() {
        try {
            if (this.containsArray()) {
                return false;
            }
            return this.isSimpleType(this.getType());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean containsArray() {
        if (this.getVariables() != null && !this.getVariables().isEmpty()) {
            Variable variable = (Variable)this.getVariables().get(0);
            if (variable instanceof VariableArray || variable instanceof VariableArrayPartition) {
                return true;
            }
            if (variable.isArray()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSimpleType(String type) {
        return type.equals("long") || type.equals("string") || type.equals("mb string") || type.equals("boolean") || type.equals("double");
    }

    public List<Variable> getVariables() {
        return new ArrayList<Variable>();
    }

    public boolean hasVariables() {
        return false;
    }
}

