/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.StackFrame;
import com.infor.ln.dbg.wb.shared.ValueComposed;
import com.infor.ln.dbg.wb.shared.Variable;
import com.infor.ln.dbg.wb.shared.VariableArray;
import com.infor.ln.dbg.wb.shared.VariableArrayPartition;
import java.util.ArrayList;
import java.util.List;

public class ValueArray
extends ValueComposed {
    private static final int MAX_SIZE_OF_PARTITION = 10;
    private String arrayName;
    private int[] currentIndex;
    private int[] dimensions;
    private int startOfPartition;
    private int sizeOfPartition;

    public ValueArray(StackFrame stackFrame, String scope, String arrayName, String type, int[] currentIndex, int[] dimensions, int startOfPartition, int sizeOfPartition) {
        super(stackFrame, scope, type, null);
        this.arrayName = arrayName;
        this.currentIndex = currentIndex;
        this.dimensions = dimensions;
        this.setValue(type, dimensions);
        this.startOfPartition = startOfPartition;
        this.sizeOfPartition = sizeOfPartition;
        this.createArrayElements();
    }

    private void setValue(String type, int[] dimensions) {
        String valueString = type + "[" + dimensions[0] + "]";
        for (int i = 1; i < dimensions.length; ++i) {
            valueString = valueString + "[]";
        }
        super.setValue(valueString);
    }

    public String getValueString() {
        return this.getValue();
    }

    private void createArrayElements() {
        if (this.sizeOfPartition > 10) {
            int nrPartitions = this.dimensions[0] / 10;
            if (this.dimensions[0] % 10 > 0) {
                ++nrPartitions;
            }
            ArrayList<VariableArrayPartition> variables = new ArrayList<VariableArrayPartition>();
            for (int i = 0; i < nrPartitions; ++i) {
                int nrVariables = Math.min(10, this.sizeOfPartition - i * 10);
                VariableArrayPartition partition = new VariableArrayPartition(this.getStackFrame(), this.arrayName, super.getType(), this.getScope(), this.currentIndex, this.dimensions, i * 10 + 1, nrVariables);
                variables.add(partition);
            }
            this.setVariables(variables);
        } else if (this.dimensions.length > 1) {
            int nrVariables = Math.min(10, this.dimensions[0] - this.startOfPartition + 1);
            ArrayList<VariableArray> variables = new ArrayList<VariableArray>();
            for (int i = this.startOfPartition; i < this.startOfPartition + nrVariables; ++i) {
                VariableArray variable = null;
                int currentIndexLength = 0;
                if (this.currentIndex != null) {
                    currentIndexLength = this.currentIndex.length;
                }
                int[] newCurrentIndex = new int[currentIndexLength + 1];
                for (int j = 0; j < currentIndexLength; ++j) {
                    newCurrentIndex[j] = this.currentIndex[j];
                }
                newCurrentIndex[currentIndexLength] = i;
                int[] newDimensions = new int[this.dimensions.length - 1];
                for (int j = 0; j < this.dimensions.length - 1; ++j) {
                    newDimensions[j] = this.dimensions[j + 1];
                }
                variable = new VariableArray(this.getStackFrame(), this.arrayName, super.getType(), this.getScope(), newCurrentIndex, newDimensions, 1, newDimensions[0]);
                variables.add(variable);
            }
            this.setVariables(variables);
        }
    }

    public boolean hasVariables() {
        if (this.dimensions.length >= 1 && this.dimensions[0] <= 0) {
            return false;
        }
        if (this.dimensions.length <= 1) {
            return true;
        }
        return super.hasVariables();
    }

    public boolean isLoaded() {
        return !super.getVariables().isEmpty() || this.dimensions.length > 1;
    }

    public List<Variable> getVariables() {
        return super.getVariables();
    }

    public String getArrayName() {
        return this.arrayName;
    }

    public int[] getCurrentIndex() {
        return this.currentIndex;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public int getStartOfPartition() {
        return this.startOfPartition;
    }

    public int getSizeOfPartition() {
        return this.sizeOfPartition;
    }
}

