/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.Symbol;
import com.infor.ln.dbg.wb.shared.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

/*
 * Exception performing whole class analysis ignored.
 */
public class Symbol
implements Serializable {
    @XmlAttribute(name="name")
    private String name = "";
    @XmlAttribute(name="type")
    private String type = "";
    @XmlAttribute(name="array")
    private String array = "no";
    @XmlAttribute(name="fixed")
    private String fixed = "no";
    @XmlAttribute(name="based")
    private String based = "no";
    @XmlElement(name="dimensions")
    private Dimensions dimensions;
    @XmlElement(name="value")
    private List<Value> values = new ArrayList();
    @XmlElement(name="ml_string")
    private List<MlString> mlStrings = new ArrayList();
    private int arraySize;
    private int[] arrayDimensions = null;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isArray() {
        return "yes".equals(this.array);
    }

    public boolean isBased() {
        return "yes".equals(this.based);
    }

    public boolean isFixed() {
        return "yes".equals(this.fixed);
    }

    public List<Value> getValues() {
        return this.values;
    }

    public List<MlString> getMlStrings() {
        return this.mlStrings;
    }

    public void determine() {
        if (this.isArray()) {
            if (this.dimensions != null) {
                this.arraySize = this.getType().equals("string") || this.getType().equals("mb string") ? Dimensions.access$000((Dimensions)this.dimensions) - 1 : Dimensions.access$000((Dimensions)this.dimensions);
                this.arrayDimensions = new int[this.arraySize];
                for (Dimension dimension : this.dimensions.getDimensions()) {
                    if (dimension.getId() == 0 || dimension.getId() > this.getArraySize()) continue;
                    this.arrayDimensions[dimension.getId() - 1] = dimension.getSize();
                }
            }
        } else {
            Value base64value = null;
            Value stringValue = null;
            ArrayList<Value> invalidValues = new ArrayList<Value>();
            for (Value value : this.values) {
                if (value.isValid()) {
                    if (value.getFormat().equals("base64")) {
                        base64value = value;
                        continue;
                    }
                    if (!value.getFormat().equals("string") && !value.getFormat().equals("mb string")) continue;
                    stringValue = value;
                    continue;
                }
                invalidValues.add(value);
            }
            this.values.removeAll(invalidValues);
            if (base64value != null && stringValue != null) {
                if (this.getType().equals("string")) {
                    stringValue.setValue(new String(Utils.Base64.decode((String)base64value.getValue())).trim());
                } else {
                    stringValue.setValue(stringValue.getValue().trim());
                }
            }
            if (this.getType().equals("long") && this.values.size() > 0) {
                Value baseValue = (Value)this.values.get(0);
                long longValue = Long.valueOf(baseValue.getValue());
                Value hexValue = new Value("hex", Long.toHexString(longValue));
                this.values.add(hexValue);
                Value binValue = new Value("bin", Long.toBinaryString(longValue));
                this.values.add(binValue);
            }
            if (this.getType().equals("boolean") && this.values.size() > 0) {
                Value booleanValue = new Value("boolean", new String(((Value)this.values.get(0)).getValue()));
                this.values.add(booleanValue);
            }
        }
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public int[] getArrayDimensions() {
        return this.arrayDimensions;
    }
}

