/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.TableField;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class StandardField
extends TableField {
    @XmlElement(name="numberOfElements")
    private int numberOfElements;
    @XmlElement(name="isEnumerate")
    private String isEnumerate;
    @XmlElement(name="referenceTable")
    private String referenceTable;
    @XmlElementWrapper(name="children")
    @XmlElement(name="field")
    private List<String> children;

    private StandardField() {
    }

    public StandardField(String name, String description) {
        super(name, description);
    }

    public String getDescription() {
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            String desc = "";
            for (String child : this.getChildren()) {
                if (!desc.isEmpty()) {
                    desc = desc + ", ";
                }
                desc = desc + this.getTable().getStandardField(child).getDescription();
            }
            return desc;
        }
        return super.getDescription();
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public boolean isRepeatingField() {
        return this.getNumberOfElements() > 1;
    }

    public boolean isEnumerate() {
        return this.isEnumerate != null && this.isEnumerate.equals("1");
    }

    public String getReferenceTable() {
        return this.referenceTable;
    }

    public List<String> getChildren() {
        return this.children;
    }
}

