/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.StackFrame;
import com.infor.ln.dbg.wb.shared.ValueArray;
import com.infor.ln.dbg.wb.shared.ValueComposed;
import com.infor.ln.dbg.wb.shared.Variable;
import com.infor.ln.dbg.wb.shared.VariableValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

/*
 * Exception performing whole class analysis ignored.
 */
public class StackFrame
implements Serializable {
    @XmlAttribute(name="name")
    private String functionName;
    @XmlAttribute(name="object")
    private String objectName;
    @XmlAttribute(name="sourcefile")
    private String source = "";
    @XmlAttribute(name="line")
    private int lineNumber;
    @XmlElement(name="argument")
    private List<Argument> arguments = new ArrayList();
    @XmlTransient
    private List<Variable> variables;
    @XmlTransient
    private Map<String, VariableValue> variableValues = new HashMap();

    public String getFunctionName() {
        return this.functionName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public VariableValue getVariableValue(String variableName) {
        return (VariableValue)this.variableValues.get(variableName);
    }

    public void setVariableValue(String variableName, VariableValue variableValue) {
        this.variableValues.replace(variableName, variableValue);
    }

    public void addVariableValue(String variableName, VariableValue variableValue) {
        this.variableValues.put(variableName, variableValue);
    }

    public void addVariableValueForArray(String variableName, Variable variable) {
        StringBuilder sb = new StringBuilder();
        if (variable.getValue() instanceof ValueArray) {
            List elements = ((ValueArray)variable.getValue()).getVariables();
            for (int ielem = 0; ielem < elements.size(); ++ielem) {
                Variable elem = (Variable)elements.get(ielem);
                sb.append('[');
                sb.append(ielem + 1);
                sb.append("] [");
                sb.append(elem.getValue().getValue());
                sb.append("]\n");
                for (Variable vle : ((ValueComposed)elem.getValue()).getVariables()) {
                    if (!vle.getType().equals("ml string")) continue;
                    sb.append("    " + vle.getLanguage() + " : \"" + vle.getValue().getValue() + "\"\n");
                }
            }
        }
        VariableValue varVal = new VariableValue("array", sb.toString());
        this.addVariableValue(variableName, varVal);
    }

    public String getArgumentsAsString() {
        StringBuilder s = new StringBuilder();
        for (Argument argument : this.arguments) {
            if (s.length() != 0) {
                s.append(",");
            }
            if (Argument.access$000((Argument)argument) != null) {
                s.append(Argument.access$000((Argument)argument)).append("=");
            }
            if (Argument.access$100((Argument)argument) == null) continue;
            s.append(Argument.access$100((Argument)argument));
        }
        return s.toString();
    }

    public Variable findVariable(String variableName) {
        String varName = variableName;
        for (int iloop = 0; iloop < 2; ++iloop) {
            for (Variable var : this.getVariables()) {
                if (!varName.equals(var.getName())) continue;
                return var;
            }
            varName = this.getFunctionName() + "." + variableName;
        }
        return null;
    }
}

