/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.Breakpoint;
import com.infor.ln.dbg.wb.shared.LNSourceTypes;
import javax.xml.bind.annotation.XmlElement;

public final class LineBreakpoint
extends Breakpoint {
    @XmlElement(name="line")
    private int lineNumber;

    private LineBreakpoint() {
    }

    public LineBreakpoint(String scriptName, LNSourceTypes sourceType, int lineNumber) {
        super(scriptName, sourceType);
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getClassName() {
        return "line_breakpoint";
    }

    public String getDescription() {
        String scriptName = super.getDescription();
        return scriptName + " [line: " + this.lineNumber + "]";
    }

    public int hashCode() {
        return this.getScriptName().hashCode() + this.lineNumber;
    }

    public boolean equals(Object o) {
        return o instanceof LineBreakpoint && ((LineBreakpoint)o).getScriptName().equals(this.getScriptName()) && ((LineBreakpoint)o).getLineNumber() == this.lineNumber;
    }

    public int compareTo(Breakpoint other) {
        if (!this.getScriptName().equals(other.getScriptName())) {
            return this.getScriptName().compareTo(other.getScriptName());
        }
        if (other instanceof LineBreakpoint) {
            return this.lineNumber - ((LineBreakpoint)other).getLineNumber();
        }
        return -1;
    }
}

