/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.Breakpoint;
import com.infor.ln.dbg.wb.shared.LNSourceTypes;
import com.infor.ln.dbg.wb.shared.LineBreakpoint;
import javax.xml.bind.annotation.XmlElement;

public final class FunctionBreakpoint
extends Breakpoint {
    @XmlElement(name="function")
    private String functionName;
    @XmlElement(name="line")
    private int lineNumber;

    private FunctionBreakpoint() {
    }

    public FunctionBreakpoint(String scriptName, LNSourceTypes sourceType, String functionName, int lineNumber) {
        super(scriptName, sourceType);
        this.functionName = functionName;
        this.lineNumber = lineNumber;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getClassName() {
        return "function_breakpoint";
    }

    public String getDescription() {
        String scriptName = super.getDescription();
        return scriptName + " [function] - " + this.functionName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        return this.getScriptName().hashCode() + this.functionName.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof FunctionBreakpoint && ((FunctionBreakpoint)o).getScriptName().equals(this.getScriptName()) && ((FunctionBreakpoint)o).getFunctionName().equals(this.functionName);
    }

    public int compareTo(Breakpoint other) {
        if (!this.getScriptName().equals(other.getScriptName())) {
            return this.getScriptName().compareTo(other.getScriptName());
        }
        if (other instanceof FunctionBreakpoint) {
            return this.functionName.compareTo(((FunctionBreakpoint)other).getFunctionName());
        }
        if (other instanceof LineBreakpoint) {
            return 1;
        }
        return -1;
    }
}

