/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.Breakpoint;
import com.infor.ln.dbg.wb.shared.DebugModel;
import com.infor.ln.dbg.wb.shared.FunctionBreakpoint;
import com.infor.ln.dbg.wb.shared.LineBreakpoint;
import com.infor.ln.dbg.wb.shared.WatchExpression;
import com.infor.ln.dbg.wb.shared.Watchpoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;

public class DebugModel
implements Serializable {
    @XmlElementWrapper(name="editors")
    @XmlElement(name="editor")
    private List<Editor> editors = new ArrayList();
    @XmlElementWrapper(name="breakpoints")
    @XmlElements(value={@XmlElement(name="lineBreakpoint", type=LineBreakpoint.class), @XmlElement(name="functionBreakpoint", type=FunctionBreakpoint.class), @XmlElement(name="watchpoint", type=Watchpoint.class)})
    private List<Breakpoint> breakpoints = new ArrayList();
    @XmlElementWrapper(name="expressions")
    @XmlElement(name="watchExpression")
    private List<WatchExpression> expressions = new ArrayList();
    @XmlElement(name="skipAllBreakpoints")
    private boolean skipAllBreakpoints;
    @XmlElement(name="configuration")
    private Configuration config = new Configuration();
    @XmlElement(name="dbgModelVersion")
    private int dbgModelVersion;

    public List<Editor> getEditors() {
        return this.editors;
    }

    public List<Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.add(breakpoint);
        Collections.sort(this.breakpoints);
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        this.breakpoints.remove(breakpoint);
    }

    public boolean getSkipAllBreakpoints() {
        return this.skipAllBreakpoints;
    }

    public void setSkipAllBreakpoints(boolean skipAllBreakpoints) {
        this.skipAllBreakpoints = skipAllBreakpoints;
    }

    public List<WatchExpression> getExpressions() {
        return this.expressions;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public int getDbgModelVersion() {
        return this.dbgModelVersion;
    }

    public void setDbgModelVersion(int dbgModelVersion) {
        this.dbgModelVersion = dbgModelVersion;
    }
}

