/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.shared;

import com.infor.ln.dbg.wb.shared.LNSourceTypes;
import com.infor.ln.dbg.wb.shared.Utils;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;

public abstract class Breakpoint
implements Serializable,
Comparable<Breakpoint> {
    public static final String HTMLCLASS_DISABLED = "breakpoint_disabled";
    public static final String HTMLCLASS_SKIPPED = "breakpoint_skipped";
    public static final String HTMLCLASS_INVALID = "breakpoint_invalid";
    @XmlElement(name="script")
    private String scriptName = "";
    @XmlElement(name="enabled")
    private boolean enabled = true;
    @XmlElement(name="sourceType")
    private LNSourceTypes sourceType;

    protected Breakpoint() {
    }

    public Breakpoint(String scriptName, LNSourceTypes sourceType) {
        this.scriptName = scriptName;
        this.sourceType = sourceType;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public LNSourceTypes getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(LNSourceTypes sourceType) {
        this.sourceType = sourceType;
    }

    public abstract int getLineNumber();

    public abstract String getClassName();

    public String getDescription() {
        String[] result;
        String script = this.getScriptName();
        if (script != null && !(result = Utils.splitPath((String)script))[0].isEmpty()) {
            script = result[0];
        }
        return script + this.getSourceType().getScriptExtension();
    }
}

