/*
 * Decompiled with CFR 0.152.
 */
package com.infor.ln.dbg.wb.server.rpc;

import com.google.gwt.thirdparty.guava.common.io.BaseEncoding;
import com.infor.erpln.jca.ConnectionFactoryImpl;
import com.infor.erpln.jca.ConnectionSpecImpl;
import com.infor.erpln.jca.MessageOption;
import com.infor.erpln.jca.dllclient.BaanDLLCall;
import com.infor.erpln.jca.dllclient.Parameter;
import com.infor.ln.dbg.wb.server.InputParam;
import com.infor.ln.dbg.wb.server.JAXBUtils;
import com.infor.ln.dbg.wb.server.rpc.DataService;
import com.infor.ln.dbg.wb.shared.ArrayElement;
import com.infor.ln.dbg.wb.shared.DebugModel;
import com.infor.ln.dbg.wb.shared.GetBrowseListRequest;
import com.infor.ln.dbg.wb.shared.LNSourceTypes;
import com.infor.ln.dbg.wb.shared.ResponseResult;
import com.infor.ln.dbg.wb.shared.ResponseStatus;
import com.infor.ln.dbg.wb.shared.Script;
import com.infor.ln.dbg.wb.shared.Utils;
import com.infor.ln.dbg.wb.shared.VariableInputValue;
import com.infor.ln.dbg.wb.shared.rpc.IDataService;
import com.infor.ln.workbench.server.rpc.BaseService;
import com.infor.ln.workbench.server.web.WorkbenchState;
import com.infor.ln.workbench.shared.rpc.ServerRPCException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionSpec;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataService
extends BaseService
implements IDataService {
    private static final String IDE_DLL = "ottidereqhand";
    private static final String IDE_METHOD = "RequestHandler.Execute";
    private static final String TESTDEBUGMODEL = "testDebugModel";
    private static final String TESTSYMBOLS = "testSymbols";
    private static final String TESTSCRIPTDIR = "testScriptDir";
    private static final String TESTINPUTREQUEST = "testInputRequest";
    private static final String TESTINPUTRESPONSE = "testInputResponse";
    private static final String TESTDOCUMENT = "testDocument";
    private static final String TESTDEBUGEVENTS = "testDebugEvents";
    private static final String GET_DEBUG_MODEL = "GetDebugModel";
    private static final String SET_DEBUG_MODEL = "SetDebugModel";
    private static final String GET_SCRIPT = "GetScript";
    private static final String GET_LIBRARY = "GetLibrary";
    private static final String GET_FUNCTION = "GetFunction";
    private static final String GET_REPORT = "GetReport";
    private static final String GET_EXCHANGE_BATCH = "GetExchangeBatch";
    private static final String GET_REPORT_RULE = "GetReportRule";
    private static final String GET_DOCUMENT_TYPE = "GetDocumentType";
    private static final String GET_REPORT_DBG = "GetReportDbg";
    private static final String GET_SOURCE_INFO = "GetSourceInfo";
    private static final String GET_OBJ_INFO = "GetObjInfo";
    private static final String GET_PACKAGES = "GetPackages";
    private static final String GET_BROWSE_LIST = "GetBrowseList";
    private static final String STEP_INTO = "ProcessStep";
    private static final String STEP_OVER = "ProcessNext";
    private static final String STEP_RETURN = "ProcessReturn";
    private static final String PROCESS_BREAK = "ProcessBreak";
    private static final String PROCESS_CONTINUE = "ProcessContinue";
    private static final String PROCESS_KILL = "ProcessKill";
    private static final String PROCESS_REMOVE = "ProcessRemove";
    private static final String PROCESS_GOTO = "ProcessGoto";
    private static final String PROCESS_INFO = "ProcessInfo";
    private static final String FUNCTIONBREAK_SET = "FunctionBreakSet";
    private static final String FUNCTIONBREAK_DELETE = "FunctionBreakDelete";
    private static final String LINEBREAK_SET = "LineBreakSet";
    private static final String LINEBREAK_DELETE = "LineBreakDelete";
    private static final String LINEBREAK_TOGGLE = "LineBreakToggle";
    private static final String TRACE_SET = "TraceSet";
    private static final String TRACE_DELETE = "TraceDelete";
    private static final String TRACE_DELETE_ALL = "TraceDeleteAll";
    private static final String EXPRESSION_SET = "ExpressionSet";
    private static final String EXPRESSION_DELETE = "ExpressionDelete";
    private static final String EXPRESSION_DELETE_ALL = "ExpressionDeleteAll";
    private static final String VARIABLE_GET = "VariableGet";
    private static final String VARIABLE_PUT = "VariablePut";
    private static final String SYMBOLS_GET = "SymbolsGet";
    private static final String EXPRESSION_VALUE_GET = "ExpressionValueGet";
    private static final String ARRAY_VALUES_GET = "ArrayValuesGet";
    private static final String ARRAY_VALUE_PUT = "ArrayValuePut";
    private static final String DEBUG_EVENTS_DLL = "ottidedbgevents";
    private static final String DEBUG_EVENTS_GET = "getDebugEvents";
    private static final String DEBUG_EVENTS_STOP = "stopDebugEvents";
    private static final Logger LOG = ESAPI.getLogger(DataService.class);
    private static final String STATE_KEY_DEFAULT_BACKEND = "defaultBackendID";
    private static final String STATE_KEY_CONNECTIONS = "connections";
    private static final String DEBUGLEVEL_APP = "LNApplicationDebug";
    private static final String DEBUGLEVEL_TLS = "LNToolsDebug";
    private static final String DEBUGLEVEL_4GL = "LN4GLEngineDebug";
    private static final int DEBUGLEVEL_APP_VAL = 10;
    private static final int DEBUGLEVEL_TLS_VAL = 20;
    private static final int DEBUGLEVEL_4GL_VAL = 30;
    private static final ConnectionFactoryImpl CONNECTION_FACTORY = new ConnectionFactoryImpl();

    public ResponseResult getDebugModel(String connectionId) throws ServerRPCException {
        String testDebugModel = System.getProperty(TESTDEBUGMODEL);
        if (testDebugModel != null && !testDebugModel.isEmpty()) {
            try {
                File fXmlFile = new File(testDebugModel);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                return (ResponseResult)JAXBUtils.createObjectFromNode((Node)doc.getFirstChild(), ResponseResult.class);
            }
            catch (Exception e) {
                throw this.convertToServerRPCException(e);
            }
        }
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setAction(GET_DEBUG_MODEL);
        ResponseResult output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input);
        return output;
    }

    public ResponseResult saveDebugModel(String connectionId, DebugModel debugModel) throws ServerRPCException {
        String testDebugModel = System.getProperty(TESTDEBUGMODEL);
        if (testDebugModel != null && !testDebugModel.isEmpty()) {
            try {
                ResponseResult output = new ResponseResult();
                output.setDebugModel(debugModel);
                File fXmlFile = new File(testDebugModel);
                Transformer t = TransformerFactory.newInstance().newTransformer();
                t.setOutputProperty("indent", "yes");
                t.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                t.transform(new DOMSource(JAXBUtils.createNodeFromObject((Object)output)), new StreamResult(fXmlFile));
                output.setStatus(ResponseStatus.OK);
                return output;
            }
            catch (Exception e) {
                throw this.convertToServerRPCException(e);
            }
        }
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setAction(SET_DEBUG_MODEL);
        input.setDebugModel(debugModel);
        ResponseResult output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input);
        return output;
    }

    public ResponseResult getMaxDebugLevel(String connectionId) throws ServerRPCException {
        ResponseResult output = new ResponseResult();
        int maxDebugLevel = 0;
        WorkbenchState state = this.getWorkbenchState(connectionId);
        if (state.getAuthState().isAuthenticated()) {
            if (state.isAuthorizedFor(DEBUGLEVEL_4GL)) {
                maxDebugLevel = 30;
            } else if (state.isAuthorizedFor(DEBUGLEVEL_TLS)) {
                maxDebugLevel = 20;
            } else if (state.isAuthorizedFor(DEBUGLEVEL_APP)) {
                maxDebugLevel = 10;
            }
        }
        output.setMaxDebugLevel(maxDebugLevel);
        return output;
    }

    public ResponseResult getScript(String connectionId, String processId, String scriptName, String objectName, String currDbgLevel, LNSourceTypes type, String checkNeeded, String checkOnly) throws ServerRPCException {
        ResponseResult output;
        Script scrpt;
        WorkbenchState state = this.getWorkbenchState(connectionId);
        try {
            File fXmlFile;
            String testScriptDir = System.getProperty(TESTSCRIPTDIR);
            if (testScriptDir != null && !testScriptDir.isEmpty() && (fXmlFile = new File(new File(testScriptDir), scriptName + ".xml")).exists()) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                return (ResponseResult)JAXBUtils.createObjectFromNode((Node)doc.getFirstChild(), ResponseResult.class);
            }
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setComponentName(scriptName);
        input.setObjectName(objectName);
        input.setProcessID(processId);
        switch (1.$SwitchMap$com$infor$ln$dbg$wb$shared$LNSourceTypes[type.ordinal()]) {
            case 1: {
                input.setAction(GET_FUNCTION);
                break;
            }
            case 2: {
                input.setAction(GET_REPORT);
                break;
            }
            case 3: {
                input.setAction(GET_SCRIPT);
                break;
            }
            case 4: {
                input.setAction(GET_EXCHANGE_BATCH);
                break;
            }
            case 5: {
                input.setAction(GET_REPORT_RULE);
                break;
            }
            case 6: {
                input.setAction(GET_DOCUMENT_TYPE);
                break;
            }
            case 7: {
                input.setAction(GET_REPORT_DBG);
                break;
            }
            default: {
                input.setAction(GET_LIBRARY);
            }
        }
        input.setCheckNeeded(checkNeeded);
        input.setCheckOnly(checkOnly);
        input.setCurrDbgLevel(currDbgLevel);
        if (!checkNeeded.equals("yes") && !checkOnly.equals("yes")) {
            String pack = Utils.getPackageFromScriptName((String)scriptName, (LNSourceTypes)type);
            if (!(state.getAuthState().isAuthenticated() || pack.equals("tx") || type.getAuthorized())) {
                ServerRPCException e = new ServerRPCException("Not authorized");
                throw e;
            }
            input.setCurrDbgLevel(currDbgLevel);
        }
        if ((scrpt = (output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input, EnumSet.of(MessageOption.HIDE_RESPONSE_LOG))).getScript()) != null && scrpt.getCompressed().equalsIgnoreCase("true")) {
            String seq = scrpt.getSource();
            byte[] sourceDecode = BaseEncoding.base64().decode((CharSequence)seq);
            String uncompressedSource = this.decompressGzip(sourceDecode);
            scrpt.setSource(uncompressedSource);
        }
        return output;
    }

    private String decompressGzip(byte[] sourceDecode) throws ServerRPCException {
        StringBuffer uncompressedSource = new StringBuffer();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(sourceDecode);
            GZIPInputStream zipInputStream = new GZIPInputStream(inputStream);
            BufferedReader br = new BufferedReader(new InputStreamReader(zipInputStream));
            String line = null;
            while ((line = br.readLine()) != null) {
                uncompressedSource.append(line);
                uncompressedSource.append("\r");
            }
        }
        catch (FileNotFoundException e) {
            throw this.convertToServerRPCException((Exception)e);
        }
        catch (IOException e) {
            throw this.convertToServerRPCException((Exception)e);
        }
        return uncompressedSource.toString();
    }

    public ResponseResult getSourceInfo(String connectionId, String processId, String scriptName) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setComponentName(scriptName);
        input.setAction(GET_SOURCE_INFO);
        ResponseResult output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input);
        return output;
    }

    public ResponseResult getObjInfo(String connectionId, String scriptName, String objectName, LNSourceTypes type) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setComponentName(scriptName);
        input.setObjectName(objectName);
        switch (1.$SwitchMap$com$infor$ln$dbg$wb$shared$LNSourceTypes[type.ordinal()]) {
            case 2: {
                input.setSourceType(GET_REPORT);
                break;
            }
            case 3: {
                input.setSourceType(GET_SCRIPT);
                break;
            }
            case 7: {
                input.setSourceType(GET_REPORT_DBG);
                break;
            }
            default: {
                input.setSourceType(GET_LIBRARY);
            }
        }
        input.setAction(GET_OBJ_INFO);
        ResponseResult output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input);
        return output;
    }

    public ResponseResult getPackages(String connectionId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setAction(GET_PACKAGES);
        ResponseResult output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input);
        return output;
    }

    public ResponseResult getBrowseListRequest(String connectionId, GetBrowseListRequest brwLstReq) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setBrowseListRequest(brwLstReq);
        input.setAction(GET_BROWSE_LIST);
        ResponseResult output = this.getOutput(connectionId, this.getDefaultBackendId(connectionId), input);
        return output;
    }

    public ResponseResult stepInto(String connectionId, String backendId, String processId, String lineCount) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setLineCount(lineCount);
        input.setAction(STEP_INTO);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult stepOver(String connectionId, String backendId, String processId, String lineCount) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setLineCount(lineCount);
        input.setAction(STEP_OVER);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult stepReturn(String connectionId, String backendId, String processId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setAction(STEP_RETURN);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult runToLine(String connectionId, String backendId, String processId, String fileName, String lineNumber) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFileName(fileName);
        input.setAction(PROCESS_GOTO);
        input.setLineNumber(lineNumber);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult processBreak(String connectionId, String backendId, String processId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setAction(PROCESS_BREAK);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult processContinue(String connectionId, String backendId, String processId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setAction(PROCESS_CONTINUE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult processKill(String connectionId, String backendId, String processId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setAction(PROCESS_KILL);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult processRemove(String connectionId, String backendId, String sessionId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setSessionID(sessionId);
        input.setAction(PROCESS_REMOVE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult processInfo(String connectionId, String backendId, String processId, int infoFlag) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setInfoFlag("" + infoFlag);
        input.setObjectInProcessID("0");
        input.setFunctionID("0");
        input.setInternalSymbolName("");
        input.setExternalSymbolName("");
        input.setStackDepth("0");
        input.setFileName("");
        input.setFunctionbreakID("0");
        input.setExpressionID("0");
        input.setTraceID("0");
        input.setAction(PROCESS_INFO);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult functionBreakSet(String connectionId, String backendId, String processId, String functionName) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFunctionName(functionName);
        input.setAction(FUNCTIONBREAK_SET);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult functionBreakDelete(String connectionId, String backendId, String processId, String functionName) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFunctionName(functionName);
        input.setAction(FUNCTIONBREAK_DELETE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult lineBreakSet(String connectionId, String backendId, String processId, String fileName, String lineNumber) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFileName(fileName);
        input.setLineNumber(lineNumber);
        input.setAction(LINEBREAK_SET);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult lineBreakDelete(String connectionId, String backendId, String processId, String fileName, String lineNumber) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFileName(fileName);
        input.setLineNumber(lineNumber);
        input.setAction(LINEBREAK_DELETE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult lineBreakToggle(String connectionId, String backendId, String processId, String functionName, String lineNumber) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFunctionName(functionName);
        input.setLineNumber(lineNumber);
        input.setAction(LINEBREAK_TOGGLE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult traceSet(String connectionId, String backendId, String processId, String fileName, String lineNumber, String variableName, String variableHalt, String variableValue) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFileName(fileName);
        input.setLineNumber(lineNumber);
        input.setVariableName(variableName);
        input.setVariableHalt(variableHalt);
        input.setValue(variableValue);
        input.setAction(TRACE_SET);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult traceDelete(String connectionId, String backendId, String processId, String fileName, String lineNumber, String variableName) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setFileName(fileName);
        input.setLineNumber(lineNumber);
        input.setVariableName(variableName);
        input.setAction(TRACE_DELETE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult traceDeleteAll(String connectionId, String backendId, String processId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setAction(TRACE_DELETE_ALL);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult expressionSet(String connectionId, String backendId, String processId, String expression) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setExpression(expression);
        input.setAction(EXPRESSION_SET);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult expressionDelete(String connectionId, String backendId, String processId, String expressionID) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setExpressionID(expressionID);
        input.setAction(EXPRESSION_DELETE);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult expressionDeleteAll(String connectionId, String backendId, String processId) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setAction(EXPRESSION_DELETE_ALL);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public ResponseResult variableGet(String connectionId, String backendId, String processId, String objectName, String functionName, String variableName) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processId);
        input.setObjectName(objectName);
        input.setFunctionName(functionName);
        input.setVariableName(variableName);
        input.setAction(VARIABLE_GET);
        ResponseResult output = this.getOutput(connectionId, backendId, input);
        return output;
    }

    public Long getToolsInterfaceVersion(String connectionId) throws ServerRPCException {
        try {
            BaanDLLCall dllcall = this.createDllCall(connectionId, this.getDefaultBackendId(connectionId));
            dllcall.setDLL("ottdlltiv");
            dllcall.setFunction("ttdlltiv.get.tools.tiv");
            dllcall.setReturnType("i8");
            dllcall.execute();
            return dllcall.getReturnLongValue();
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
    }

    public ResponseResult getDebugEvents(String connectionId) throws ServerRPCException {
        String testDebugEvents = System.getProperty(TESTDEBUGEVENTS);
        if (testDebugEvents != null && !testDebugEvents.isEmpty()) {
            try {
                File fXmlFile = new File(testDebugEvents);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                return (ResponseResult)JAXBUtils.createObjectFromNode((Node)doc.getFirstChild(), ResponseResult.class);
            }
            catch (Exception e) {
                throw this.convertToServerRPCException(e);
            }
        }
        ResponseResult output = new ResponseResult();
        try {
            output = (ResponseResult)this.executeDllMethod(connectionId, this.getDefaultBackendId(connectionId), DEBUG_EVENTS_DLL, DEBUG_EVENTS_GET, (Object)output);
            for (String backendId : this.getConnections(this.getWorkbenchState(connectionId)).keySet()) {
                ResponseResult parallelBshellOutput = (ResponseResult)this.executeDllMethod(connectionId, backendId, DEBUG_EVENTS_DLL, DEBUG_EVENTS_GET, (Object)output);
                output.getEventMessages().addAll(parallelBshellOutput.getEventMessages());
            }
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        return output;
    }

    public ResponseResult stopDebugEvents(String connectionId) throws ServerRPCException {
        ResponseResult output = new ResponseResult();
        try {
            for (String backendId : this.getConnections(this.getWorkbenchState(connectionId)).keySet()) {
                output = (ResponseResult)this.executeDllMethod(connectionId, backendId, DEBUG_EVENTS_DLL, DEBUG_EVENTS_STOP, (Object)output);
            }
            output = (ResponseResult)this.executeDllMethod(connectionId, this.getDefaultBackendId(connectionId), DEBUG_EVENTS_DLL, DEBUG_EVENTS_STOP, (Object)output);
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        return output;
    }

    public ResponseResult getSymbols(String connectionId, String backendID, String processID, String objectName, String functionName, int symbolFlag) throws ServerRPCException {
        String testSymbols = System.getProperty(TESTSYMBOLS);
        if (testSymbols != null && !testSymbols.isEmpty()) {
            try {
                File fXmlFile = new File(testSymbols);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                return (ResponseResult)JAXBUtils.createObjectFromNode((Node)doc.getFirstChild(), ResponseResult.class);
            }
            catch (Exception e) {
                throw this.convertToServerRPCException(e);
            }
        }
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setAction(SYMBOLS_GET);
        input.setProcessID(processID);
        input.setObjectName(objectName);
        input.setFunctionName(functionName);
        input.setSymbolFlag(symbolFlag);
        ResponseResult output = new ResponseResult();
        try {
            BaanDLLCall dllcall = this.createDllCall(connectionId, backendID);
            dllcall.setDLL(IDE_DLL);
            dllcall.setFunction(IDE_METHOD);
            dllcall.setReturnType("void");
            Parameter callInfoParam = new Parameter(InputParam.class.getAnnotation(XmlRootElement.class).name(), "in");
            callInfoParam.setValue((Node)JAXBUtils.createNodeFromObject((Object)input));
            Parameter callResultParam = new Parameter(ResponseResult.class.getAnnotation(XmlRootElement.class).name(), "out");
            callResultParam.setType("xmlstring");
            Parameter[] parameters = new Parameter[]{callInfoParam, callResultParam};
            dllcall.setParameters(parameters);
            dllcall.execute();
            Node resultNode = callResultParam.getXMLValue();
            NodeList valueNodes = resultNode.getOwnerDocument().getElementsByTagName("value");
            for (int i = 0; i < valueNodes.getLength(); ++i) {
                Node valueNode = valueNodes.item(i);
                Node child = valueNode.getFirstChild();
                if (child == null || child.getNodeType() != 1) continue;
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(child), new StreamResult(writer));
                valueNode.replaceChild(valueNode.getOwnerDocument().createTextNode(writer.toString().replace("\r", "")), child);
            }
            output = (ResponseResult)JAXBUtils.createObjectFromNode((Node)resultNode, ResponseResult.class);
            LOG.info(Logger.EVENT_SUCCESS, output.getStatus().toString());
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        if (output.getProcessSymbols() != null) {
            output.getProcessSymbols().determineSymbols();
        }
        return output;
    }

    public ResponseResult getExpressions(String connectionId, String backendID, String processID, String objectName, String functionName, String expression) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setAction(EXPRESSION_VALUE_GET);
        input.setProcessID(processID);
        input.setObjectName(objectName);
        input.setFunctionName(functionName);
        input.setExpression(expression);
        ResponseResult output = this.getOutput(connectionId, backendID, input);
        if (output.getExpressions() != null) {
            output.getExpressions().determineSymbols();
        }
        return output;
    }

    public ResponseResult getArrayValues(String connectionId, String backendID, String processID, String objectName, String functionName, String variableName, int[] currentIndex, int[] dimensions, int startPosition, int elementCount) throws ServerRPCException {
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setAction(ARRAY_VALUES_GET);
        input.setProcessID(processID);
        input.setObjectName(objectName);
        if (functionName != null) {
            input.setFunctionName(functionName);
        } else {
            input.setFunctionName("");
        }
        input.setVariableName(variableName);
        if (currentIndex != null) {
            if (currentIndex.length > 0) {
                input.setDimension1(String.valueOf(currentIndex[0]));
            }
            if (currentIndex.length > 1) {
                input.setDimension2(String.valueOf(currentIndex[1]));
            }
            if (currentIndex.length > 2) {
                input.setDimension3(String.valueOf(currentIndex[2]));
            }
        }
        if (dimensions != null) {
            input.setStartPosition(String.valueOf(startPosition));
            input.setElementCount(String.valueOf(elementCount));
        }
        ResponseResult output = this.getOutput(connectionId, backendID, input);
        for (ArrayElement element : output.getArrayElements()) {
            element.determine();
        }
        return output;
    }

    public ResponseResult variablePut(String connectionId, String backendID, String processID, String objectName, String functionName, String variableName, int[] currentIndex, String variableValue) throws ServerRPCException {
        String testSymbols = System.getProperty(TESTSYMBOLS);
        if (testSymbols != null && !testSymbols.isEmpty()) {
            try {
                File fXmlFile = new File(testSymbols);
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(fXmlFile);
                return (ResponseResult)JAXBUtils.createObjectFromNode((Node)doc.getFirstChild(), ResponseResult.class);
            }
            catch (Exception e) {
                throw this.convertToServerRPCException(e);
            }
        }
        InputParam input = new InputParam();
        input.setConId(connectionId);
        input.setProcessID(processID);
        if (currentIndex != null) {
            input.setAction(ARRAY_VALUE_PUT);
            if (currentIndex.length > 0) {
                input.setDimension1(String.valueOf(currentIndex[0]));
            }
            if (currentIndex.length > 1) {
                input.setDimension2(String.valueOf(currentIndex[1]));
            }
            if (currentIndex.length > 2) {
                input.setDimension3(String.valueOf(currentIndex[2]));
            }
            if (currentIndex.length > 3) {
                input.setDimension4(String.valueOf(currentIndex[3]));
            }
        } else {
            input.setAction(VARIABLE_PUT);
        }
        input.setObjectName(objectName);
        input.setFunctionName(functionName);
        input.setVariableName(variableName);
        ArrayList<VariableInputValue> inputValues = new ArrayList<VariableInputValue>();
        VariableInputValue inputValue = new VariableInputValue();
        inputValue.setValue(variableValue);
        inputValues.add(inputValue);
        input.setVariableValue(inputValues);
        ResponseResult output = this.getOutput(connectionId, backendID, input);
        return output;
    }

    private ResponseResult getOutput(String connectionId, String backendId, InputParam input) throws ServerRPCException {
        return this.getOutput(connectionId, backendId, input, null);
    }

    private ResponseResult getOutput(String connectionId, String backendId, InputParam input, EnumSet<MessageOption> skipTracingOptions) throws ServerRPCException {
        ResponseResult output = new ResponseResult();
        try {
            output = (ResponseResult)this.executeDllMethod(connectionId, backendId, IDE_DLL, IDE_METHOD, (Object)input, (Object)output, skipTracingOptions);
            LOG.info(Logger.EVENT_SUCCESS, output.getStatus().toString());
        }
        catch (Exception e) {
            throw this.convertToServerRPCException(e);
        }
        return output;
    }

    public ResponseResult setDefaultBackendID(String connectionId, String backendID) throws ServerRPCException {
        LOG.info(Logger.EVENT_SUCCESS, String.format("setDefaultBackendID(connectionId='%s', backendId='%s')", connectionId, backendID));
        this.getWorkbenchState(connectionId).setAttribute(STATE_KEY_DEFAULT_BACKEND, (Object)backendID);
        return new ResponseResult();
    }

    public ResponseResult openBackendConnection(String connectionId, String backendID, String hostName, String portNumber) throws ServerRPCException {
        LOG.info(Logger.EVENT_SUCCESS, String.format("openBackendConnection(connectionId='%s', backendId='%s')", connectionId, backendID));
        ConnectionSpecImpl spec = new ConnectionSpecImpl(hostName, "socket_out", Integer.parseInt(portNumber), "", "", "", "", -1);
        spec.setMaxConnections(1);
        spec.setMaxReferences(-1);
        try {
            Connection conn = CONNECTION_FACTORY.getConnection((ConnectionSpec)spec);
            this.addConnection(connectionId, backendID, conn);
        }
        catch (ResourceException e) {
            throw this.convertToServerRPCException((Exception)((Object)e));
        }
        ResponseResult output = new ResponseResult();
        return output;
    }

    public ResponseResult closeBackendConnection(String connectionId, String backendID) throws ServerRPCException {
        LOG.info(Logger.EVENT_SUCCESS, String.format("closeBackendConnection(connectionId='%s', backendId='%s')", connectionId, backendID));
        Connection conn = this.removeConnection(connectionId, backendID);
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (ResourceException e) {
            throw this.convertToServerRPCException((Exception)((Object)e));
        }
        ResponseResult output = new ResponseResult();
        return output;
    }

    public <I, O> O executeDllMethod(String connectionId, String backendId, String dll, String function, I input, O output, EnumSet<MessageOption> skipTracingOptions) throws Exception {
        BaanDLLCall dllcall = this.createDllCall(connectionId, backendId);
        dllcall.setDLL(dll);
        dllcall.setFunction(function);
        dllcall.setReturnType("void");
        Class<?> outputType = output.getClass();
        XmlRootElement outputRootElement = outputType.getAnnotation(XmlRootElement.class);
        assert (outputRootElement != null);
        String outputParameterName = outputRootElement.name();
        Class<?> inputType = input.getClass();
        XmlRootElement inputRootElement = inputType.getAnnotation(XmlRootElement.class);
        assert (inputRootElement != null);
        String inputParameterName = inputRootElement.name();
        Parameter callInfoParam = new Parameter(inputParameterName, "in");
        callInfoParam.setValue((Node)JAXBUtils.createNodeFromObject(input));
        Parameter callResultParam = new Parameter(outputParameterName, "out");
        callResultParam.setType("xmlstring");
        Parameter[] parameters = new Parameter[]{callInfoParam, callResultParam};
        dllcall.setParameters(parameters);
        if (null == skipTracingOptions) {
            dllcall.execute();
        } else {
            dllcall.execute(skipTracingOptions);
        }
        Node resultNode = callResultParam.getXMLValue();
        return (O)JAXBUtils.createObjectFromNode((Node)resultNode, outputType);
    }

    public <O> O executeDllMethod(String connectionId, String backendId, String dll, String function, O output) throws Exception {
        BaanDLLCall dllcall = this.createDllCall(connectionId, backendId);
        dllcall.setDLL(dll);
        dllcall.setFunction(function);
        dllcall.setReturnType("void");
        Class<?> outputType = output.getClass();
        XmlRootElement outputRootElement = outputType.getAnnotation(XmlRootElement.class);
        assert (outputRootElement != null);
        String outputParameterName = outputRootElement.name();
        Parameter callResultParam = new Parameter(outputParameterName, "out");
        callResultParam.setType("xmlstring");
        Parameter[] parameters = new Parameter[]{callResultParam};
        dllcall.setParameters(parameters);
        dllcall.execute();
        Node resultNode = callResultParam.getXMLValue();
        return (O)JAXBUtils.createObjectFromNode((Node)resultNode, outputType);
    }

    private BaanDLLCall createDllCall(String connectionId, String backendId) throws Exception {
        if (backendId.equals(this.getDefaultBackendId(connectionId))) {
            return this.getWorkbenchState(connectionId).createBaanDllCall();
        }
        Connection conn = this.getConnection(connectionId, backendId);
        if (conn != null) {
            BaanDLLCall dllcall = new BaanDLLCall();
            dllcall.attachConnection(conn);
            return dllcall;
        }
        throw new Exception("Backend " + backendId + " is unknown.");
    }

    private String getDefaultBackendId(String connectionId) {
        String id = (String)this.getWorkbenchState(connectionId).getAttribute(STATE_KEY_DEFAULT_BACKEND);
        return id == null ? "" : id;
    }

    private Map<String, Connection> getConnections(WorkbenchState state) {
        HashMap conns = (HashMap)state.getAttribute(STATE_KEY_CONNECTIONS);
        if (conns == null) {
            conns = new HashMap();
            state.setAttribute(STATE_KEY_CONNECTIONS, conns);
        }
        return conns;
    }

    private Connection getConnection(String connectionId, String backendId) {
        return (Connection)this.getConnections(this.getWorkbenchState(connectionId)).get(backendId);
    }

    private Connection removeConnection(String connectionId, String backendId) {
        return (Connection)this.getConnections(this.getWorkbenchState(connectionId)).remove(backendId);
    }

    private void addConnection(String connectionId, String backendId, Connection conn) {
        this.getConnections(this.getWorkbenchState(connectionId)).put(backendId, conn);
    }
}

