/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.jsoup.nodes;

import com.itextpdf.styledxmlparser.jsoup.SerializationException;
import com.itextpdf.styledxmlparser.jsoup.helper.StringUtil;
import com.itextpdf.styledxmlparser.jsoup.nodes.Document;
import com.itextpdf.styledxmlparser.jsoup.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;

public class Entities {
    private static final Map<String, Character> full;
    private static final Map<Character, String> xhtmlByVal;
    private static final Map<String, Character> base;
    private static final Map<Character, String> baseByVal;
    private static final Map<Character, String> fullByVal;
    private static final Object[][] xhtmlArray;

    private Entities() {
    }

    public static boolean isNamedEntity(String name) {
        return full.containsKey(name);
    }

    public static boolean isBaseNamedEntity(String name) {
        return base.containsKey(name);
    }

    public static Character getCharacterByName(String name) {
        return full.get(name);
    }

    static String escape(String string, Document.OutputSettings out) {
        StringBuilder accum = new StringBuilder(string.length() * 2);
        try {
            Entities.escape(accum, string, out, false, false, false);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return accum.toString();
    }

    static void escape(Appendable accum, String str, Document.OutputSettings outputSettings, boolean inAttribute, boolean normaliseWhite, boolean stripLeadingWhite) throws IOException {
        int codePoint;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        EscapeMode escapeMode = outputSettings.escapeMode();
        CharsetEncoder encoder = outputSettings.encoder();
        CoreCharset coreCharset = Entities.getCoreCharsetByName(outputSettings.charset().name());
        Map<Character, String> map = escapeMode.getMap();
        int length = str.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(offset);
            if (normaliseWhite) {
                if (StringUtil.isWhitespace(codePoint)) {
                    if (stripLeadingWhite && !reachedNonWhite || lastWasWhite) continue;
                    accum.append(' ');
                    lastWasWhite = true;
                    continue;
                }
                lastWasWhite = false;
                reachedNonWhite = true;
            }
            if (codePoint < 65536) {
                char c = (char)codePoint;
                switch (c) {
                    case '&': {
                        accum.append("&amp;");
                        break;
                    }
                    case '\u00a0': {
                        if (escapeMode != EscapeMode.xhtml) {
                            accum.append("&nbsp;");
                            break;
                        }
                        accum.append("&#xa0;");
                        break;
                    }
                    case '<': {
                        if (!inAttribute || escapeMode == EscapeMode.xhtml) {
                            accum.append("&lt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '>': {
                        if (!inAttribute) {
                            accum.append("&gt;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    case '\"': {
                        if (inAttribute) {
                            accum.append("&quot;");
                            break;
                        }
                        accum.append(c);
                        break;
                    }
                    default: {
                        if (Entities.canEncode(coreCharset, c, encoder)) {
                            accum.append(c);
                            break;
                        }
                        if (map.containsKey(Character.valueOf(c))) {
                            accum.append('&').append(map.get(Character.valueOf(c))).append(';');
                            break;
                        }
                        accum.append("&#x").append(Integer.toHexString(codePoint)).append(';');
                        break;
                    }
                }
                continue;
            }
            String c = new String(Character.toChars(codePoint));
            if (encoder.canEncode(c)) {
                accum.append(c);
                continue;
            }
            accum.append("&#x").append(Integer.toHexString(codePoint)).append(';');
        }
    }

    static String unescape(String string) {
        return Entities.unescape(string, false);
    }

    static String unescape(String string, boolean strict) {
        return Parser.unescapeEntities(string, strict);
    }

    private static boolean canEncode(CoreCharset charset, char c, CharsetEncoder fallback) {
        switch (charset) {
            case ascii: {
                return c < '\u0080';
            }
            case utf: {
                return true;
            }
        }
        return fallback.canEncode(c);
    }

    private static CoreCharset getCoreCharsetByName(String name) {
        if (name.equals("US-ASCII")) {
            return CoreCharset.ascii;
        }
        if (name.startsWith("UTF-")) {
            return CoreCharset.utf;
        }
        return CoreCharset.fallback;
    }

    private static Map<String, Character> loadEntities(String filename) {
        Properties properties = new Properties();
        HashMap<String, Character> entities = new HashMap<String, Character>();
        try {
            InputStream in = Entities.class.getResourceAsStream(filename);
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new MissingResourceException("Error loading entities resource: " + e.getMessage(), "Entities", filename);
        }
        for (Object name : properties.keySet()) {
            Character val = Character.valueOf((char)Integer.parseInt(properties.getProperty((String)name), 16));
            entities.put((String)name, val);
        }
        return entities;
    }

    private static Map<Character, String> toCharacterKey(Map<String, Character> inMap) {
        HashMap<Character, String> outMap = new HashMap<Character, String>();
        for (Map.Entry<String, Character> entry : inMap.entrySet()) {
            char character = entry.getValue().charValue();
            String name = entry.getKey();
            if (outMap.containsKey(Character.valueOf(character))) {
                if (!name.toLowerCase().equals(name)) continue;
                outMap.put(Character.valueOf(character), name);
                continue;
            }
            outMap.put(Character.valueOf(character), name);
        }
        return outMap;
    }

    static /* synthetic */ Map access$000() {
        return xhtmlByVal;
    }

    static /* synthetic */ Map access$100() {
        return baseByVal;
    }

    static /* synthetic */ Map access$200() {
        return fullByVal;
    }

    static {
        xhtmlArray = new Object[][]{{"quot", 34}, {"amp", 38}, {"lt", 60}, {"gt", 62}};
        xhtmlByVal = new HashMap<Character, String>();
        base = Entities.loadEntities("entities-base.properties");
        baseByVal = Entities.toCharacterKey(base);
        full = Entities.loadEntities("entities-full.properties");
        fullByVal = Entities.toCharacterKey(full);
        for (Object[] entity : xhtmlArray) {
            char c = (char)((Integer)entity[1]).intValue();
            xhtmlByVal.put(Character.valueOf(c), (String)entity[0]);
        }
    }

    private static enum CoreCharset {
        ascii,
        utf,
        fallback;

    }

    public static class EscapeMode {
        public static final EscapeMode xhtml = new EscapeMode(Entities.access$000(), "xhtml");
        public static final EscapeMode base = new EscapeMode(Entities.access$100(), "base");
        public static final EscapeMode extended = new EscapeMode(Entities.access$200(), "extended");
        private static Map<String, EscapeMode> nameValueMap = new HashMap<String, EscapeMode>();
        private Map<Character, String> map;
        private String name;

        public static EscapeMode valueOf(String name) {
            return nameValueMap.get(name);
        }

        private EscapeMode(Map<Character, String> map, String name) {
            this.map = map;
            this.name = name;
        }

        public Map<Character, String> getMap() {
            return this.map;
        }

        public String name() {
            return this.name;
        }

        static {
            nameValueMap.put(EscapeMode.xhtml.name, xhtml);
            nameValueMap.put(EscapeMode.base.name, base);
            nameValueMap.put(EscapeMode.extended.name, extended);
        }
    }
}

