/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.ordering.thai;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.TrueTypeFont;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.typography.ordering.thai.ThaiAboveStateMachineEdge;
import com.itextpdf.typography.ordering.thai.ThaiBelowStateMachineEdge;
import com.itextpdf.typography.ordering.thai.ThaiCluster;
import com.itextpdf.typography.ordering.thai.ThaiPuaMapping;
import com.itextpdf.typography.ordering.thai.ThaiUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class ThaiShaper {
    private static final String SARA_AM = "\u0e33";
    private static final ThaiPuaMapping[] SD_MAPPINGS = new ThaiPuaMapping[]{new ThaiPuaMapping(3656, 63242, 63627), new ThaiPuaMapping(3657, 63243, 63630), new ThaiPuaMapping(3658, 63244, 63633), new ThaiPuaMapping(3659, 63245, 63636), new ThaiPuaMapping(3660, 63246, 63639), new ThaiPuaMapping(3640, 63256, 63643), new ThaiPuaMapping(3641, 63257, 63644), new ThaiPuaMapping(3642, 63258, 63645), new ThaiPuaMapping(0, 0, 0)};
    private static final ThaiPuaMapping[] SDL_MAPPINGS = new ThaiPuaMapping[]{new ThaiPuaMapping(3656, 63237, 63628), new ThaiPuaMapping(3657, 63238, 63631), new ThaiPuaMapping(3658, 63239, 63634), new ThaiPuaMapping(3659, 63240, 63637), new ThaiPuaMapping(3660, 63241, 63640), new ThaiPuaMapping(0, 0, 0)};
    private static final ThaiPuaMapping[] SL_MAPPINGS = new ThaiPuaMapping[]{new ThaiPuaMapping(3656, 63251, 63626), new ThaiPuaMapping(3657, 63252, 63629), new ThaiPuaMapping(3658, 63253, 63632), new ThaiPuaMapping(3659, 63254, 63635), new ThaiPuaMapping(3660, 63255, 63638), new ThaiPuaMapping(3633, 63248, 63620), new ThaiPuaMapping(3636, 63233, 63621), new ThaiPuaMapping(3637, 63234, 63622), new ThaiPuaMapping(3638, 63235, 63623), new ThaiPuaMapping(3639, 63236, 63624), new ThaiPuaMapping(3655, 63250, 63625), new ThaiPuaMapping(3661, 63249, 63641), new ThaiPuaMapping(0, 0, 0)};
    private static final ThaiPuaMapping[] RD_MAPPINGS = new ThaiPuaMapping[]{new ThaiPuaMapping(3597, 63247, 63642), new ThaiPuaMapping(3600, 63232, 63646), new ThaiPuaMapping(0, 0, 0)};
    private static final int[] THAI_ABOVE_START_STATE = new int[]{0, 1, 0, 0, 3};
    private static final ThaiAboveStateMachineEdge[][] THAI_ABOVE_STATE_MACHINE = new ThaiAboveStateMachineEdge[][]{{new ThaiAboveStateMachineEdge(0, 3), new ThaiAboveStateMachineEdge(0, 0), new ThaiAboveStateMachineEdge(1, 3)}, {new ThaiAboveStateMachineEdge(2, 2), new ThaiAboveStateMachineEdge(0, 1), new ThaiAboveStateMachineEdge(3, 2)}, {new ThaiAboveStateMachineEdge(0, 3), new ThaiAboveStateMachineEdge(0, 2), new ThaiAboveStateMachineEdge(2, 3)}, {new ThaiAboveStateMachineEdge(0, 3), new ThaiAboveStateMachineEdge(0, 3), new ThaiAboveStateMachineEdge(0, 3)}};
    private static final int[] THAI_BELOW_START_STATE = new int[]{0, 0, 1, 2, 2};
    private static final ThaiBelowStateMachineEdge[][] THAI_BELOW_STATE_MACHINE = new ThaiBelowStateMachineEdge[][]{{new ThaiBelowStateMachineEdge(0, 0), new ThaiBelowStateMachineEdge(0, 2), new ThaiBelowStateMachineEdge(0, 0)}, {new ThaiBelowStateMachineEdge(0, 1), new ThaiBelowStateMachineEdge(4, 2), new ThaiBelowStateMachineEdge(0, 1)}, {new ThaiBelowStateMachineEdge(0, 2), new ThaiBelowStateMachineEdge(1, 2), new ThaiBelowStateMachineEdge(0, 2)}};

    public static List<ThaiCluster> splitThaiGlyphLineIntoClusters(GlyphLine originalGlyphLine) {
        ArrayList<ThaiCluster> clusters = new ArrayList<ThaiCluster>();
        clusters.add(new ThaiCluster(originalGlyphLine));
        return clusters;
    }

    private static void doThaiPuaShaping(ThaiCluster cluster, TrueTypeFont font) {
        int above_state = THAI_ABOVE_START_STATE[4];
        int below_state = THAI_BELOW_START_STATE[4];
        int base = cluster.start;
        for (int i = cluster.start; i < cluster.end; ++i) {
            int action;
            int mt = ThaiShaper.getMarkType(cluster.get(i).getUnicode());
            if (mt == 3) {
                int ct = ThaiShaper.getConsonantType(cluster.get(i).getUnicode());
                above_state = THAI_ABOVE_START_STATE[ct];
                below_state = THAI_BELOW_START_STATE[ct];
                base = i;
                continue;
            }
            ThaiAboveStateMachineEdge aboveEdge = THAI_ABOVE_STATE_MACHINE[above_state][mt];
            ThaiBelowStateMachineEdge belowEdge = THAI_BELOW_STATE_MACHINE[below_state][mt];
            above_state = aboveEdge.getNextState();
            below_state = belowEdge.getNextState();
            int n = action = aboveEdge.getAction() != 0 ? aboveEdge.getAction() : belowEdge.getAction();
            if (action == 4) {
                cluster.set(base, font.getGlyph(ThaiShaper.thaiPuaShape(cluster.get(base).getUnicode(), action, (FontProgram)font)));
                continue;
            }
            cluster.set(i, font.getGlyph(ThaiShaper.thaiPuaShape(cluster.get(i).getUnicode(), action, (FontProgram)font)));
        }
    }

    public static boolean preprocessThaiText(TrueTypeFont font, ThaiCluster cluster, boolean foundScript) {
        boolean transformed = false;
        int idx = cluster.start;
        while (idx < cluster.end) {
            int start;
            int u = cluster.get(idx).getUnicode();
            if (!ThaiUtil.isSaraAm(u)) {
                ++idx;
                continue;
            }
            transformed = true;
            Glyph nikhahit = font.getGlyph(ThaiUtil.nikhahitFromSaraAm(u));
            cluster.add(idx, nikhahit);
            cluster.set(idx + 1, font.getGlyph(ThaiUtil.saraAAFromSaraAm(u)));
            ++cluster.end;
            int end = idx + 2;
            for (start = end - 2; start > 0 && ThaiUtil.isToneMark(cluster.get(start - 1).getUnicode()); --start) {
            }
            if (start + 2 >= end) continue;
            Glyph t = cluster.get(end - 2);
            cluster.memMove(start + 1, start, end - start - 2);
            cluster.set(start, t);
            StringBuilder actualTextBuilder = new StringBuilder();
            for (int i = start + 1; i <= end - 2; ++i) {
                actualTextBuilder.append(TextUtil.convertFromUtf32((int)cluster.get(i).getUnicode()));
            }
            actualTextBuilder.append(SARA_AM);
            cluster.setActualText(start, end, actualTextBuilder.toString());
        }
        if (!foundScript) {
            ThaiShaper.doThaiPuaShaping(cluster, font);
        }
        return transformed;
    }

    private static int thaiPuaShape(int u, int action, FontProgram font) {
        ThaiPuaMapping[] puaMappings = null;
        switch (action) {
            default: {
                assert (false);
            }
            case 0: {
                return u;
            }
            case 1: {
                puaMappings = SD_MAPPINGS;
                break;
            }
            case 3: {
                puaMappings = SDL_MAPPINGS;
                break;
            }
            case 2: {
                puaMappings = SL_MAPPINGS;
                break;
            }
            case 4: {
                puaMappings = RD_MAPPINGS;
            }
        }
        for (int i = 0; i < puaMappings.length; ++i) {
            if (puaMappings[i].u != u) continue;
            Glyph glyph = font.getGlyph(puaMappings[i].winPua);
            if (glyph != null && glyph.getCode() > 0) {
                return puaMappings[i].winPua;
            }
            glyph = font.getGlyph(puaMappings[i].macPua);
            if (glyph == null || glyph.getCode() <= 0) break;
            return puaMappings[i].macPua;
        }
        return u;
    }

    private static int getMarkType(int u) {
        if (u == 3633 || ThaiShaper.inRange(u, 3636, 3639) || u == 3655 || ThaiShaper.inRange(u, 3661, 3662)) {
            return 0;
        }
        if (ThaiShaper.inRange(u, 3640, 3642)) {
            return 1;
        }
        if (ThaiShaper.inRange(u, 3656, 3660)) {
            return 2;
        }
        return 3;
    }

    private static int getConsonantType(int u) {
        if (u == 3611 || u == 3613 || u == 3615) {
            return 1;
        }
        if (u == 3597 || u == 3600) {
            return 2;
        }
        if (u == 3598 || u == 3599) {
            return 3;
        }
        if (ThaiShaper.inRange(u, 3585, 3630)) {
            return 0;
        }
        return 4;
    }

    private static boolean inRange(int u, int lo, int hi) {
        return u >= lo && u - lo <= hi - lo;
    }
}

