/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.typography.bidi;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

public class BidiPBAAlgorithm {
    public static final byte n = 0;
    public static final byte o = 1;
    public static final byte c = 2;
    byte sos;
    LinkedList<Integer> openers;
    private Set<BracketPair> pairPositions;
    public byte[] codesIsolatedRun;
    private int[] indexes;

    public String getPairPositionsString() {
        TreeSet<BracketPair> tempPositions = new TreeSet<BracketPair>();
        for (BracketPair pair : this.pairPositions) {
            tempPositions.add(new BracketPair(this.indexes[pair.getOpener()], this.indexes[pair.getCloser()]));
        }
        return ((Object)tempPositions).toString();
    }

    private boolean matchOpener(int[] pairValues, int ichOpener, int ichCloser) {
        return pairValues[this.indexes[ichOpener]] == pairValues[this.indexes[ichCloser]];
    }

    private void removeHead(LinkedList<Integer> list, int index) {
        if (index < 0 || index > list.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + " Size: " + list.size());
        }
        for (int i = 0; i < index; ++i) {
            list.removeFirst();
        }
    }

    private void locateBrackets(byte[] pairTypes, int[] pairValues) {
        this.openers = new LinkedList();
        this.pairPositions = new TreeSet<BracketPair>();
        block5: for (int ich = 0; ich < this.indexes.length; ++ich) {
            switch (pairTypes[this.indexes[ich]]) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    this.openers.addFirst(ich);
                    continue block5;
                }
                case 2: {
                    if (this.openers.isEmpty()) continue block5;
                    int index = 0;
                    Iterator iterator = this.openers.iterator();
                    while (iterator.hasNext()) {
                        int opener = (Integer)iterator.next();
                        if (this.matchOpener(pairValues, opener, ich)) {
                            this.pairPositions.add(new BracketPair(opener, ich));
                            this.removeHead(this.openers, index + 1);
                            continue block5;
                        }
                        ++index;
                    }
                    continue block5;
                }
            }
        }
    }

    private byte getStrongTypeN0(int ich) {
        switch (this.codesIsolatedRun[ich]) {
            default: {
                return 18;
            }
            case 3: 
            case 4: 
            case 8: 
            case 11: {
                return 3;
            }
            case 0: 
        }
        return 0;
    }

    byte classifyPairContent(BracketPair pairedLocation, byte dirEmbed) {
        byte dirOpposite = 18;
        for (int ich = pairedLocation.getOpener() + 1; ich < pairedLocation.getCloser(); ++ich) {
            byte dir = this.getStrongTypeN0(ich);
            if (dir == 18) continue;
            if (dir == dirEmbed) {
                return dir;
            }
            dirOpposite = dir;
        }
        return dirOpposite;
    }

    byte classBeforePair(BracketPair pairedLocation) {
        for (int ich = pairedLocation.getOpener() - 1; ich >= 0; --ich) {
            byte dir = this.getStrongTypeN0(ich);
            if (dir == 18) continue;
            return dir;
        }
        return this.sos;
    }

    void assignBracketType(BracketPair pairedLocation, byte dirEmbed) {
        byte dirPair = this.classifyPairContent(pairedLocation, dirEmbed);
        if (dirPair == 18) {
            return;
        }
        if (dirPair != dirEmbed && ((dirPair = this.classBeforePair(pairedLocation)) == dirEmbed || dirPair == 18)) {
            dirPair = dirEmbed;
        }
        this.setBracketsToType(pairedLocation, dirPair);
    }

    private void setBracketsToType(BracketPair pairedLocation, byte dirPair) {
        this.codesIsolatedRun[pairedLocation.getOpener()] = dirPair;
        this.codesIsolatedRun[pairedLocation.getCloser()] = dirPair;
    }

    public void resolveBrackets(byte dirEmbed) {
        for (BracketPair pair : this.pairPositions) {
            this.assignBracketType(pair, dirEmbed);
        }
    }

    public void resolvePairedBrackets(int[] indexes, byte[] codes, byte[] pairTypes, int[] pairValues, byte sos, byte level) {
        byte dirEmbed = 1 == (level & 1) ? (byte)3 : 0;
        this.sos = sos;
        this.indexes = indexes;
        this.codesIsolatedRun = codes;
        this.locateBrackets(pairTypes, pairValues);
        this.resolveBrackets(dirEmbed);
    }

    public void runAlgorithm(byte[] codes, byte[] pairTypes, int[] pairValues, byte sos, byte level) {
        this.indexes = new int[codes.length];
        for (int ich = 0; ich < this.indexes.length; ++ich) {
            this.indexes[ich] = ich;
        }
        this.resolvePairedBrackets(this.indexes, codes, pairTypes, pairValues, sos, level);
    }

    public static final class BracketPair
    implements Comparable<BracketPair> {
        private int ichOpener;
        private int ichCloser;

        public BracketPair(int ichOpener, int ichCloser) {
            this.ichOpener = ichOpener;
            this.ichCloser = ichCloser;
        }

        public boolean equals(Object other) {
            if (other instanceof BracketPair) {
                BracketPair otherPair = (BracketPair)other;
                return this.ichOpener == otherPair.ichOpener && this.ichCloser == otherPair.ichCloser;
            }
            return false;
        }

        public int hashCode() {
            return this.ichOpener * 31 + this.ichCloser;
        }

        @Override
        public int compareTo(BracketPair otherPair) {
            if (this.ichOpener == otherPair.ichOpener) {
                return 0;
            }
            if (this.ichOpener < otherPair.ichOpener) {
                return -1;
            }
            return 1;
        }

        public String toString() {
            return "(" + this.ichOpener + ", " + this.ichCloser + ")";
        }

        public int getOpener() {
            return this.ichOpener;
        }

        public int getCloser() {
            return this.ichCloser;
        }
    }
}

