/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import java.util.ArrayList;

public class PageNo {
    private ArrayList<Integer> m_pageNos = new ArrayList();
    private ArrayList<Count> m_numberOfPages = new ArrayList();
    private int m_index = 0;
    private int m_pass = 1;
    private int m_prevPageNo = 0;
    private int m_currentPageNo = -1;
    private Count m_currentCount = new Count();

    public void nextPage(int pass) {
        this.m_pass = pass;
        ++this.m_index;
        if (this.m_pass == 1) {
            this.m_prevPageNo = this.m_currentPageNo;
        }
    }

    public void reset(int pass) {
        this.m_pass = pass;
        this.m_index = 0;
        this.m_currentPageNo = -1;
    }

    public void setText(String text) {
        if (this.m_pass == 1) {
            try {
                if (text == null || text.isEmpty()) {
                    return;
                }
                int pageNo = Integer.parseInt(text.trim());
                this.m_pageNos.add(this.m_index, pageNo);
                this.m_currentPageNo = pageNo;
                if (pageNo <= this.m_prevPageNo) {
                    this.m_currentCount = new Count();
                }
                this.m_currentCount.set(pageNo);
                this.m_numberOfPages.add(this.m_index, this.m_currentCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getText() {
        if (this.m_pageNos.size() <= this.m_index) {
            return "";
        }
        return "" + this.m_pageNos.get(this.m_index);
    }

    public int getNumberOfPages() {
        if (this.m_numberOfPages.size() <= this.m_index) {
            return 0;
        }
        Count count = this.m_numberOfPages.get(this.m_index);
        if (count == null) {
            return 0;
        }
        return count.get();
    }

    public int getCurrentPageNo() {
        return this.m_pageNos.get(this.m_index);
    }

    public boolean isUsed() {
        return this.m_pageNos.size() > 0;
    }

    private class Count {
        private int m_count = 0;

        private Count() {
        }

        public void set(int count) {
            this.m_count = count;
        }

        public int get() {
            return this.m_count;
        }
    }
}

