/*
 * Decompiled with CFR 0.152.
 */
package com.ssaglobal.bml;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSelectorStrategy;
import com.itextpdf.layout.font.FontSet;
import com.ssaglobal.bml.FileCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NotoMapper
extends FontProvider {
    private File m_directory;
    private boolean m_debug = false;
    private ArrayList m_debugLines = new ArrayList();
    private PdfFont m_latinFont;
    private PdfFont m_monospaceLatinFont;
    public static final Glyph DUMMY = new Glyph(-1, -1, new char[]{'a'});
    private HashMap<String, PdfFont> m_fonts = new HashMap();
    private PdfFont m_arialUni;
    private int m_koreanCount = 0;
    private int m_japaneseCount = 0;
    private int m_chineseCount = 0;
    private String m_reportLang = "2";

    public NotoMapper(File directory, boolean debug) {
        this.m_directory = directory;
        this.m_debug = debug;
        File fontFile = new File(this.m_directory, this.getNotoFileName("LATIN"));
        try {
            this.m_latinFont = this.createFont(fontFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        this.m_koreanCount = 0;
        this.m_japaneseCount = 0;
        this.m_chineseCount = 0;
        this.m_reportLang = "2";
    }

    public void setReportLanguage(String reportLang) {
        if (reportLang == null) {
            reportLang = "2";
        }
        this.m_reportLang = reportLang;
    }

    private PdfFont createFont(File fontFile) throws IOException {
        if (this.m_debug) {
            this.m_debugLines.add("About to load font: " + fontFile.getName());
            this.m_debugLines.add("free memory before load: " + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
        }
        fontFile = FileCache.getInstance().getLocalFile(fontFile.getAbsolutePath());
        PdfFont font = PdfFontFactory.createFont((String)fontFile.getAbsolutePath(), (String)"Identity-H", (boolean)false);
        if (this.m_debug) {
            this.m_debugLines.add("free memory after load: " + Runtime.getRuntime().freeMemory() / 0x100000L + "m");
        }
        return font;
    }

    public List<String> getDebugLines() {
        return this.m_debugLines;
    }

    public void next(CurrentFont current) {
        if (current.m_remainderTxt == null || current.m_remainderTxt.isEmpty()) {
            current.m_txt = "";
            current.m_font = this.m_latinFont;
            return;
        }
        int i = 0;
        char c = current.m_remainderTxt.charAt(i);
        String block = this.getUnicodeBlock(c);
        String block2 = null;
        while (i < current.m_remainderTxt.length() - 1 && block.equals(block2 = this.getUnicodeBlock(c = current.m_remainderTxt.charAt(++i)))) {
        }
        if (i == current.m_remainderTxt.length() - 1) {
            if (block.equals(block2)) {
                ++i;
            } else if (block2 == null) {
                ++i;
            }
        }
        current.m_txt = current.m_remainderTxt.substring(0, i);
        current.m_remainderTxt = current.m_remainderTxt.substring(i);
        if (block.equals("LATIN")) {
            this.setLatinFont(current);
        } else {
            File fontFile = new File(this.m_directory, this.getNotoFileName(block));
            if (!fontFile.exists()) {
                this.setLatinFont(current);
                return;
            }
            try {
                current.m_font = this.m_fonts.get(fontFile.getAbsolutePath());
                if (current.m_font == null) {
                    current.m_font = this.createFont(fontFile);
                    this.m_fonts.put(fontFile.getAbsolutePath(), current.m_font);
                }
            }
            catch (Exception e) {
                this.setLatinFont(current);
                this.m_fonts.put(fontFile.getAbsolutePath(), current.m_font);
            }
        }
    }

    private void setLatinFont(CurrentFont current) {
        if (current.m_monospace && this.m_monospaceLatinFont == null) {
            try {
                this.m_monospaceLatinFont = this.createFont(new File(this.m_directory, this.getNotoFileName("Mono", "ttf")));
            }
            catch (Exception e) {
                this.m_monospaceLatinFont = this.m_latinFont;
            }
        }
        current.m_font = current.m_monospace ? this.m_monospaceLatinFont : this.m_latinFont;
    }

    private String getNotoFileName(String block) {
        if (block.equals("LATIN")) {
            return this.getNotoFileName("", "ttf");
        }
        if (block.equals("KOREAN")) {
            return this.getNotoFileName("CJKkr", "otf");
        }
        if (block.equals("JAPANESE")) {
            return this.getNotoFileName("CJKjp", "otf");
        }
        if (block.equals("CHINESE")) {
            return this.getNotoFileName("CJKsc", "otf");
        }
        String fileName = block.toString().substring(0, 1) + block.toString().toLowerCase().substring(1);
        return this.getNotoFileName(fileName, "ttf");
    }

    private String getUnicodeBlockExceptCJK(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        if (block.toString().contains("LATIN")) {
            return "LATIN";
        }
        if (block.toString().contains("HANGUL")) {
            ++this.m_koreanCount;
            return "KOREAN";
        }
        if (block.toString().contains("ARABIC")) {
            return "ARABIC";
        }
        if (block == Character.UnicodeBlock.HIRAGANA || block == Character.UnicodeBlock.KATAKANA) {
            ++this.m_japaneseCount;
            return "JAPANESE";
        }
        if (block.toString().contains("CJK")) {
            return null;
        }
        if (block == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || block == Character.UnicodeBlock.NUMBER_FORMS) {
            ++this.m_chineseCount;
            return "CHINESE";
        }
        if (block == Character.UnicodeBlock.ENCLOSED_ALPHANUMERICS || block == Character.UnicodeBlock.ALPHABETIC_PRESENTATION_FORMS) {
            return "SYMBOLS";
        }
        String b = block.toString();
        int index = b.indexOf(95);
        if (index != -1) {
            b = b.substring(0, index - 1);
        }
        return b;
    }

    private String getUnicodeBlock(char c) {
        String block = this.getUnicodeBlockExceptCJK(c);
        if (block != null) {
            return block;
        }
        if (this.m_reportLang.equalsIgnoreCase("j")) {
            return "JAPANESE";
        }
        if (this.m_reportLang.equalsIgnoreCase("k")) {
            return "KOREAN";
        }
        if (this.m_reportLang.equalsIgnoreCase("n")) {
            return "CHINESE";
        }
        if (this.m_reportLang.equalsIgnoreCase("o")) {
            return "CHINESE";
        }
        if (this.m_koreanCount > this.m_chineseCount && this.m_koreanCount > this.m_japaneseCount) {
            return "KOREAN";
        }
        if (this.m_japaneseCount > this.m_chineseCount) {
            return "JAPANESE";
        }
        return "CHINESE";
    }

    private String getNotoFileName(String name, String extension) {
        return "NotoSans" + name + "-Regular." + extension;
    }

    public FontSelectorStrategy getStrategy(String text, List<String> fontFamilies) {
        return new NotoFontSelectorStrategy(text, this, null, fontFamilies.size() > 0);
    }

    public class ArialUniFontSelectorStrategy
    extends FontSelectorStrategy {
        private String m_txt;

        protected ArialUniFontSelectorStrategy(String text, FontProvider provider, FontSet tempFonts) {
            super(text, provider, tempFonts);
            this.m_txt = text;
            if (NotoMapper.this.m_arialUni == null) {
                try {
                    NotoMapper.this.m_arialUni = NotoMapper.this.createFont(new File("c:/windows/fonts/arialuni.ttf"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public PdfFont getCurrentFont() {
            return NotoMapper.this.m_arialUni;
        }

        public List<Glyph> nextGlyphs() {
            ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
            for (int i = 0; i < this.m_txt.length(); ++i) {
                glyphs.add(DUMMY);
            }
            this.m_txt = "";
            return glyphs;
        }
    }

    public class NotoFontSelectorStrategy
    extends FontSelectorStrategy {
        private CurrentFont m_current;

        protected NotoFontSelectorStrategy(String text, FontProvider provider, FontSet tempFonts, boolean monospace) {
            super(text, provider, tempFonts);
            this.m_current = new CurrentFont();
            this.m_current.m_remainderTxt = text;
            this.m_current.m_monospace = monospace;
        }

        public PdfFont getCurrentFont() {
            return this.m_current.m_font;
        }

        public List<Glyph> nextGlyphs() {
            NotoMapper.this.next(this.m_current);
            ArrayList<Glyph> glyphs = new ArrayList<Glyph>();
            for (int i = 0; i < this.m_current.m_txt.length(); ++i) {
                glyphs.add(DUMMY);
            }
            return glyphs;
        }
    }

    public static class CurrentFont {
        public PdfFont m_font;
        public String m_txt;
        public String m_remainderTxt;
        public boolean m_monospace;
    }
}

